/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.faceunit;

import asap.utils.AnimationSync;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.KeyPositionManager;
import hmi.elckerlyc.planunit.KeyPositionManagerImpl;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.model.MPEG4Configuration;
import hmi.faceengine.faceunit.FUPlayException;
import hmi.faceengine.faceunit.FaceUnit;
import hmi.faceengine.faceunit.TimedFaceUnit;
import hmi.util.StringUtil;
import java.util.List;

public class PlutchikFU
implements FaceUnit {
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private float intensity = 1.0f;
    private float angle = -1.0f;
    private float activation = -1.0f;
    private FaceController faceController;
    private EmotionConverter emotionConverter;
    private MPEG4Configuration config = null;

    public PlutchikFU() {
        KeyPosition ready = new KeyPosition("ready", 0.1, 1.0);
        KeyPosition relax = new KeyPosition("relax", 0.9, 1.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        this.addKeyPosition(start);
        this.addKeyPosition(ready);
        this.addKeyPosition(relax);
        this.addKeyPosition(end);
    }

    public void setFaceController(FaceController fc) {
        this.faceController = fc;
    }

    public void setEmotionConverter(EmotionConverter ec) {
        this.emotionConverter = ec;
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterException {
        if (name.equals("intensity")) {
            this.intensity = value;
        } else if (name.equals("angle")) {
            this.angle = value;
        } else if (name.equals("activation")) {
            this.activation = value;
        } else {
            throw new ParameterNotFoundException(name);
        }
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new InvalidParameterException(name, value);
        }
        this.setFloatParameterValue(name, Float.parseFloat(value));
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("intensity")) {
            return "" + this.intensity;
        }
        if (name.equals("angle")) {
            return "" + this.angle;
        }
        if (name.equals("activation")) {
            return "" + this.activation;
        }
        return null;
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterException {
        if (name.equals("intensity")) {
            return this.intensity;
        }
        if (name.equals("angle")) {
            return this.angle;
        }
        if (name.equals("activation")) {
            return this.activation;
        }
        throw new ParameterNotFoundException(name);
    }

    @Override
    public boolean hasValidParameters() {
        return this.angle >= 0.0f && this.angle <= 360.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) throws FUPlayException {
        double ready = this.getKeyPosition((String)"ready").time;
        double relax = this.getKeyPosition((String)"relax").time;
        float newAppliedWeight = 0.0f;
        if (t < ready && t > 0.0) {
            newAppliedWeight = this.intensity * (float)(t / ready);
        } else if (t >= ready && t <= relax) {
            newAppliedWeight = this.intensity;
        } else if (t > relax && t < 1.0) {
            newAppliedWeight = this.intensity * (float)(1.0 - (t - relax) / (1.0 - relax));
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            if (this.config != null) {
                this.faceController.removeMPEG4Configuration(this.config);
            }
            this.config = this.emotionConverter.convert(this.angle, this.activation * newAppliedWeight);
            this.faceController.addMPEG4Configuration(this.config);
        }
    }

    @Override
    public void cleanup() {
        if (this.config != null) {
            this.faceController.removeMPEG4Configuration(this.config);
        }
        this.config = null;
    }

    @Override
    public TimedFaceUnit createTFU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new TimedFaceUnit(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public FaceUnit copy(FaceController fc, FACSConverter fconv, EmotionConverter econv) {
        PlutchikFU result = new PlutchikFU();
        result.setFaceController(fc);
        result.setEmotionConverter(econv);
        result.intensity = this.intensity;
        result.angle = this.angle;
        result.activation = this.activation;
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        return result;
    }

    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

