/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.faceunit;

import asap.utils.AnimationSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.KeyPositionManager;
import hmi.elckerlyc.planunit.KeyPositionManagerImpl;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.model.ActionUnit;
import hmi.faceanimation.model.FACS;
import hmi.faceanimation.model.FACSConfiguration;
import hmi.faceanimation.model.MPEG4Configuration;
import hmi.faceengine.faceunit.FUPlayException;
import hmi.faceengine.faceunit.FaceUnit;
import hmi.faceengine.faceunit.TimedFaceUnit;
import hmi.util.StringUtil;
import java.util.List;

public class AUFU
implements FaceUnit {
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private AUFUSide side = null;
    private int aunr = -1;
    private float intensity = -1.0f;
    private FACSConfiguration facsConfig = new FACSConfiguration();
    private FaceController faceController;
    private FACSConverter facsConverter;
    private final MPEG4Configuration mpeg4Config = new MPEG4Configuration();

    public AUFU() {
        KeyPosition ready = new KeyPosition("ready", 0.1, 1.0);
        KeyPosition relax = new KeyPosition("relax", 0.9, 1.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        this.addKeyPosition(start);
        this.addKeyPosition(ready);
        this.addKeyPosition(relax);
        this.addKeyPosition(end);
    }

    public void setFaceController(FaceController fc) {
        this.faceController = fc;
    }

    public void setFACSConverter(FACSConverter fc) {
        this.facsConverter = fc;
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterException {
        if (!name.equals("intensity")) {
            throw new ParameterNotFoundException(name);
        }
        this.intensity = value;
        this.setAU(this.side, this.aunr, this.intensity);
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (name.equals("au")) {
            this.aunr = Integer.parseInt(value);
        } else if (name.equals("side")) {
            this.side = AUFUSide.BOTH;
            if (value.equals("LEFT")) {
                this.side = AUFUSide.LEFT;
            } else if (value.equals("RIGHT")) {
                this.side = AUFUSide.RIGHT;
            }
        } else if (StringUtil.isNumeric((String)value)) {
            this.setFloatParameterValue(name, Float.parseFloat(value));
        } else {
            throw new InvalidParameterException(name, value);
        }
        this.setAU(this.side, this.aunr, this.intensity);
    }

    @Override
    public String getParameterValue(String name) throws ParameterException {
        if (name.equals("side")) {
            if (this.side == null) {
                throw new ParameterNotFoundException(name);
            }
            return "" + (Object)((Object)this.side);
        }
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterException {
        if (name.equals("intensity")) {
            return this.intensity;
        }
        if (name.equals("au")) {
            return this.aunr;
        }
        throw new ParameterNotFoundException(name);
    }

    @Override
    public boolean hasValidParameters() {
        ActionUnit au = FACS.getActionUnit((int)this.aunr);
        if (au == null) {
            return false;
        }
        if (this.intensity > 1.0f) {
            return false;
        }
        if (au.getSymmetry() != ActionUnit.Symmetry.ASYMMETRIC) {
            return this.side == AUFUSide.BOTH || this.side == null;
        }
        return this.side != null;
    }

    public void setAU(AUFUSide s, int i, float intens) {
        this.side = s;
        this.aunr = i;
        this.intensity = intens;
        if (!this.hasValidParameters()) {
            return;
        }
        this.facsConfig = new FACSConfiguration();
        ActionUnit au = FACS.getActionUnit((int)this.aunr);
        if (au.getSymmetry() != ActionUnit.Symmetry.ASYMMETRIC) {
            this.facsConfig.setValue(FACS.Side.NONE, au.getIndex(), this.intensity);
        } else {
            if (this.side == AUFUSide.LEFT) {
                this.facsConfig.setValue(FACS.Side.LEFT, au.getIndex(), this.intensity);
            }
            if (this.side == AUFUSide.RIGHT) {
                this.facsConfig.setValue(FACS.Side.RIGHT, au.getIndex(), this.intensity);
            }
            if (this.side == AUFUSide.BOTH) {
                this.facsConfig.setValue(FACS.Side.LEFT, au.getIndex(), this.intensity);
                this.facsConfig.setValue(FACS.Side.RIGHT, au.getIndex(), this.intensity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) throws FUPlayException {
        double ready = this.getKeyPosition((String)"ready").time;
        double relax = this.getKeyPosition((String)"relax").time;
        float newAppliedWeight = 0.0f;
        if (t < ready && t > 0.0) {
            newAppliedWeight = this.intensity * (float)(t / ready);
        } else if (t >= ready && t <= relax) {
            newAppliedWeight = this.intensity;
        } else if (t > relax && t < 1.0) {
            newAppliedWeight = this.intensity * (float)(1.0 - (t - relax) / (1.0 - relax));
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.faceController.removeMPEG4Configuration(this.mpeg4Config);
            this.facsConverter.convert(this.facsConfig, this.mpeg4Config);
            this.mpeg4Config.multiply(newAppliedWeight);
            this.faceController.addMPEG4Configuration(this.mpeg4Config);
        }
    }

    @Override
    public void cleanup() {
        if (this.mpeg4Config != null) {
            this.faceController.removeMPEG4Configuration(this.mpeg4Config);
        }
    }

    @Override
    public TimedFaceUnit createTFU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new TimedFaceUnit(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public FaceUnit copy(FaceController fc, FACSConverter fconv, EmotionConverter econv) {
        AUFU result = new AUFU();
        result.setFaceController(fc);
        result.setFACSConverter(fconv);
        result.setAU(this.side, this.aunr, this.intensity);
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        return result;
    }

    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }

    static enum AUFUSide {
        LEFT,
        RIGHT,
        BOTH;

    }
}

