/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.faceunit;

import hmi.animation.AnimationSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.KeyPositionManager;
import hmi.elckerlyc.planunit.KeyPositionManagerImpl;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.model.FACSConfiguration;
import hmi.faceanimation.model.MPEG4Configuration;
import hmi.faceengine.faceunit.FUPlayException;
import hmi.faceengine.faceunit.FaceUnit;
import hmi.faceengine.faceunit.TimedFaceUnit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;

public class RemoteFACSFU
extends Thread
implements FaceUnit {
    private static final String HOST = "130.89.228.90";
    private static final int PORT = 9123;
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private float intensity = 1.0f;
    private FACSConfiguration facsConfig = new FACSConfiguration();
    private FaceController faceController;
    private FACSConverter facsConverter;
    private final MPEG4Configuration mpeg4Config = new MPEG4Configuration();
    private Float[] faceValues;
    private BufferedReader in;

    public void connectToServer() {
        try {
            Socket socket = new Socket(HOST, 9123);
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.out.println("Unknown host 130.89.228.90");
            this.in = null;
        }
        catch (IOException e) {
            System.out.println("Could not connect to 130.89.228.90");
            this.in = null;
        }
        if (this.in != null) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String[] recValues;
            if (this.in == null) {
                continue;
            }
            String line = null;
            try {
                line = this.in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.in = null;
            }
            if (line == null || (recValues = line.split(" ")).length != 84) continue;
            RemoteFACSFU remoteFACSFU = this;
            synchronized (remoteFACSFU) {
                this.faceValues = new Float[84];
                for (int i = 0; i < 84; ++i) {
                    this.faceValues[i] = Float.valueOf(recValues[i]);
                }
            }
        }
    }

    public void setFaceController(FaceController fc) {
        this.faceController = fc;
    }

    public void setFACSConverter(FACSConverter fc) {
        this.facsConverter = fc;
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterException {
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
    }

    @Override
    public String getParameterValue(String name) throws ParameterException {
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterException {
        throw new ParameterNotFoundException(name);
    }

    @Override
    public boolean hasValidParameters() {
        return this.facsConfig != null;
    }

    public void setConfig(FACSConfiguration fc) {
        this.facsConfig = fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) throws FUPlayException {
        if (this.in == null) {
            this.connectToServer();
        }
        if (this.faceValues == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            Float[] faceValuesCopy = (Float[])this.faceValues.clone();
            try {
                this.facsConfig.setValues(faceValuesCopy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        object = AnimationSync.getSync();
        synchronized (object) {
            this.faceController.removeMPEG4Configuration(this.mpeg4Config);
            this.facsConverter.convert(this.facsConfig, this.mpeg4Config);
            this.faceController.addMPEG4Configuration(this.mpeg4Config);
        }
    }

    @Override
    public void cleanup() {
        if (this.mpeg4Config != null) {
            this.faceController.removeMPEG4Configuration(this.mpeg4Config);
        }
    }

    @Override
    public TimedFaceUnit createTFU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new TimedFaceUnit(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public FaceUnit copy(FaceController fc, FACSConverter fconv, EmotionConverter econv) {
        RemoteFACSFU result = new RemoteFACSFU();
        result.setFaceController(fc);
        result.setFACSConverter(fconv);
        result.intensity = this.intensity;
        result.setConfig(this.facsConfig);
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        return result;
    }

    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

