/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.facebinding;

import hmi.faceanimation.model.FACSConfiguration;
import hmi.faceengine.faceunit.AUFU;
import hmi.faceengine.faceunit.FACSFU;
import hmi.faceengine.faceunit.FaceUnit;
import hmi.faceengine.faceunit.MorphFU;
import hmi.faceengine.faceunit.PlutchikFU;
import hmi.faceengine.faceunit.RemoteFACSFU;
import hmi.faceengine.faceunit.RemoteMPEG4FU;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.Reader;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FaceUnitAssembler
extends XMLStructureAdapter {
    private static Logger logger = LoggerFactory.getLogger((String)FaceUnitAssembler.class.getName());
    private FaceUnit faceUnit;
    private static final String XMLTAG = "FaceUnit";

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String type = this.getRequiredAttribute("type", attrMap, tokenizer);
        if (type.equals("Morph")) {
            MorphFU fu = new MorphFU();
            this.faceUnit = fu;
        } else if (type.equals("Plutchik")) {
            PlutchikFU fu = new PlutchikFU();
            this.faceUnit = fu;
        } else if (type.equals("AU")) {
            AUFU fu = new AUFU();
            this.faceUnit = fu;
        } else if (type.equals("RemoteFACS")) {
            RemoteFACSFU rfu = new RemoteFACSFU();
            this.faceUnit = rfu;
        } else if (type.equals("RemoteMPEG4")) {
            RemoteMPEG4FU mfu = new RemoteMPEG4FU();
            this.faceUnit = mfu;
        } else if (type.equals("FACS")) {
            FACSFU fu = new FACSFU();
            this.faceUnit = fu;
            String filename = this.getRequiredAttribute("filename", attrMap, null);
            FACSConfiguration fc = new FACSConfiguration();
            try {
                fc.readXML((Reader)new Resources("").getReader(filename));
                fu.setConfig(fc);
            }
            catch (Exception e) {
                this.faceUnit = null;
                logger.warn("Cannot read FACS configuration from file \"{}\"; error: {}", (Object)filename, (Object)e.getMessage());
            }
        } else {
            logger.warn("Cannot read FaceUnit type \"{}\" in FaceBinding; omitting this FaceUnit", (Object)type);
        }
    }

    public FaceUnit getFaceUnit() {
        return this.faceUnit;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

