/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.viseme;

import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class VisemeToMorphMapping
extends XMLStructureAdapter {
    private HashMap<Integer, String> mappings = new HashMap();
    private static final String XMLTAG = "VisemeToMorphMapping";

    public String getMorphTargetForViseme(int vis) {
        return this.mappings.get(vis);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals("Mapping")) {
                throw new XMLScanException("Unknown element in VisemeToMorphMapping: " + tag);
            }
            HashMap attrMap = tokenizer.getAttributes();
            int viseme = this.getRequiredIntAttribute("viseme", attrMap, tokenizer);
            String target = this.getRequiredAttribute("target", attrMap, tokenizer);
            this.mappings.put(viseme, target);
            tokenizer.takeSTag("Mapping");
            tokenizer.takeETag("Mapping");
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

