/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.faceunit;

import hmi.animation.AnimationSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.KeyPositionManager;
import hmi.elckerlyc.planunit.KeyPositionManagerImpl;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceengine.faceunit.FUPlayException;
import hmi.faceengine.faceunit.FaceUnit;
import hmi.faceengine.faceunit.TimedFaceUnit;
import hmi.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphFU
implements FaceUnit {
    private float intensity = 1.0f;
    private String targetName = "";
    private static Logger logger = LoggerFactory.getLogger((String)MorphFU.class.getName());
    private boolean multiple = false;
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private String[] morphTargets = new String[]{""};
    private FaceController faceController;
    private float prevMorphedWeight = 0.0f;

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public MorphFU() {
        KeyPosition ready = new KeyPosition("ready", 0.1, 1.0);
        KeyPosition relax = new KeyPosition("relax", 0.9, 1.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        this.addKeyPosition(start);
        this.addKeyPosition(ready);
        this.addKeyPosition(relax);
        this.addKeyPosition(end);
    }

    public void setFaceController(FaceController fc) {
        this.faceController = fc;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterNotFoundException {
        if (!name.equals("intensity")) {
            throw new ParameterNotFoundException(name);
        }
        this.intensity = value;
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (name.equals("targetname")) {
            this.targetName = value;
            this.updateMorphTargets();
        } else if (name.equals("multiple")) {
            this.multiple = Boolean.parseBoolean(value);
            this.updateMorphTargets();
        } else if (StringUtil.isNumeric((String)value)) {
            this.setFloatParameterValue(name, Float.parseFloat(value));
        } else {
            throw new InvalidParameterException(name, value);
        }
    }

    @Override
    public String getParameterValue(String name) throws ParameterException {
        if (name.equals("targetname")) {
            return "" + this.targetName;
        }
        if (name.equals("multiple")) {
            return "" + this.multiple;
        }
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterException {
        if (name.equals("intensity")) {
            return this.intensity;
        }
        throw new ParameterNotFoundException(name);
    }

    @Override
    public boolean hasValidParameters() {
        return true;
    }

    private void updateMorphTargets() {
        this.morphTargets = !this.multiple ? new String[]{this.targetName} : this.targetName.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) throws FUPlayException {
        logger.debug("Playing FU at time={}", (Object)t);
        double ready = this.getKeyPosition((String)"ready").time;
        double relax = this.getKeyPosition((String)"relax").time;
        float newMorphedWeight = 0.0f;
        if (t < ready && t > 0.0) {
            newMorphedWeight = this.intensity * (float)(t / ready);
        } else if (t >= ready && t <= relax) {
            newMorphedWeight = this.intensity;
        } else if (t > relax && t < 1.0) {
            newMorphedWeight = this.intensity * (float)(1.0 - (t - relax) / (1.0 - relax));
        }
        float[] prevWeights = new float[this.morphTargets.length];
        for (int i = 0; i < prevWeights.length; ++i) {
            prevWeights[i] = this.prevMorphedWeight;
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.faceController.removeMorphTargets(this.morphTargets, prevWeights);
            logger.debug("RemoveWeight=" + this.prevMorphedWeight);
            logger.debug("NewWeight=" + newMorphedWeight);
            logger.debug("target: " + Arrays.toString(this.morphTargets));
            float[] newWeights = new float[this.morphTargets.length];
            for (int i = 0; i < newWeights.length; ++i) {
                newWeights[i] = newMorphedWeight;
            }
            this.faceController.addMorphTargets(this.morphTargets, newWeights);
        }
        this.prevMorphedWeight = newMorphedWeight;
    }

    @Override
    public void cleanup() {
        float[] prevWeights = new float[this.morphTargets.length];
        for (int i = 0; i < prevWeights.length; ++i) {
            prevWeights[i] = this.prevMorphedWeight;
        }
        this.faceController.removeMorphTargets(this.morphTargets, prevWeights);
        this.prevMorphedWeight = 0.0f;
    }

    @Override
    public TimedFaceUnit createTFU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new TimedFaceUnit(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public FaceUnit copy(FaceController fc, FACSConverter fconv, EmotionConverter econv) {
        MorphFU result = new MorphFU();
        result.setFaceController(fc);
        result.intensity = this.intensity;
        result.targetName = this.targetName;
        result.multiple = this.multiple;
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        result.updateMorphTargets();
        return result;
    }

    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

