/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.util;

import hmi.faceanimation.model.MPEG4Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XfaceInterface
extends Thread {
    private MPEG4Configuration configuration;
    private Integer[] values = new Integer[68];
    private Logger logger = LoggerFactory.getLogger((String)XfaceInterface.class.getName());
    private State state;
    private Socket socket;
    private PrintWriter out;
    private InputStream in;
    private int taskId = 1;
    private int ownerId;
    private int port = 50011;
    private int sleeptime = 500;
    private boolean stopThread = false;

    public XfaceInterface(int newPort) {
        this.setState(State.START);
        this.port = newPort;
    }

    public void connect() {
        this.setState(State.CONNECTING);
        this.start();
        try {
            this.socket = new Socket("127.0.0.1", this.port);
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = this.socket.getInputStream();
            StringBuffer inputBuffer = new StringBuffer();
            do {
                inputBuffer.append((char)this.in.read());
            } while (this.in.available() >= 1);
            String inputLine = inputBuffer.toString();
            Pattern pattern = Pattern.compile("<notify name=\"CONNECTION_OK\" ownerId=\"([0-9]+)\" taskId=\"[0-9]+\" status=\"[0-9]+\"/>.*");
            Matcher matcher = pattern.matcher(inputLine);
            if (!matcher.matches()) {
                throw new Exception("Invalid reply: " + inputLine);
            }
            this.ownerId = Integer.parseInt(matcher.group(1));
            this.timedPrint("Connection made, ownerId=" + this.ownerId);
            this.setState(State.STANDBY);
        }
        catch (Exception e) {
            this.setState(State.ERROR);
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.out == null) {
            return;
        }
        this.out.close();
        try {
            this.in.close();
            this.socket.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.setState(State.CONNECTION_CLOSED);
        this.stopThread = true;
    }

    public boolean isStandby() {
        return this.state == State.STANDBY;
    }

    public void setConfiguration(MPEG4Configuration configuration) {
        this.configuration = configuration;
        this.values = configuration.getValues();
        this.setState(State.DIRTY);
    }

    public void setRawValues(Integer[] values) {
        this.values = values;
        this.setState(State.DIRTY);
    }

    private void sendConfiguration() {
        int i;
        StringBuffer task = new StringBuffer();
        task.append("<task name=\"UPLOAD_FAP\" ownerId=\"" + this.ownerId + "\" taskId=\"");
        task.append(this.taskId);
        task.append("\"><param>");
        task.append("2.1 C:\\Users\\balci\\Work\\FACE\\exml2fap\\files\\TempFile 25 1\n");
        for (i = 0; i < this.values.length; ++i) {
            if (i == 0 || i == 1 || this.values[i] == null) {
                task.append(0);
            } else {
                task.append(1);
            }
            if (i >= this.values.length) continue;
            task.append(' ');
        }
        task.append("\n0 ");
        for (i = 0; i < this.values.length; ++i) {
            if (i == 0 || i == 1 || this.values[i] == null) continue;
            task.append(this.values[i]);
            task.append(' ');
        }
        task.append("</param></task>");
        this.sendTask(this.taskId++, "UPLOAD_FAP", task.toString());
    }

    private void displayConfiguration() {
        StringBuffer task = new StringBuffer();
        task.append("<task name=\"STOP_PLAYBACK\" ownerId=\"" + this.ownerId + "\" taskId=\"");
        task.append(this.taskId);
        task.append("\" status=\"0\"></task>");
        this.sendTask(this.taskId++, "STOP_PLAYBACK", task.toString());
    }

    private void sendTask(int taskId, String task, String xml) {
        if (this.out == null) {
            return;
        }
        this.setState(State.SENDING_TASK);
        this.out.write(xml);
        this.out.flush();
        try {
            this.in.skip(this.in.available());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setState(State.STANDBY);
    }

    private void setState(State state) {
        this.state = state;
    }

    private void timedPrint(String message) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        DateFormat df = DateFormat.getTimeInstance(2);
        DecimalFormat mdf = new DecimalFormat("000");
        String milliseconds = mdf.format(cal.get(14));
        String time = df.format(cal.getTime()) + "." + milliseconds;
        this.logger.debug("[ {} ] {}", (Object)time, (Object)message);
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        XfaceInterface.sleep(250L);
        while (true) {
            XfaceInterface.sleep(this.sleeptime);
            if (this.stopThread) break;
            if (!this.communicationNeeded()) continue;
            this.communicate();
        }
    }

    private boolean communicationNeeded() {
        return this.state == State.DIRTY;
    }

    private void communicate() {
        this.sendConfiguration();
        XfaceInterface.sleep(this.sleeptime);
        this.displayConfiguration();
        this.setState(State.STANDBY);
        if (this.configuration != null) {
            this.logger.debug(this.configuration.toString());
        }
    }

    private static enum State {
        START,
        CONNECTING,
        STANDBY,
        DIRTY,
        SENDING_TASK,
        CONNECTION_CLOSED,
        ERROR;

    }
}

