/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.model;

import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.FeaturePoint;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MPEG4 {
    private static LinkedHashMap<Integer, FAP> faps;
    private static LinkedHashMap<String, FeaturePoint> fps;

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[MPEG4, list of Facial Animation Parameters:\n");
        for (FAP fap : faps.values()) {
            retval.append("\t");
            retval.append(fap.toString());
            retval.append("\n");
        }
        retval.append("]");
        return retval.toString();
    }

    public static HashMap<Integer, FAP> getFAPs() {
        return faps;
    }

    public static FAP getFAP(int number) {
        return faps.get(number);
    }

    public static HashMap<String, FeaturePoint> getFeaturePoints() {
        return fps;
    }

    public static FeaturePoint getFeaturePoint(String fp) {
        return fps.get(fp);
    }

    static {
        String line;
        BufferedReader br;
        String filename;
        faps = new LinkedHashMap();
        fps = new LinkedHashMap();
        try {
            filename = "feature_points.txt";
            br = new Resources("Humanoids/shared/mpeg4face/").getReader(filename);
            while ((line = br.readLine()) != null) {
                if (line.length() < 3 || line.substring(0, 1).equals("#")) continue;
                fps.put(line, new FeaturePoint(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            filename = "facial_animation_parameters.txt";
            br = new Resources("Humanoids/shared/mpeg4face/").getReader(filename);
            int index = 0;
            HashMap<FAP, Integer> otherSides = new HashMap<FAP, Integer>();
            while ((line = br.readLine()) != null) {
                String[] elts = line.split("\t");
                if (elts.length == 7 || elts.length == 8) {
                    FAP.Directionality directionality = FAP.Directionality.NA;
                    if (elts[4].equals("U")) {
                        directionality = FAP.Directionality.UNIDIRECTIONAL;
                    } else if (elts[4].equals("B")) {
                        directionality = FAP.Directionality.BIDIRECTIONAL;
                    }
                    FAP.Direction direction = null;
                    direction = elts[5].equals("concave upward") ? FAP.Direction.CONCAVE_UPWARD : FAP.Direction.valueOf(elts[5].toUpperCase());
                    int number = Integer.valueOf(elts[0]);
                    FAP fap = new FAP(index++, number, elts[1], elts[2], FAP.Unit.valueOf(elts[3]), directionality, direction, MPEG4.getFeaturePoint(elts[6]));
                    faps.put(number, fap);
                    if (elts.length != 8) continue;
                    otherSides.put(fap, Integer.parseInt(elts[7]));
                    continue;
                }
                if (elts.length != 4) continue;
                int number = Integer.valueOf(elts[0]);
                faps.put(number, new FAP(index++, number, elts[1], elts[2], MPEG4.getFeaturePoint(elts[3])));
            }
            for (Map.Entry entry : otherSides.entrySet()) {
                int otherSide = (Integer)entry.getValue();
                ((FAP)entry.getKey()).setOtherSide(faps.get(otherSide));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

