/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.model;

import hmi.faceanimation.model.ActionUnit;
import hmi.faceanimation.model.Configuration;
import hmi.faceanimation.model.FACS;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class FACSConfiguration
extends XMLStructureAdapter
implements Configuration {
    private Float[] values;
    private int numAus = FACS.getActionUnits().size();
    private static final String XMLTAG = "FACSConfiguration";

    public FACSConfiguration() {
        this.values = new Float[this.numAus * 2];
    }

    public void setValue(FACS.Side side, int index, float value) {
        if (side == FACS.Side.RIGHT) {
            index += this.numAus;
        }
        this.values[index] = Float.valueOf(value);
    }

    public Float getValue(FACS.Side side, int index) {
        if (side == FACS.Side.RIGHT) {
            index += this.numAus;
        }
        return this.values[index];
    }

    public void setValues(Float[] values) throws Exception {
        if (values.length != this.numAus * 2) {
            throw new Exception("wrong number of values");
        }
        this.values = values;
    }

    public Float[] getValues() {
        return this.values;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        ActionUnit au;
        int i;
        for (i = 0; i < this.numAus; ++i) {
            if (this.values[i] == null) continue;
            au = FACS.getActionUnitsByIndex().get(i);
            if (au.getSymmetry() != ActionUnit.Symmetry.ASYMMETRIC) {
                this.appendAU(au.getNumber(), FACS.Side.NONE, this.values[i], buf, fmt);
                continue;
            }
            this.appendAU(au.getNumber(), FACS.Side.LEFT, this.values[i], buf, fmt);
        }
        for (i = this.numAus; i < 2 * this.numAus - 1; ++i) {
            if (this.values[i] == null || (au = FACS.getActionUnitsByIndex().get(i - this.numAus)).getSymmetry() != ActionUnit.Symmetry.ASYMMETRIC) continue;
            this.appendAU(au.getNumber(), FACS.Side.RIGHT, this.values[i], buf, fmt);
        }
        return buf;
    }

    public StringBuilder appendAU(int number, FACS.Side s, Float value, StringBuilder buf, XMLFormatting fmt) {
        FACSConfiguration.appendEmptyTag((StringBuilder)buf, (XMLFormatting)fmt, (String)"AU", (String)"number", (String)("" + number), (String)"side", (String)("" + (Object)((Object)s)), (String)"value", (String)value.toString());
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag("AU")) {
            HashMap attrMap = tokenizer.getAttributes();
            int number = this.getRequiredIntAttribute("number", attrMap, tokenizer);
            String s = this.getRequiredAttribute("side", attrMap, tokenizer);
            FACS.Side side = FACS.Side.NONE;
            if (s.equals("LEFT")) {
                side = FACS.Side.LEFT;
            } else if (s.equals("RIGHT")) {
                side = FACS.Side.RIGHT;
            }
            float value = this.getRequiredFloatAttribute("value", attrMap, tokenizer);
            int index = FACS.getActionUnit(number).getIndex();
            if (s.equals("RIGHT")) {
                index += this.numAus;
            }
            this.values[index] = Float.valueOf(value);
            tokenizer.takeSTag("AU");
            tokenizer.takeETag("AU");
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

