/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters.ui;

import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.converters.ui.AUSlider;
import hmi.faceanimation.converters.ui.ConfigListener;
import hmi.faceanimation.model.ActionUnit;
import hmi.faceanimation.model.FACS;
import hmi.faceanimation.model.FACSConfiguration;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class FACSPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 3118834458010380447L;
    FACSConfiguration config;
    private ArrayList<ConfigListener> configListeners = new ArrayList();
    private AUSlider[] sliders;
    private int numAus;

    public FACSPanel(FACSConfiguration config, FACSConverter facsConverter) {
        this.config = config;
        this.numAus = FACS.getActionUnits().size();
        this.sliders = new AUSlider[this.numAus * 2];
        Color color = new Color(0, 0, 0);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.weightx = 1.0;
        this.addLabel("", layout, constraints, color);
        this.addLabel("Right", layout, constraints, color);
        constraints.gridwidth = 0;
        this.addLabel("Left", layout, constraints, color);
        constraints.fill = 1;
        HashMap<Integer, ActionUnit> aus = FACS.getActionUnits();
        for (ActionUnit au : aus.values()) {
            color = facsConverter.getNumberOfInfluences(au) == 0 ? new Color(127, 127, 127) : new Color(0, 0, 0);
            constraints.gridwidth = 1;
            this.addLabel(au.getNumber() + ": " + au.getName(), layout, constraints, color);
            if (au.getSymmetry() == ActionUnit.Symmetry.ASYMMETRIC) {
                this.addSlider(au, FACS.Side.RIGHT, layout, constraints, color);
                constraints.gridwidth = 0;
                this.addSlider(au, FACS.Side.LEFT, layout, constraints, color);
                continue;
            }
            constraints.gridwidth = 0;
            this.addSlider(au, FACS.Side.NONE, layout, constraints, color);
        }
        JButton saveButton = new JButton("SAVE");
        saveButton.addActionListener(new SaveListener());
        this.add(saveButton);
        JButton loadButton = new JButton("LOAD");
        loadButton.addActionListener(new LoadListener());
        this.add(loadButton);
    }

    protected void addSlider(ActionUnit au, FACS.Side side, GridBagLayout layout, GridBagConstraints constraints, Color color) {
        AUSlider slider = new AUSlider(au, side);
        slider.setForeground(color);
        layout.setConstraints(slider, constraints);
        slider.addChangeListener(this);
        this.add(slider);
        int index = au.getIndex();
        if (side == FACS.Side.RIGHT) {
            index += this.numAus;
        }
        this.sliders[index] = slider;
    }

    protected void setConfig(FACSConfiguration fc) {
        this.config = fc;
        for (int i = 0; i < 2 * this.numAus - 1; ++i) {
            Float val = fc.getValues()[i];
            if (val != null) {
                if (this.sliders[i] == null) continue;
                this.sliders[i].setValue((int)(val.floatValue() * 100.0f));
                continue;
            }
            if (this.sliders[i] == null) continue;
            this.sliders[i].setValue(0);
        }
    }

    protected void addLabel(String text, GridBagLayout layout, GridBagConstraints constraints, Color color) {
        JLabel label = new JLabel(text);
        label.setForeground(color);
        layout.setConstraints(label, constraints);
        this.add(label);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        AUSlider source = (AUSlider)event.getSource();
        ActionUnit au = source.getActionUnit();
        this.config.setValue(source.getSide(), au.getIndex(), source.getAUValue());
        this.fireConfigChanged();
    }

    public void addConfigListener(ConfigListener cl) {
        this.configListeners.add(cl);
    }

    public void removeConfigListener(ConfigListener cl) {
        this.configListeners.remove(cl);
    }

    public void fireConfigChanged() {
        for (ConfigListener cl : this.configListeners) {
            cl.configChanged(this.config);
        }
    }

    class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            JFileChooser chooser = new JFileChooser(".");
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "FACS configs (.xml)";
                }
            });
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
                try {
                    PrintWriter pw = new PrintWriter(f);
                    FACSPanel.this.config.writeXML(pw);
                    pw.close();
                }
                catch (IOException ex) {
                    System.out.println("Error writing file; see stack trace for more info.");
                    ex.printStackTrace();
                }
            }
        }
    }

    class LoadListener
    implements ActionListener {
        LoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            JFileChooser chooser = new JFileChooser(".");
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "FACS configs (.xml)";
                }
            });
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
                FileReader r;
                try {
                    r = new FileReader(f);
                }
                catch (FileNotFoundException e1) {
                    System.out.println("File not found; see stack trace for more info.");
                    e1.printStackTrace();
                    return;
                }
                try {
                    FACSPanel.this.config.readXML(r);
                    FACSPanel.this.setConfig(FACSPanel.this.config);
                }
                catch (IOException ex) {
                    System.out.println("Error reading file; see stack trace for more info.");
                    ex.printStackTrace();
                }
                try {
                    r.close();
                }
                catch (IOException e1) {
                    System.out.println("Error closing file; see stack trace for more info.");
                    e1.printStackTrace();
                }
            }
        }
    }
}

