/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters.ui;

import hmi.faceanimation.converters.ui.ActivationListener;
import hmi.faceanimation.converters.ui.AngleListener;
import hmi.faceanimation.converters.ui.ParameterListener;
import hmi.util.Resources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class EmotionWheelPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 322877579547536179L;
    private BufferedImage image;
    private int center_x = 245;
    private int center_y = 275;
    private int radius = 235;
    private float angle;
    private float activation;
    static final float MAX_ACTIVATION = 7.0f;
    private ArrayList<ActivationListener> activationListeners = new ArrayList();
    private ArrayList<AngleListener> angleListeners = new ArrayList();
    private ArrayList<ParameterListener> parameterListeners = new ArrayList();

    public EmotionWheelPanel() {
        try {
            String filename = "Humanoids/shared/mpeg4face/emotion_wheel_plutchik.png";
            BufferedInputStream is = new Resources("").getInputStream(filename);
            this.image = ImageIO.read(is);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.image, 0, 0, null);
    }

    private void calculateStuff(int x, int y) {
        float old_angle = this.angle;
        float old_activation = this.activation;
        this.calculateAngle(x, y);
        this.calculateActivation(x, y);
        if (this.angle != old_angle || this.activation != old_activation) {
            this.fireParameterChanged();
        }
    }

    private void calculateAngle(int x, int y) {
        float old_angle = this.angle;
        this.angle = (float)(Math.atan2(y - this.center_y, x - this.center_x) * 180.0 / Math.PI);
        this.angle += 45.0f;
        if (this.angle < 0.0f) {
            this.angle += 360.0f;
        }
        if (this.angle != old_angle) {
            this.fireAngleChanged();
        }
    }

    private void calculateActivation(int x, int y) {
        float old_activation = this.activation;
        int dx = this.center_x - x;
        int dy = this.center_y - y;
        double distance = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        this.activation = (float)((double)this.radius - distance) / ((float)this.radius * 0.9f);
        if (this.activation < 0.0f) {
            this.activation = 0.0f;
        }
        if (this.activation > 1.0f) {
            this.activation = 1.0f;
        }
        this.activation *= 7.0f;
        if (this.activation != old_activation) {
            this.fireActivationChanged();
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public float getActivation() {
        return this.activation;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.calculateStuff(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.calculateStuff(e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void addActivationListener(ActivationListener al) {
        this.activationListeners.add(al);
    }

    public void removeActivationListener(ActivationListener al) {
        this.activationListeners.remove(al);
    }

    public void fireActivationChanged() {
        for (ActivationListener al : this.activationListeners) {
            al.activationChanged(this.activation);
        }
    }

    public void addAngleListener(AngleListener al) {
        this.angleListeners.add(al);
    }

    public void removeAngleListener(AngleListener al) {
        this.angleListeners.remove(al);
    }

    public void fireAngleChanged() {
        for (AngleListener al : this.angleListeners) {
            al.angleChanged(this.angle);
        }
    }

    public void addParameterListener(ParameterListener pl) {
        this.parameterListeners.add(pl);
    }

    public void removeParameterListener(ParameterListener pl) {
        this.parameterListeners.remove(pl);
    }

    public void fireParameterChanged() {
        for (ParameterListener pl : this.parameterListeners) {
            pl.parameterChanged(this.angle, this.activation);
        }
    }
}

