/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters.ui;

import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.ui.ActivationListener;
import hmi.faceanimation.converters.ui.AngleListener;
import hmi.faceanimation.converters.ui.EmotionWheelPanel;
import hmi.faceanimation.converters.ui.JLink;
import hmi.faceanimation.converters.ui.ParameterListener;
import hmi.faceanimation.model.MPEG4Configuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EmotionPanel
extends JPanel
implements ParameterListener {
    private static final long serialVersionUID = 8365008904970611946L;
    private EmotionConverter emotionConverter;
    private MPEG4Configuration mpeg4Config = new MPEG4Configuration();
    private FaceController faceController;

    public EmotionPanel(EmotionConverter ec, FaceController fc) {
        this.faceController = fc;
        this.emotionConverter = ec;
        this.setLayout(new BorderLayout());
        EmotionWheelPanel ewp = new EmotionWheelPanel();
        this.add((Component)ewp, "Center");
        JPanel infoPanel = new JPanel(new GridLayout(0, 1));
        final JLabel labelAngle = new JLabel();
        ewp.addAngleListener(new AngleListener(){

            @Override
            public void angleChanged(float angle) {
                labelAngle.setText("Angle: " + new DecimalFormat("###").format(angle) + "\u00c2\u00b0");
            }
        });
        infoPanel.add(labelAngle);
        final JLabel labelActivation = new JLabel();
        ewp.addActivationListener(new ActivationListener(){

            @Override
            public void activationChanged(float activation) {
                labelActivation.setText("Activation: " + new DecimalFormat("0.00").format(activation));
            }
        });
        infoPanel.add(labelActivation);
        for (EmotionConverter.AE ae : EmotionConverter.AE.values()) {
            int numProfiles = this.emotionConverter.getNumProfiles(ae);
            for (int i = 0; i < numProfiles; ++i) {
                JLink linkProfile = new JLink(ae.getFriendlyName() + " #" + (i + 1), ae, i);
                linkProfile.addMouseListener(new ProfileChoiceMouseListener(this.emotionConverter, ewp));
                infoPanel.add(linkProfile);
            }
        }
        this.add((Component)infoPanel, "East");
        ewp.addParameterListener(this);
    }

    @Override
    public void parameterChanged(float angle, float activation) {
        this.faceController.removeMPEG4Configuration(this.mpeg4Config);
        this.mpeg4Config = this.emotionConverter.convert(angle, activation);
        this.faceController.addMPEG4Configuration(this.mpeg4Config);
    }

    public void clear() {
        this.faceController.removeMPEG4Configuration(this.mpeg4Config);
        this.mpeg4Config = new MPEG4Configuration();
    }

    class ProfileChoiceMouseListener
    implements MouseListener {
        private EmotionConverter ec;
        private EmotionWheelPanel ewp;

        public ProfileChoiceMouseListener(EmotionConverter ec, EmotionWheelPanel ewp) {
            this.ec = ec;
            this.ewp = ewp;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JLink linkProfile = (JLink)e.getSource();
            EmotionConverter.AE ae = linkProfile.getAE();
            int index = linkProfile.getIndex();
            this.ec.setPreferredProfile(ae, index);
            EmotionPanel.this.parameterChanged(this.ewp.getAngle(), this.ewp.getActivation());
        }
    }
}

