/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters;

import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.MPEG4;
import hmi.faceanimation.model.MPEG4Configuration;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmotionConverter {
    private static Logger logger = LoggerFactory.getLogger((String)EmotionConverter.class.getName());
    HashMap<AE, ArrayList<Profile>> profiles = new HashMap();
    HashMap<AE, Integer> preferredProfiles = new HashMap();
    private ArrayList<FAP> fapsEverUsed = new ArrayList();
    private float aeWidth = 22.5f;
    private AE primaryAE = AE.NONE;
    private AE secondaryAE = AE.NONE;

    public EmotionConverter() {
        this(new Resources(""), "Humanoids/shared/mpeg4face/raouzaiou_data_mods.txt");
    }

    public EmotionConverter(Resources r, String filename) {
        this.loadRanges(r, filename);
        for (AE ae : AE.values()) {
            this.setPreferredProfile(ae, 0);
        }
    }

    public int getNumProfiles(AE ae) {
        if (!this.profiles.containsKey((Object)ae)) {
            return 0;
        }
        return this.profiles.get((Object)ae).size();
    }

    public void setPreferredProfile(AE ae, int preferredProfile) {
        this.preferredProfiles.put(ae, preferredProfile);
    }

    public int getPreferredProfile(AE ae) {
        return this.preferredProfiles.get((Object)ae);
    }

    public MPEG4Configuration convert(float angle, float activation) {
        Category category = this.convertDetermineCategory(angle);
        Profile profile = category == Category.SIMILAR ? this.convertSimilar(angle, activation) : this.convertInBetween(angle, activation);
        HashMap<Integer, FAP> faps = MPEG4.getFAPs();
        Integer[] values = new Integer[faps.size()];
        int i = 0;
        for (FAP fap : faps.values()) {
            Integer value;
            if (profile.containsKey(fap)) {
                int min = ((Range)profile.get((Object)fap)).min;
                int max = ((Range)profile.get((Object)fap)).max;
                int length = max - min;
                value = min + length / 2;
                if (!this.fapsEverUsed.contains(fap)) {
                    this.fapsEverUsed.add(fap);
                }
            } else if (this.fapsEverUsed.contains(fap)) {
                value = 0;
                this.fapsEverUsed.remove(fap);
            } else {
                value = null;
            }
            values[i] = value;
            ++i;
        }
        MPEG4Configuration config = new MPEG4Configuration();
        config.setValues(values);
        return config;
    }

    private Category convertDetermineCategory(float angle) {
        Category category = Category.UNKNOWN;
        float aeSubwidth = this.aeWidth / 2.0f;
        for (AE aev : AE.values()) {
            if (aev == AE.NONE || !(angle > aev.angle - aeSubwidth) || !(angle < aev.angle + aeSubwidth)) continue;
            category = Category.SIMILAR;
            this.primaryAE = aev;
            break;
        }
        if (category == Category.UNKNOWN) {
            category = Category.IN_BETWEEN;
            if (angle > AE.JOY.angle || angle < AE.FEAR.angle) {
                this.primaryAE = AE.JOY;
                this.secondaryAE = AE.FEAR;
            } else if (angle > AE.ANGER.angle) {
                this.primaryAE = AE.ANGER;
                this.secondaryAE = AE.JOY;
            } else if (angle > AE.DISGUST.angle) {
                this.primaryAE = AE.DISGUST;
                this.secondaryAE = AE.ANGER;
            } else if (angle > AE.SADNESS.angle) {
                this.primaryAE = AE.SADNESS;
                this.secondaryAE = AE.DISGUST;
            } else if (angle > AE.SURPRISE.angle) {
                this.primaryAE = AE.SURPRISE;
                this.secondaryAE = AE.SADNESS;
            } else if (angle > AE.FEAR.angle) {
                this.primaryAE = AE.FEAR;
                this.secondaryAE = AE.SURPRISE;
            }
        }
        if (category == Category.SIMILAR) {
            // empty if block
        }
        return category;
    }

    private Profile convertSimilar(float angle, float activation) {
        Profile profileOut = new Profile();
        int preferredProfile = this.getPreferredProfile(this.primaryAE);
        Profile profileIn = this.profiles.get((Object)this.primaryAE).get(preferredProfile);
        float ratio = activation / this.primaryAE.activation;
        for (Map.Entry entry : profileIn.entrySet()) {
            Range rangeIn = (Range)entry.getValue();
            int minOut = (int)((float)rangeIn.min * ratio);
            int maxOut = (int)((float)rangeIn.max * ratio);
            if (minOut == 0 && maxOut == 0) continue;
            profileOut.put(entry.getKey(), new Range(minOut, maxOut));
        }
        return profileOut;
    }

    private Profile convertInBetween(float angle, float activation) {
        Profile profileOut = new Profile();
        int preferredProfilePrimary = this.getPreferredProfile(this.primaryAE);
        Profile profilePrimaryIn = this.profiles.get((Object)this.primaryAE).get(preferredProfilePrimary);
        int preferredProfileSecondary = this.getPreferredProfile(this.secondaryAE);
        Profile profileSecondaryIn = this.profiles.get((Object)this.secondaryAE).get(preferredProfileSecondary);
        Profile profilePrimary = new Profile();
        Profile profileSecondary = new Profile();
        ArrayList<FAP> vocabulary = new ArrayList<FAP>();
        for (FAP key : profilePrimaryIn.keySet()) {
            if (vocabulary.indexOf(key) != -1) continue;
            vocabulary.add(key);
        }
        for (FAP key : profileSecondaryIn.keySet()) {
            if (vocabulary.indexOf(key) != -1) continue;
            vocabulary.add(key);
        }
        float ratioPrimary = activation / this.primaryAE.activation;
        for (FAP key : profilePrimaryIn.keySet()) {
            Range rangePrimary = (Range)profilePrimaryIn.get(key);
            int minOut = (int)((float)rangePrimary.min * ratioPrimary);
            int maxOut = (int)((float)rangePrimary.max * ratioPrimary);
            if (minOut == 0 && maxOut == 0) continue;
            profilePrimary.put(key, new Range(minOut, maxOut));
        }
        float ratioSecondary = activation / this.secondaryAE.activation;
        for (FAP key : profileSecondaryIn.keySet()) {
            Range rangeSecondary = (Range)profileSecondaryIn.get(key);
            int minOut = (int)((float)rangeSecondary.min * ratioSecondary);
            int maxOut = (int)((float)rangeSecondary.max * ratioSecondary);
            if (minOut == 0 && maxOut == 0) continue;
            profileSecondary.put(key, new Range(minOut, maxOut));
        }
        float primAngle = this.primaryAE.angle;
        float secAngle = this.secondaryAE.angle;
        float calAngle = angle;
        if (secAngle < primAngle) {
            secAngle += 360.0f;
        }
        if (calAngle < primAngle) {
            calAngle += 360.0f;
        }
        float angleTotal = secAngle - primAngle - this.aeWidth;
        assert (angleTotal > 0.0f);
        float angleRatioSecondary = (calAngle - primAngle - this.aeWidth / 2.0f) / angleTotal;
        float angleRatioPrimary = (secAngle - calAngle - this.aeWidth / 2.0f) / angleTotal;
        for (FAP key : vocabulary) {
            Range rangePrimary;
            if (profilePrimary.containsKey(key) && profileSecondary.containsKey(key)) {
                rangePrimary = (Range)profilePrimary.get(key);
                Range rangeSecondary = (Range)profileSecondary.get(key);
                profileOut.put(key, this.mergeRanges(key, profileOut, rangePrimary, rangeSecondary, angleRatioPrimary, angleRatioSecondary));
                continue;
            }
            if (profilePrimary.containsKey(key)) {
                rangePrimary = (Range)profilePrimary.get(key);
                profileOut.put(key, this.mergeRanges(key, profileOut, rangePrimary, new Range(0, 0), angleRatioPrimary, angleRatioSecondary));
                continue;
            }
            if (!profileSecondary.containsKey(key)) continue;
            Range rangeSecondary = (Range)profileSecondary.get(key);
            profileOut.put(key, this.mergeRanges(key, profileOut, new Range(0, 0), rangeSecondary, angleRatioPrimary, angleRatioSecondary));
        }
        return profileOut;
    }

    private Range mergeRanges(FAP key, Profile profileOut, Range rangePrimary, Range rangeSecondary, float angleRatioPrimary, float angleRatioSecondary) {
        Range rangeOut = new Range();
        int lengthPrimary = rangePrimary.max - rangePrimary.min;
        float midpointPrimary = rangePrimary.min + lengthPrimary / 2;
        int lengthSecondary = rangeSecondary.max - rangeSecondary.min;
        float midpointSecondary = rangeSecondary.min + lengthSecondary / 2;
        int length = (int)(angleRatioPrimary * (float)lengthPrimary + angleRatioSecondary * (float)lengthSecondary);
        int midpoint = (int)(angleRatioPrimary * midpointPrimary + angleRatioSecondary * midpointSecondary);
        rangeOut.min = midpoint - length / 2;
        rangeOut.max = midpoint + length / 2;
        return rangeOut;
    }

    private void loadRanges(Resources r, String filename) {
        try {
            String line;
            BufferedReader br = r.getReader(filename);
            AE archetypalEmotion = null;
            while ((line = br.readLine()) != null) {
                String[] elts;
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                if (line.startsWith("Anger") || line.startsWith("Sadness") || line.startsWith("Joy") || line.startsWith("Disgust") || line.startsWith("Fear") || line.startsWith("Surprise")) {
                    archetypalEmotion = null;
                    elts = line.split("\\s+");
                    if (elts.length == 2) {
                        archetypalEmotion = AE.valueOf(elts[0].toUpperCase());
                    }
                    if (this.profiles.get((Object)archetypalEmotion) != null) continue;
                    this.profiles.put(archetypalEmotion, new ArrayList());
                    continue;
                }
                if (!line.matches("F[0-9]+.*")) continue;
                line = line.replaceAll("\\s", "");
                elts = line.split("\\],");
                Profile profile = new Profile();
                for (String elt : elts) {
                    String[] subelts = elt.split("\\[");
                    int fapNumber = Integer.parseInt(subelts[0].substring(1));
                    String[] subsubelts = subelts[1].split(",");
                    int min = Integer.parseInt(subsubelts[0]);
                    if (subsubelts[1].charAt(subsubelts[1].length() - 1) == ']') {
                        subsubelts[1] = subsubelts[1].substring(0, subsubelts[1].length() - 1);
                    }
                    int max = Integer.parseInt(subsubelts[1]);
                    Range range = new Range();
                    range.min = min;
                    range.max = max;
                    profile.put(MPEG4.getFAPs().get(fapNumber), range);
                }
                this.profiles.get((Object)archetypalEmotion).add(profile);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum Category {
        UNKNOWN,
        SIMILAR,
        IN_BETWEEN;

    }

    private static class Profile
    extends HashMap<FAP, Range> {
        private static final long serialVersionUID = 8370761547051241453L;

        private Profile() {
        }
    }

    private static class Range {
        public int min;
        public int max;

        public String toString() {
            return "[" + this.min + ", " + this.max + "]";
        }

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public Range() {
        }
    }

    public static enum AE {
        NONE("[none]", -1.0f, -1.0f),
        ANGER("Anger", 225.0f, 4.2f),
        SADNESS("Sadness", 135.0f, 3.8f),
        JOY("Joy", 315.0f, 5.4f),
        DISGUST("Disgust", 180.0f, 5.0f),
        FEAR("Fear", 45.0f, 4.9f),
        SURPRISE("Surprise", 90.0f, 6.5f);

        String friendlyName;
        float angle;
        float activation;

        private AE(String friendlyName, float angle, float activation) {
            this.friendlyName = friendlyName;
            this.angle = angle;
            this.activation = activation;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }
}

