/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.model;

import hmi.faceanimation.model.ActionUnit;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class FACS {
    private static LinkedHashMap<Integer, ActionUnit> actionUnits = new LinkedHashMap();
    private static LinkedHashMap<Integer, ActionUnit> actionUnitsByIndex = new LinkedHashMap();

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[FACS, list of Action Units:\n");
        for (ActionUnit actionUnit : actionUnits.values()) {
            retval.append("\t");
            retval.append(actionUnit.toString());
            retval.append("\n");
        }
        retval.append("]");
        return retval.toString();
    }

    public static HashMap<Integer, ActionUnit> getActionUnits() {
        return actionUnits;
    }

    public static HashMap<Integer, ActionUnit> getActionUnitsByIndex() {
        return actionUnitsByIndex;
    }

    public static ActionUnit getActionUnit(int number) {
        return actionUnits.get(number);
    }

    static {
        try {
            String line;
            String filename = "action_units.txt";
            BufferedReader br = new Resources("Humanoids/shared/mpeg4face/").getReader(filename);
            int index = 0;
            while ((line = br.readLine()) != null) {
                ActionUnit au;
                ActionUnit.Symmetry symmetry;
                int number;
                String[] elts = line.split("\t");
                if (elts.length == 3) {
                    number = Integer.valueOf(elts[0]);
                    symmetry = elts[1].equals("S") ? ActionUnit.Symmetry.SYMMETRIC : ActionUnit.Symmetry.ASYMMETRIC;
                    au = new ActionUnit(index, number, symmetry, elts[2]);
                    actionUnits.put(number, au);
                    actionUnitsByIndex.put(index, au);
                    ++index;
                    continue;
                }
                if (elts.length != 4) continue;
                number = Integer.valueOf(elts[0]);
                symmetry = elts[1].equals("S") ? ActionUnit.Symmetry.SYMMETRIC : ActionUnit.Symmetry.ASYMMETRIC;
                au = new ActionUnit(index, number, symmetry, elts[2], elts[3]);
                actionUnits.put(number, au);
                actionUnitsByIndex.put(index, au);
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum Side {
        NONE,
        LEFT,
        RIGHT;

    }
}

