/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.model;

import hmi.faceanimation.model.Configuration;
import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.MPEG4;
import hmi.xml.XMLStructureAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class MPEG4Configuration
extends XMLStructureAdapter
implements Configuration {
    private Integer[] values;
    private static final String XMLTAG = "MPEG4Configuration";

    public MPEG4Configuration() {
        int numFaps = MPEG4.getFAPs().size();
        this.values = new Integer[numFaps];
    }

    public void setValue(int index, Integer value) {
        this.values[index] = value;
    }

    public Integer getValue(int index) {
        return this.values[index];
    }

    public void setValues(Integer[] values) {
        if (values.length == this.values.length) {
            this.values = values;
        } else {
            System.err.println("wrong number of values");
        }
    }

    public void addValues(MPEG4Configuration config) {
        Integer[] values = config.getValues();
        if (values.length == this.values.length) {
            for (int i = 0; i < values.length; ++i) {
                if (this.values[i] == null) {
                    this.values[i] = values[i];
                    continue;
                }
                if (values[i] == null) continue;
                this.values[i] = this.values[i] + values[i];
            }
        } else {
            System.err.println("wrong number of values");
        }
    }

    public void multiply(float factor) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            this.values[i] = (int)((float)this.values[i].intValue() * factor);
        }
    }

    public void removeValues(MPEG4Configuration config) {
        Integer[] values = config.getValues();
        if (values.length == this.values.length) {
            for (int i = 0; i < values.length; ++i) {
                if (this.values[i] == null) {
                    this.values[i] = values[i];
                    continue;
                }
                if (values[i] == null) continue;
                this.values[i] = this.values[i] - values[i];
            }
        } else {
            System.err.println("wrong number of values");
        }
    }

    public Integer[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (FAP fap : MPEG4.getFAPs().values()) {
            Integer value = this.values[fap.getIndex()];
            if (value == null) continue;
            sb.append(fap.getName() + "=" + value + " ");
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public void saveToFAPFile(File file) throws IOException {
        int numberOfFrames = 100;
        FileWriter fw = new FileWriter(file);
        StringBuilder sb = new StringBuilder();
        sb.append("2.1 dummy 25 100\n");
        for (int j = 0; j < 100; ++j) {
            int i;
            for (i = 0; i < this.values.length; ++i) {
                if (i == 0 || i == 1 || this.values[i] == null) {
                    sb.append(0);
                } else {
                    sb.append(1);
                }
                if (i >= this.values.length) continue;
                sb.append(' ');
            }
            sb.append("\n");
            sb.append(j);
            sb.append(' ');
            for (i = 0; i < this.values.length; ++i) {
                if (i == 0 || i == 1 || this.values[i] == null) continue;
                sb.append(this.values[i]);
                sb.append(' ');
            }
            sb.append("\n");
        }
        fw.write(sb.toString());
        fw.close();
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

