/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.model;

import hmi.animation.VJoint;
import hmi.faceanimation.model.Head;
import hmi.math.Quat4f;

public class Eye {
    private VJoint joint;
    private float au;
    private Head head;
    public boolean leftSide;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private float thrust = 0.0f;

    public Eye(VJoint joint, Head head, boolean leftSide) {
        this.joint = joint;
        this.head = head;
        this.leftSide = leftSide;
        this.au = head.getFAPU("AU");
    }

    public void setPitchValue(float value) {
        this.pitch = value * this.au;
    }

    public void setYawValue(float value) {
        this.yaw = value * this.au;
    }

    public void setThrustValue(float value) {
        this.thrust = value * this.head.getFAPU("ES");
    }

    public void copy() {
        float[] q = new float[4];
        Quat4f.setFromRollPitchYaw((float[])q, (float)0.0f, (float)(-this.pitch), (float)this.yaw);
        this.joint.setRotation(q);
        this.joint.setTranslation(new float[]{0.0f, 0.0f, this.thrust});
    }
}

