/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters.ui;

import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.ui.FapTableModel;
import hmi.faceanimation.converters.ui.ValueEditor;
import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.MPEG4;
import hmi.faceanimation.model.MPEG4Configuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

public class MPEG4ControllerFrame
extends JFrame
implements ActionListener,
MouseMotionListener,
TableModelListener {
    private static final long serialVersionUID = 2585351165270261988L;
    private FapTableModel tableModel;
    private JTable fapTable;
    private int fapValueEditRow = -1;
    HashMap<Integer, FAP> faps = MPEG4.getFAPs();
    Integer[] valuesOut = new Integer[this.faps.size()];
    private ArrayList<FAP> fapsEverUsed = new ArrayList();
    private FaceController faceController = null;

    public MPEG4ControllerFrame(FaceController fc) {
        this.faceController = fc;
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new FapTableModel(MPEG4.getFAPs());
        final ValueEditor valueEditor = new ValueEditor();
        this.fapTable = new JTable(this.tableModel){
            private static final long serialVersionUID = 3273984920824254762L;

            @Override
            public TableCellEditor getCellEditor(int row, int col) {
                if (col == 2) {
                    return valueEditor;
                }
                return super.getCellEditor(row, col);
            }
        };
        this.fapTable.setRowHeight(35);
        this.fapTable.setAutoResizeMode(0);
        this.fapTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.fapTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.fapTable.getColumnModel().getColumn(2).setPreferredWidth(525);
        this.fapTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.fapTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.fapTable.addMouseMotionListener(this);
        this.tableModel.addTableModelListener(this);
        JScrollPane scrollPane = new JScrollPane(this.fapTable);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton dumpButton = new JButton("Dump ranges");
        dumpButton.setActionCommand("dump");
        dumpButton.addActionListener(this);
        buttonPanel.add(dumpButton);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        JButton saveMpeg4Config = new JButton("Save this MPEG4 FAP configuration");
        saveMpeg4Config.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MPEG4Configuration configuration = new MPEG4Configuration();
                configuration.setValues(MPEG4ControllerFrame.this.valuesOut);
                JFileChooser fc = new JFileChooser();
                int retval = fc.showSaveDialog(null);
                if (retval == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        configuration.saveToFAPFile(file);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        buttonPanel.add(saveMpeg4Config);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setPreferredSize(new Dimension(900, 450));
        this.setLocation(50, 50);
        this.setTitle("MPEG4 controller");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("send")) {
            this.doSend();
        } else if (command.equals("dump")) {
            this.dumpRanges(this.tableModel);
        } else if (command.equals("close")) {
            this.dispose();
        }
    }

    private void doSend() {
        int[] values = this.tableModel.getValues();
        for (FAP fap : this.faps.values()) {
            int fapIndex = fap.getIndex();
            int value = values[fapIndex];
            if (value != 0) {
                if (!this.fapsEverUsed.contains(fap)) {
                    this.fapsEverUsed.add(fap);
                }
                this.valuesOut[fapIndex] = value;
                continue;
            }
            if (this.fapsEverUsed.contains(fap)) {
                value = 0;
                this.valuesOut[fapIndex] = 0;
                this.fapsEverUsed.remove(fap);
                continue;
            }
            this.valuesOut[fapIndex] = null;
        }
        if (this.faceController != null) {
            MPEG4Configuration config = new MPEG4Configuration();
            config.setValues(this.valuesOut);
            this.faceController.setMPEG4Configuration(config);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isEditing = this.fapTable.isEditing();
        int col = this.fapTable.columnAtPoint(e.getPoint());
        if (col != 2) {
            if (isEditing) {
                this.fapTable.getCellEditor().stopCellEditing();
            }
            this.fapValueEditRow = -1;
            return;
        }
        int row = this.fapTable.rowAtPoint(e.getPoint());
        if (this.fapValueEditRow != row) {
            if (isEditing) {
                this.fapTable.getCellEditor().stopCellEditing();
            }
            this.fapTable.editCellAt(row, col);
            this.fapValueEditRow = row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == 2) {
            this.actionPerformed(new ActionEvent(this.tableModel, 1, "send"));
        }
    }

    private void dumpRanges(FapTableModel tableModel) {
        int[] mins = tableModel.getMins();
        int[] maxs = tableModel.getMaxs();
        int numFaps = tableModel.getNumFaps();
        System.out.println("int[][] range = new int[" + numFaps + "][];");
        for (int i = 0; i < numFaps; ++i) {
            if (mins[i] == 0 && maxs[i] == 0) continue;
            System.out.println("range[" + i + "] = new int[2];");
            System.out.println("range[" + i + "][0] = " + mins[i] + ";");
            System.out.println("range[" + i + "][1] = " + maxs[i] + ";");
        }
    }
}

