/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters.ui;

import hmi.faceanimation.model.FAP;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

class FapTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3457006952869085351L;
    private HashMap<Integer, FAP> faps;
    private int numFaps;
    private int[] values;
    private int[] mins;
    private int[] maxs;
    private String[] columnNames = new String[]{"#", "Name", "Value", "Min", "Max", "Directionality"};

    public FapTableModel(HashMap<Integer, FAP> faps) {
        this.faps = faps;
        this.numFaps = faps.size();
        this.values = new int[this.numFaps];
        this.mins = new int[this.numFaps];
        this.maxs = new int[this.numFaps];
    }

    public int getNumFaps() {
        return this.numFaps;
    }

    public int[] getValues() {
        return this.values;
    }

    public int[] getMins() {
        return this.mins;
    }

    public int[] getMaxs() {
        return this.maxs;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.numFaps;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.faps.get(row + 1).getNumber();
            }
            case 1: {
                return this.faps.get(row + 1).getName();
            }
            case 2: {
                return this.values[row];
            }
            case 3: {
                return this.mins[row];
            }
            case 4: {
                return this.maxs[row];
            }
            case 5: {
                return this.faps.get(row + 1).getDirectionality().toString();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2 || col == 3 || col == 4;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int in = Integer.parseInt(value.toString());
        int out = -1;
        switch (col) {
            case 2: {
                out = this.values[row];
                break;
            }
            case 3: {
                out = this.mins[row];
                break;
            }
            case 4: {
                out = this.maxs[row];
            }
        }
        if (in != out) {
            switch (col) {
                case 2: {
                    this.values[row] = in;
                    break;
                }
                case 3: {
                    this.mins[row] = in;
                    break;
                }
                case 4: {
                    this.maxs[row] = in;
                }
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

