/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.model;

import hmi.animation.VJoint;
import hmi.faceanimation.model.Head;
import hmi.math.Quat4f;

public class Neck {
    private VJoint joint;
    private float au;
    float pitch;
    float yaw;
    float roll;

    public Neck(VJoint joint, Head head) {
        this.joint = joint;
        this.au = head.getFAPU("AU");
    }

    public void setPitchValue(float value) {
        this.pitch = value * this.au + (float)Math.PI;
    }

    public void setYawValue(float value) {
        this.yaw = value * this.au + (float)Math.PI;
    }

    public void setRollValue(float value) {
        this.roll = value * this.au + (float)Math.PI;
    }

    public void copy() {
        float[] q = new float[4];
        Quat4f.setFromRollPitchYaw((float[])q, (float)this.roll, (float)this.pitch, (float)this.yaw);
        if (this.joint != null) {
            this.joint.setRotation(q);
        }
    }
}

