/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters.ui;

import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.converters.ui.ConfigListener;
import hmi.faceanimation.converters.ui.FACSPanel;
import hmi.faceanimation.model.FACSConfiguration;
import hmi.faceanimation.model.MPEG4Configuration;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FACSConverterFrame
extends JFrame
implements ConfigListener {
    private static final long serialVersionUID = -633623737546748897L;
    public FACSConverter facsConverter;
    private MPEG4Configuration mpeg4Config = new MPEG4Configuration();
    private FaceController faceController;
    private FACSConfiguration facsConfig = null;
    private Logger logger = LoggerFactory.getLogger((String)FACSConverterFrame.class.getName());

    public FACSConverterFrame(FaceController faceController) {
        this(new FACSConverter(), faceController);
    }

    public FACSConverterFrame(FACSConverter fc, FaceController faceController) {
        this.facsConverter = fc;
        this.faceController = faceController;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            this.logger.warn("Error setting native LAF: ", (Throwable)e);
        }
        FACSPanel fp = new FACSPanel(new FACSConfiguration(), this.facsConverter);
        fp.addConfigListener(this);
        JScrollPane sp = new JScrollPane(fp);
        this.getContentPane().add(sp);
        this.setPreferredSize(new Dimension(600, 600));
        this.setLocation(100, 100);
        this.setTitle("FACS to MPEG4 converter");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FACSConverterFrame.this.clear();
            }
        });
        this.setVisible(true);
    }

    public void clear() {
        this.faceController.removeMPEG4Configuration(this.mpeg4Config);
        this.mpeg4Config = new MPEG4Configuration();
    }

    @Override
    public void configChanged(FACSConfiguration config) {
        this.facsConfig = config;
        this.faceController.removeMPEG4Configuration(this.mpeg4Config);
        this.facsConverter.convert(config, this.mpeg4Config);
        this.faceController.addMPEG4Configuration(this.mpeg4Config);
    }
}

