/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceanimation.converters;

import hmi.faceanimation.model.ActionUnit;
import hmi.faceanimation.model.FACS;
import hmi.faceanimation.model.FACSConfiguration;
import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.MPEG4;
import hmi.faceanimation.model.MPEG4Configuration;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class FACSConverter {
    HashMap<FAP, ArrayList<Influence>> influencesByFAP = new HashMap();
    HashMap<ActionUnit, ArrayList<Influence>> influencesByAU = new HashMap();
    private ArrayList<FAP> fapsEverUsed = new ArrayList();

    public FACSConverter() {
        this(new Resources(""), "mpeg4face/facs_to_mpeg.txt");
    }

    public FACSConverter(Resources r, String filename) {
        try {
            String line;
            BufferedReader br = r.getReader(filename);
            ActionUnit au = null;
            FACS.Side side = FACS.Side.NONE;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.equals("")) continue;
                String[] elts = line.split("\t");
                if (elts.length == 1) {
                    side = FACS.Side.NONE;
                    au = FACS.getActionUnit(Integer.parseInt(elts[0]));
                }
                if (elts.length == 2) {
                    au = FACS.getActionUnit(Integer.parseInt(elts[0]));
                    if (elts[1].equals("L")) {
                        side = FACS.Side.LEFT;
                        continue;
                    }
                    if (!elts[1].equals("R")) continue;
                    side = FACS.Side.RIGHT;
                    continue;
                }
                if (elts.length != 5 || au == null) continue;
                FAP fap = MPEG4.getFAP(Integer.parseInt(elts[0]));
                float auBegin = Float.parseFloat(elts[1]);
                float auEnd = Float.parseFloat(elts[2]);
                int fapBegin = Integer.parseInt(elts[3]);
                int fapEnd = Integer.parseInt(elts[4]);
                Influence influence = new Influence(au, side, fap, auBegin, auEnd, fapBegin, fapEnd);
                if (!this.influencesByFAP.containsKey(fap)) {
                    this.influencesByFAP.put(fap, new ArrayList());
                }
                this.influencesByFAP.get(fap).add(influence);
                if (!this.influencesByAU.containsKey(au)) {
                    this.influencesByAU.put(au, new ArrayList());
                }
                this.influencesByAU.get(au).add(influence);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getNumberOfInfluences(ActionUnit au) {
        if (this.influencesByAU.containsKey(au)) {
            return this.influencesByAU.get(au).size();
        }
        return 0;
    }

    public void convert(FACSConfiguration facsConfig, MPEG4Configuration mpeg4Config) {
        for (FAP key : this.influencesByFAP.keySet()) {
            ArrayList<Influence> influences = this.influencesByFAP.get(key);
            int numInfluences = influences.size();
            if (numInfluences == 0) continue;
            float[] targetValues = new float[numInfluences];
            int i = 0;
            for (Influence influence : influences) {
                float portion;
                int auIndex = influence.au.getIndex();
                Float auValue = facsConfig.getValue(influence.side, auIndex);
                if (auValue == null) {
                    auValue = Float.valueOf(0.0f);
                }
                if ((portion = (auValue.floatValue() - influence.auBegin) / (influence.auEnd - influence.auBegin)) < 0.0f || portion > 1.0f) {
                    --numInfluences;
                    continue;
                }
                int fapValue = (int)((float)influence.fapBegin + portion * (float)(influence.fapEnd - influence.fapBegin));
                if (fapValue == 0) {
                    --numInfluences;
                }
                targetValues[i++] = fapValue;
            }
            int total = 0;
            for (int j = 0; j < targetValues.length; ++j) {
                total = (int)((float)total + targetValues[j]);
            }
            Integer targetValue = numInfluences == 0 ? 0 : total / numInfluences;
            if (targetValue != 0) {
                if (!this.fapsEverUsed.contains(key)) {
                    this.fapsEverUsed.add(key);
                }
            } else if (this.fapsEverUsed.contains(key)) {
                this.fapsEverUsed.remove(key);
            } else {
                targetValue = null;
            }
            mpeg4Config.setValue(key.getIndex(), targetValue);
        }
    }

    private static class Influence {
        public ActionUnit au;
        public FACS.Side side;
        public FAP fap;
        public float auBegin;
        public float auEnd;
        public int fapBegin;
        public int fapEnd;

        public Influence(ActionUnit au, FACS.Side side, FAP fap, float auBegin, float auEnd, int fapBegin, int fapEnd) {
            this.au = au;
            this.side = side;
            this.fap = fap;
            this.auBegin = auBegin;
            this.auEnd = auEnd;
            this.fapBegin = fapBegin;
            this.fapEnd = fapEnd;
        }
    }
}

