/*
 * Decompiled with CFR 0.152.
 */
package hmi.sensors.eyebox2.util;

import hmi.sensors.eyebox2.directaccess.EyePair;
import hmi.sensors.eyebox2.directaccess.Face;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class XuukXMLLogger {
    private File outputFile;
    private FileWriter logger;
    private long startTime;

    public XuukXMLLogger(String filename) {
        this.outputFile = new File(filename);
        try {
            this.logger = new FileWriter(this.outputFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startMeasurement(String wall, String ground) {
        this.startTime = System.currentTimeMillis();
        try {
            this.logger.write("<measurement wall=\"" + wall + "\" ground=\"" + ground + "\" timestamp=\"0\">\n");
            this.logger.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void logLine(String line) {
        String[] elements = line.split(" ");
        if (elements.length > 1) {
            int type = Integer.parseInt(elements[0]);
            switch (type) {
                case 1: {
                    this.logFacePosition(elements);
                    break;
                }
                case 2: {
                    this.logEyePosition(elements);
                    break;
                }
                case 5: {
                    this.logDetection(elements);
                    break;
                }
                case 8: {
                    this.logDetection(elements);
                    break;
                }
            }
        }
    }

    public void logFacePosition(String[] elements) {
        int type = Integer.parseInt(elements[0]);
        int nrOfPositions = Integer.parseInt(elements[1]);
        for (int i = 0; i < nrOfPositions; ++i) {
            int id = Integer.parseInt(elements[1 + i * 5 + 1]);
            int x1 = Integer.parseInt(elements[1 + i * 5 + 2]);
            int y1 = Integer.parseInt(elements[1 + i * 5 + 3]);
            int x2 = Integer.parseInt(elements[1 + i * 5 + 4]);
            int y2 = Integer.parseInt(elements[1 + i * 5 + 5]);
            try {
                this.logger.write("\t<measure type=\"" + type + "\" id=\"" + id + "\" x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" timestamp=\"" + (System.currentTimeMillis() - this.startTime) + "\">\n");
                this.logger.flush();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void logEyePosition(String[] elements) {
        int type = Integer.parseInt(elements[0]);
        int nrOfPositions = Integer.parseInt(elements[1]);
        for (int i = 0; i < nrOfPositions; ++i) {
            int id = Integer.parseInt(elements[1 + i * 5 + 1]);
            int x1 = Integer.parseInt(elements[1 + i * 5 + 4]);
            int y1 = Integer.parseInt(elements[1 + i * 5 + 5]);
            int x2 = Integer.parseInt(elements[1 + i * 5 + 8]);
            int y2 = Integer.parseInt(elements[1 + i * 5 + 9]);
            try {
                this.logger.write("\t<measure type=\"" + type + "\" id=\"" + id + "\" x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" timestamp=\"" + (System.currentTimeMillis() - this.startTime) + "\">\n");
                this.logger.flush();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void logDetection(String[] elements) {
        int type = Integer.parseInt(elements[0]);
        int id = Integer.parseInt(elements[1]);
        int status = Integer.parseInt(elements[2]);
        String xuukDate = elements[3];
        String xuukTime = elements[4];
        try {
            this.logger.write("\t<measure type=\"" + type + "\" id=\"" + id + "\" status=\"" + status + "\" date=\"" + xuukDate + "\" time=\"" + xuukTime + "\" timestamp=\"" + (System.currentTimeMillis() - this.startTime) + "\">\n");
            this.logger.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void logCurrentState(HashMap<Integer, Face> faces, HashMap<Integer, EyePair> eyes) {
        try {
            Iterator<Integer> it;
            this.logger.write("\t<currentState>\n");
            if (faces != null) {
                Set<Integer> facesKeySet = faces.keySet();
                it = facesKeySet.iterator();
                while (it.hasNext()) {
                    Face face = faces.get(it.next());
                    this.logger.write("\t\t<face id=\"" + face.getId() + "\"");
                    if (face.getPosition() != null) {
                        this.logger.write("x1=\"" + face.getPosition().getX1() + "\" y1=\"" + face.getPosition().getY1() + "\" x2=\"" + face.getPosition().getX2() + "\" y2=\"" + face.getPosition().getY2() + "\">\n");
                        continue;
                    }
                    this.logger.write(">\n");
                }
            }
            if (eyes != null) {
                Set<Integer> eyesKeySet = eyes.keySet();
                it = eyesKeySet.iterator();
                while (it.hasNext()) {
                    EyePair eyePair = eyes.get(it.next());
                    this.logger.write("\t\t<eye id=\"" + eyePair.getId() + "\" status=\"" + eyePair.isLooking() + "\"");
                    if (eyePair.getPosition() != null) {
                        this.logger.write("x1=\"" + eyePair.getPosition().getX1() + "\" y1=\"" + eyePair.getPosition().getY1() + "\" x2=\"" + eyePair.getPosition().getX2() + "\" y2=\"" + eyePair.getPosition().getY2() + "\">\n");
                        continue;
                    }
                    this.logger.write(">\n");
                }
            }
            this.logger.write("\t</currentState>\n");
            this.logger.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeMeasurement() {
        try {
            this.logger.write("</measurement timestamp=\"" + (System.currentTimeMillis() - this.startTime) + "\">\n");
            this.logger.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

