/*
 * Decompiled with CFR 0.152.
 */
package hmi.sensors.eyebox2.directaccess;

import hmi.sensors.eyebox2.directaccess.DirectXuukReader;
import hmi.sensors.eyebox2.directaccess.EyePair;
import hmi.sensors.eyebox2.directaccess.Face;
import hmi.sensors.eyebox2.directaccess.Position;
import hmi.sensors.eyebox2.directaccess.XuukListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;

public class XuukTester
implements XuukListener {
    private JFrame jframe;
    private JEditorPane outputFaces;
    private JEditorPane outputEyes;
    private String outputTextFaces = "";
    private String outputTextEyes = "";
    private long starttime;
    private HashMap<Integer, Face> faces = new HashMap();
    private HashMap<Integer, EyePair> eyes = new HashMap();

    public XuukTester() {
        this.paintGui();
        DirectXuukReader reader = new DirectXuukReader("127.0.0.1", 5015);
        reader.addListener(this, true, true, true, true);
    }

    public void paintGui() {
        this.starttime = System.currentTimeMillis();
        this.jframe = new JFrame();
        this.jframe.setLayout(new BorderLayout());
        this.jframe.setPreferredSize(new Dimension(600, 200));
        this.outputFaces = new JEditorPane("text/plain", this.outputTextFaces);
        this.outputFaces.setEditable(false);
        this.outputFaces.setPreferredSize(new Dimension(250, 200));
        this.jframe.add((Component)this.outputFaces, "West");
        this.outputEyes = new JEditorPane("text/plain", this.outputTextEyes);
        this.outputEyes.setEditable(false);
        this.outputEyes.setPreferredSize(new Dimension(250, 200));
        this.jframe.add((Component)this.outputEyes, "East");
        this.jframe.setTitle("ChatBot");
        this.jframe.setDefaultCloseOperation(3);
        this.jframe.pack();
        this.jframe.setLocationRelativeTo(null);
        this.jframe.setResizable(false);
        this.jframe.setVisible(true);
    }

    public void setText() {
        Position pos;
        this.outputTextFaces = "";
        this.outputTextEyes = "";
        for (Face face : this.faces.values()) {
            pos = face.getPosition();
            if (pos != null) {
                this.outputTextFaces = this.outputTextFaces + (System.currentTimeMillis() - this.starttime) + " - Face " + face.getId() + ": (" + pos.getX1() + "," + pos.getY1() + ")x(" + pos.getX2() + "," + pos.getY2() + ")\r\n";
                continue;
            }
            this.outputTextFaces = this.outputTextFaces + (System.currentTimeMillis() - this.starttime) + " - Face " + face.getId() + ": (0,0)x(0,0)\r\n";
        }
        for (EyePair eyePair : this.eyes.values()) {
            pos = eyePair.getPosition();
            String looking = eyePair.isLooking() ? "Looking" : "Not looking";
            if (pos != null) {
                this.outputTextEyes = this.outputTextEyes + (System.currentTimeMillis() - this.starttime) + " - EyePair " + eyePair.getId() + " (" + looking + "): (" + pos.getX1() + "," + pos.getY1() + ")x(" + pos.getX2() + "," + pos.getY2() + ")\r\n";
                continue;
            }
            this.outputTextEyes = this.outputTextEyes + (System.currentTimeMillis() - this.starttime) + " - EyePair " + eyePair.getId() + " (" + looking + "): (0,0)x(0,0)\r\n";
        }
        if (this.outputFaces == null) {
            System.out.println("!!!!");
        } else {
            System.out.println(this.outputTextFaces);
            this.outputFaces.setText("");
            this.outputEyes.setText("");
            this.outputFaces.setText("Faces\r\n" + this.outputTextFaces);
            this.outputEyes.setText("Eyes\r\n" + this.outputTextEyes);
            this.jframe.pack();
            this.jframe.setVisible(true);
        }
    }

    @Override
    public void faceAppeared(Face face) {
        System.out.println(System.currentTimeMillis() - this.starttime + " - Adding Face: " + face.getId());
        if (this.faces.get(face.getId()) == null) {
            this.faces.put(face.getId(), face);
        }
        this.setText();
    }

    @Override
    public void faceDisappeared(int id) {
        System.out.println(System.currentTimeMillis() - this.starttime + " - Removing Face: " + id);
        if (this.faces.get(id) != null) {
            this.faces.remove(id);
        }
        this.setText();
    }

    @Override
    public void newFacePositions(ArrayList<Face> newFaces) {
        for (Face face : newFaces) {
            if (this.faces.get(face.getId()) == null) continue;
            this.faces.put(face.getId(), face);
        }
        this.setText();
    }

    @Override
    public void eyesChange(EyePair newEyepair) {
        System.out.println(System.currentTimeMillis() - this.starttime + " - Adding Eyes: " + newEyepair.getId());
        this.eyes.put(newEyepair.getId(), newEyepair);
        this.setText();
    }

    @Override
    public void eyesDisappeared(int id) {
        System.out.println(System.currentTimeMillis() - this.starttime + " - Removing Eyes: " + id);
        if (this.eyes.get(id) != null) {
            this.eyes.remove(id);
        }
        this.setText();
    }

    @Override
    public void newEyesPositions(ArrayList<EyePair> newEyes) {
        for (EyePair eyePair : newEyes) {
            if (this.eyes.get(eyePair.getId()) == null) continue;
            this.eyes.put(eyePair.getId(), eyePair);
        }
    }

    public static void main(String[] args) {
        new XuukTester();
    }
}

