/*
 * Decompiled with CFR 0.152.
 */
package hmi.sensors.eyebox2.directaccess;

import hmi.sensors.eyebox2.directaccess.EyePair;
import hmi.sensors.eyebox2.directaccess.EyePairListenerUpdater;
import hmi.sensors.eyebox2.directaccess.Face;
import hmi.sensors.eyebox2.directaccess.FaceListenerUpdater;
import hmi.sensors.eyebox2.directaccess.Position;
import hmi.sensors.eyebox2.directaccess.XuukListener;
import hmi.sensors.eyebox2.directaccess.XuukReader;
import hmi.sensors.eyebox2.util.XuukXMLLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class DirectXuukReader
extends Thread
implements XuukReader {
    private boolean stopRunning = false;
    private boolean isReading = true;
    private boolean isLogging = false;
    private String host = "127.0.0.1";
    private int port = 5015;
    private Socket sock;
    private BufferedReader in;
    private XuukXMLLogger logger;
    private HashMap<Integer, Face> faces = new HashMap();
    private HashMap<Integer, EyePair> eyes = new HashMap();
    private ArrayList<XuukListener> faceAppearanceListeners = new ArrayList();
    private ArrayList<XuukListener> eyesAppearanceListeners = new ArrayList();
    private ArrayList<XuukListener> facePositionListeners = new ArrayList();
    private ArrayList<XuukListener> eyesPositionListeners = new ArrayList();

    public DirectXuukReader(String host, int port) {
        this.host = host;
        this.port = port;
        this.startReader();
    }

    @Override
    public void run() {
        System.out.println("Reading");
        while (!this.stopRunning) {
            while (this.isReading) {
                try {
                    String line = this.in.readLine();
                    if (this.isLogging) {
                        this.logger.logLine(line);
                    }
                    System.out.println(line);
                    if (line != null) {
                        this.processLine(line);
                        continue;
                    }
                    System.out.println("Xuuk Eyebox: no more data to read");
                    this.isReading = false;
                }
                catch (IOException e) {
                    System.out.println("Xuuk Eyebox: Error reading line, closing socket");
                    this.isReading = false;
                }
            }
            try {
                DirectXuukReader.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Xuuk Eyebox: Trying to connect");
            this.isReading = this.openSocket();
        }
        this.closeSocket();
    }

    public void processLine(String line) {
        String[] elements = line.split(" ");
        if (elements.length > 1) {
            int type = Integer.parseInt(elements[0]);
            switch (type) {
                case 1: {
                    int nrOfFaces = Integer.parseInt(elements[1]);
                    if (elements.length != 2 + 5 * nrOfFaces) {
                        System.out.println("Xuuk Eyebox: Face position has wrong number of elements");
                        break;
                    }
                    for (int i = 0; i < nrOfFaces; ++i) {
                        int id = Integer.parseInt(elements[1 + i * 5 + 1]);
                        int x1 = Integer.parseInt(elements[1 + i * 5 + 2]);
                        int y1 = Integer.parseInt(elements[1 + i * 5 + 3]);
                        int x2 = Integer.parseInt(elements[1 + i * 5 + 4]);
                        int y2 = Integer.parseInt(elements[1 + i * 5 + 5]);
                        Position newPosition = new Position(x1, y1, x2, y2);
                        Face face = this.faces.get(id);
                        if (face != null) {
                            face.setPosition(newPosition);
                            continue;
                        }
                        System.out.println("Xuuk Eyebox: Face position for unknown face found");
                    }
                    ArrayList<Face> facevalues = new ArrayList<Face>();
                    for (Face f : this.faces.values()) {
                        facevalues.add(f);
                    }
                    for (XuukListener listener : this.facePositionListeners) {
                        FaceListenerUpdater updater = new FaceListenerUpdater(listener, facevalues);
                        updater.start();
                    }
                    break;
                }
                case 2: {
                    int nrOfEyes = Integer.parseInt(elements[1]);
                    if (elements.length != 2 + 9 * nrOfEyes) {
                        System.out.println("Xuuk Eyebox: Eyes position does not have  elements");
                        break;
                    }
                    for (int i = 0; i < nrOfEyes; ++i) {
                        int id = Integer.parseInt(elements[1 + i * 5 + 1]);
                        int x1 = Integer.parseInt(elements[1 + i * 5 + 4]);
                        int y1 = Integer.parseInt(elements[1 + i * 5 + 5]);
                        int x2 = Integer.parseInt(elements[1 + i * 5 + 8]);
                        int y2 = Integer.parseInt(elements[1 + i * 5 + 9]);
                        Position newPosition = new Position(x1, y1, x2, y2);
                        EyePair eyePair = this.eyes.get(id);
                        if (eyePair == null) continue;
                        eyePair.setPosition(newPosition);
                    }
                    ArrayList<EyePair> eyevalues = new ArrayList<EyePair>();
                    for (EyePair ep : this.eyes.values()) {
                        eyevalues.add(ep);
                    }
                    for (XuukListener listener : this.eyesPositionListeners) {
                        EyePairListenerUpdater updater = new EyePairListenerUpdater(listener, eyevalues);
                        updater.start();
                    }
                    break;
                }
                case 5: {
                    if (elements.length != 5) break;
                    int id = Integer.parseInt(elements[1]);
                    int status = Integer.parseInt(elements[2]);
                    String time = elements[3] + " " + elements[4];
                    if (status == 0) {
                        this.eyes.remove(id);
                        for (XuukListener listener : this.eyesAppearanceListeners) {
                            EyePairListenerUpdater updater = new EyePairListenerUpdater(listener, id);
                            updater.start();
                        }
                    } else if (status == 1) {
                        EyePair eyePair = this.eyes.get(id);
                        if (eyePair == null) {
                            eyePair = new EyePair(id, false, time);
                            this.eyes.put(id, eyePair);
                            for (XuukListener listener : this.eyesAppearanceListeners) {
                                EyePairListenerUpdater updater = new EyePairListenerUpdater(listener, eyePair);
                                updater.start();
                            }
                        } else {
                            eyePair.setLooking(false);
                            for (XuukListener listener : this.eyesAppearanceListeners) {
                                EyePairListenerUpdater updater = new EyePairListenerUpdater(listener, eyePair);
                                updater.start();
                            }
                        }
                    } else {
                        if (status != 2) break;
                        EyePair eyePair = this.eyes.get(id);
                        if (eyePair == null) {
                            eyePair = new EyePair(id, true, time);
                            this.eyes.put(id, eyePair);
                            for (XuukListener listener : this.eyesAppearanceListeners) {
                                EyePairListenerUpdater updater = new EyePairListenerUpdater(listener, eyePair);
                                updater.start();
                            }
                        } else {
                            eyePair.setLooking(false);
                            for (XuukListener listener : this.eyesAppearanceListeners) {
                                EyePairListenerUpdater updater = new EyePairListenerUpdater(listener, eyePair);
                                updater.start();
                            }
                        }
                    }
                    break;
                }
                case 8: {
                    if (elements.length != 5) {
                        System.out.println("Face detected: wrong nr of elements");
                        break;
                    }
                    int id = Integer.parseInt(elements[1]);
                    int status = Integer.parseInt(elements[2]);
                    String time = elements[3] + " " + elements[4];
                    if (status == 0) {
                        this.faces.remove(id);
                        for (XuukListener listener : this.faceAppearanceListeners) {
                            FaceListenerUpdater updater = new FaceListenerUpdater(listener, id);
                            updater.start();
                        }
                    } else {
                        if (status != 1) break;
                        Face face = new Face(id, time);
                        this.faces.put(id, face);
                        for (XuukListener listener : this.faceAppearanceListeners) {
                            FaceListenerUpdater updater = new FaceListenerUpdater(listener, face);
                            updater.start();
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void addListener(XuukListener listener, boolean faceAppearances, boolean eyesAppearances, boolean facePositions, boolean eyesPositions) {
        if (faceAppearances) {
            this.faceAppearanceListeners.add(listener);
        }
        if (eyesAppearances) {
            this.eyesAppearanceListeners.add(listener);
        }
        if (facePositions) {
            this.facePositionListeners.add(listener);
        }
        if (eyesPositions) {
            this.eyesPositionListeners.add(listener);
        }
    }

    public void stopRunning() {
        this.stopReader();
        this.stopRunning = true;
    }

    public void stopReader() {
        if (this.isReading) {
            this.closeSocket();
        }
        this.isReading = false;
    }

    public void startReader() {
        this.isReading = this.openSocket();
        this.start();
    }

    public void stopLogging() {
        this.isLogging = false;
    }

    public void startLogging() {
        this.isLogging = true;
        this.logger.logCurrentState(this.faces, this.eyes);
    }

    public void setLogger(XuukXMLLogger xuukLogger) {
        this.logger = xuukLogger;
    }

    private void closeSocket() {
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean openSocket() {
        try {
            this.sock = new Socket(this.host, this.port);
            this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            System.out.println("Xuuk Eyebox: Connected");
            return true;
        }
        catch (UnknownHostException e) {
            System.err.println("Xuuk Eyebox: Unknown host, not connected");
            return false;
        }
        catch (IOException e) {
            System.err.println("Xuuk Eyebox: IOException, not connected");
            return false;
        }
    }

    public static void main(String[] args) {
        new DirectXuukReader("127.0.0.1", 5015);
    }
}

