/*
 * Decompiled with CFR 0.152.
 */
package hmi.sensors.eyebox2.aggregate;

import hmi.sensors.eyebox2.aggregate.SingleUserTrackerListener;
import hmi.sensors.eyebox2.directaccess.EyePair;
import hmi.sensors.eyebox2.directaccess.Face;
import hmi.sensors.eyebox2.directaccess.Position;
import hmi.sensors.eyebox2.directaccess.XuukListener;
import hmi.sensors.eyebox2.directaccess.XuukReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.JFrame;

public class SingleUserTracker
implements XuukListener {
    private static final long RETAINFACETIME = 500L;
    private long starttime;
    private static final float camWidth = 1280.0f;
    private static final float camHeight = 640.0f;
    private HashMap<Integer, Face> faces = new HashMap();
    private HashMap<Integer, EyePair> eyes = new HashMap();
    private int currentlyActiveFace = -1;
    private boolean lostFace = false;
    private long lostTime = 0L;
    private boolean debug = false;
    private XuukReader xuukReader = null;
    private ArrayList<SingleUserTrackerListener> singleUserTrackerListeners = new ArrayList();
    private JFrame jframe;
    private JEditorPane outputFaces;
    private JEditorPane outputEyes;
    private String outputTextFaces = "";
    private String outputTextEyes = "";
    private boolean showUI = false;

    public SingleUserTracker(XuukReader xr) {
        this.initUI();
        this.xuukReader = xr;
        this.xuukReader.addListener(this, true, true, true, true);
    }

    public void addListener(SingleUserTrackerListener listener) {
        this.singleUserTrackerListeners.add(listener);
    }

    public void removeListener(SingleUserTrackerListener listener) {
        this.singleUserTrackerListeners.remove(listener);
    }

    public void checkLostFace() {
        long now = System.currentTimeMillis() - this.starttime;
        if (this.lostFace && now - this.lostTime > 500L) {
            this.currentlyActiveFace = -1;
            this.lostFace = false;
            for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                listener.userDisappeared();
            }
            if (!this.faces.isEmpty()) {
                Iterator<Object> i$ = this.faces.keySet().iterator();
                while (i$.hasNext()) {
                    int key = (Integer)i$.next();
                    if (key != this.currentlyActiveFace) {
                        this.currentlyActiveFace = key;
                        Face face = this.faces.get(this.currentlyActiveFace);
                        Position p = face.getPosition();
                        float x1 = (float)p.getX1() / 1280.0f;
                        float y1 = (float)p.getY1() / 640.0f;
                        float x2 = (float)p.getX2() / 1280.0f;
                        float y2 = (float)p.getY2() / 640.0f;
                        for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                            listener.userAppeared(x1, y1, x2, y2);
                        }
                        break;
                    }
                    this.currentlyActiveFace = -1;
                }
            } else {
                this.currentlyActiveFace = -1;
            }
        }
    }

    @Override
    public void faceAppeared(Face face) {
        block10: {
            long now;
            block11: {
                block9: {
                    this.checkLostFace();
                    now = System.currentTimeMillis() - this.starttime;
                    boolean sendData = false;
                    if (this.faces.get(face.getId()) == null) {
                        this.faces.put(face.getId(), face);
                    }
                    this.setText();
                    if (this.currentlyActiveFace != -1) break block9;
                    this.currentlyActiveFace = face.getId();
                    if (this.debug) {
                        System.out.println("" + this.currentlyActiveFace + " Now tracking face: " + face.getId());
                    }
                    this.lostFace = false;
                    Position p = face.getPosition();
                    float x1 = (float)p.getX1() / 1280.0f;
                    float y1 = (float)p.getY1() / 640.0f;
                    float x2 = (float)p.getX2() / 1280.0f;
                    float y2 = (float)p.getY2() / 640.0f;
                    for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                        listener.userAppeared(x1, y1, x2, y2);
                    }
                    break block10;
                }
                if (face.getId() != this.currentlyActiveFace) break block11;
                if (this.lostFace) {
                    this.lostFace = false;
                    Position p = face.getPosition();
                    float x1 = (float)p.getX1() / 1280.0f;
                    float y1 = (float)p.getY1() / 640.0f;
                    float x2 = (float)p.getX2() / 1280.0f;
                    float y2 = (float)p.getY2() / 640.0f;
                    for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                        listener.userMoved(x1, y1, x2, y2);
                    }
                } else {
                    Position p = face.getPosition();
                    float x1 = (float)p.getX1() / 1280.0f;
                    float y1 = (float)p.getY1() / 640.0f;
                    float x2 = (float)p.getX2() / 1280.0f;
                    float y2 = (float)p.getY2() / 640.0f;
                    for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                        listener.userAppeared(x1, y1, x2, y2);
                    }
                }
                break block10;
            }
            if (!this.lostFace || now - this.lostTime <= 500L) break block10;
            this.currentlyActiveFace = face.getId();
            if (this.debug) {
                System.out.println("" + this.currentlyActiveFace + " Now tracking face: " + face.getId());
            }
            this.lostFace = false;
            Position p = face.getPosition();
            float x1 = (float)p.getX1() / 1280.0f;
            float y1 = (float)p.getY1() / 640.0f;
            float x2 = (float)p.getX2() / 1280.0f;
            float y2 = (float)p.getY2() / 640.0f;
            for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                listener.userAppeared(x1, y1, x2, y2);
            }
        }
    }

    @Override
    public void faceDisappeared(int id) {
        this.checkLostFace();
        long now = System.currentTimeMillis() - this.starttime;
        boolean sendData = false;
        if (this.faces.get(id) != null) {
            this.faces.remove(id);
            if (this.debug) {
                System.out.println("" + this.currentlyActiveFace + " Removed face: " + id);
            }
        }
        this.setText();
        if (this.currentlyActiveFace == -1) {
            return;
        }
        if (this.currentlyActiveFace != id) {
            return;
        }
        this.lostFace = true;
        this.lostTime = now;
    }

    @Override
    public void newFacePositions(ArrayList<Face> newFaces) {
        this.checkLostFace();
        boolean currentlyActiveFacePresent = false;
        for (Face face : newFaces) {
            if (this.faces.get(face.getId()) != null) {
                this.faces.put(face.getId(), face);
                if (this.debug) {
                    System.out.println("" + this.currentlyActiveFace + " Received position for " + face.getId());
                }
            } else if (this.debug) {
                System.out.println("" + this.currentlyActiveFace + " New position for unknown face " + face.getId());
            }
            if (face.getId() != this.currentlyActiveFace) continue;
            currentlyActiveFacePresent = true;
        }
        this.setText();
        if (!currentlyActiveFacePresent) {
            if (this.debug) {
                System.out.println("" + this.currentlyActiveFace + " Face considered lost");
            }
            this.lostFace = true;
            this.faces.remove(this.currentlyActiveFace);
        }
        if (this.currentlyActiveFace != -1) {
            Face f = this.faces.get(this.currentlyActiveFace);
            if (f != null) {
                this.lostFace = false;
                Position p = f.getPosition();
                float x1 = (float)p.getX1() / 1280.0f;
                float y1 = (float)p.getY1() / 640.0f;
                float x2 = (float)p.getX2() / 1280.0f;
                float y2 = (float)p.getY2() / 640.0f;
                for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                    listener.userMoved(x1, y1, x2, y2);
                }
            } else if (currentlyActiveFacePresent) {
                for (Face face : newFaces) {
                    if (face.getId() != this.currentlyActiveFace) continue;
                    this.lostFace = false;
                    this.faces.put(face.getId(), face);
                    Position p = face.getPosition();
                    float x1 = (float)p.getX1() / 1280.0f;
                    float y1 = (float)p.getY1() / 640.0f;
                    float x2 = (float)p.getX2() / 1280.0f;
                    float y2 = (float)p.getY2() / 640.0f;
                    for (SingleUserTrackerListener listener : this.singleUserTrackerListeners) {
                        listener.userMoved(x1, y1, x2, y2);
                    }
                    if (this.debug) {
                        System.out.println("" + this.currentlyActiveFace + " Corrected faces hashmap with the new face position");
                    }
                    break;
                }
            } else if (this.debug) {
                System.out.println("" + this.currentlyActiveFace + " New position, cant find active face!");
            }
        } else if (this.debug) {
            System.out.println("" + this.currentlyActiveFace + " Received positions of a face while not tracking");
        }
    }

    @Override
    public void eyesChange(EyePair newEyepair) {
        this.eyes.put(newEyepair.getId(), newEyepair);
        this.setText();
    }

    @Override
    public void eyesDisappeared(int id) {
        if (this.eyes.get(id) != null) {
            this.eyes.remove(id);
        }
        this.setText();
    }

    @Override
    public void newEyesPositions(ArrayList<EyePair> newEyes) {
        for (EyePair eyePair : newEyes) {
            if (this.eyes.get(eyePair.getId()) == null) continue;
            this.eyes.put(eyePair.getId(), eyePair);
        }
    }

    public void toggleUI() {
        this.showUI = !this.showUI;
        this.jframe.setVisible(this.showUI);
    }

    public void initUI() {
        this.starttime = System.currentTimeMillis();
        this.jframe = new JFrame();
        this.jframe.setLayout(new BorderLayout());
        this.jframe.setPreferredSize(new Dimension(600, 200));
        this.outputFaces = new JEditorPane("text/plain", this.outputTextFaces);
        this.outputFaces.setEditable(false);
        this.outputFaces.setPreferredSize(new Dimension(250, 200));
        this.jframe.add((Component)this.outputFaces, "West");
        this.outputEyes = new JEditorPane("text/plain", this.outputTextEyes);
        this.outputEyes.setEditable(false);
        this.outputEyes.setPreferredSize(new Dimension(250, 200));
        this.jframe.add((Component)this.outputEyes, "East");
        this.jframe.setTitle("SingleUserTracker UI Panel");
        this.jframe.setDefaultCloseOperation(0);
        this.jframe.pack();
        this.jframe.setLocationRelativeTo(null);
        this.jframe.setResizable(false);
        this.jframe.setVisible(this.showUI);
    }

    public void setText() {
        Position pos;
        this.outputTextFaces = "";
        this.outputTextEyes = "";
        for (Face face : this.faces.values()) {
            pos = face.getPosition();
            if (pos != null) {
                this.outputTextFaces = this.outputTextFaces + (System.currentTimeMillis() - this.starttime) + " - Face " + face.getId() + ": (" + pos.getX1() + "," + pos.getY1() + ")x(" + pos.getX2() + "," + pos.getY2() + ")\r\n";
                continue;
            }
            this.outputTextFaces = this.outputTextFaces + (System.currentTimeMillis() - this.starttime) + " - Face " + face.getId() + ": (0,0)x(0,0)\r\n";
        }
        for (EyePair eyePair : this.eyes.values()) {
            pos = eyePair.getPosition();
            String looking = eyePair.isLooking() ? "Looking" : "Not looking";
            if (pos != null) {
                this.outputTextEyes = this.outputTextEyes + (System.currentTimeMillis() - this.starttime) + " - EyePair " + eyePair.getId() + " (" + looking + "): (" + pos.getX1() + "," + pos.getY1() + ")x(" + pos.getX2() + "," + pos.getY2() + ")\r\n";
                continue;
            }
            this.outputTextEyes = this.outputTextEyes + (System.currentTimeMillis() - this.starttime) + " - EyePair " + eyePair.getId() + " (" + looking + "): (0,0)x(0,0)\r\n";
        }
        if (this.outputFaces == null) {
            System.out.println("No UI present to show " + this.currentlyActiveFace + " !!!!");
        } else {
            this.outputFaces.setText("");
            this.outputEyes.setText("");
            this.outputFaces.setText("Faces\r\n" + this.outputTextFaces);
            this.outputEyes.setText("Eyes\r\n" + this.outputTextEyes);
            this.jframe.pack();
            this.jframe.setVisible(this.showUI);
        }
    }
}

