/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture.vhloader;

import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.SingleThreadedPlanPlayer;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.EngineLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.picture.PicturePlanner;
import hmi.picture.picturebinding.PictureBinding;
import hmi.picture.vhloader.PictureEmbodiment;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class PictureEngineLoader
implements EngineLoader {
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private PictureEmbodiment pe = null;
    private Engine engine = null;
    private PlanManager planManager = null;
    private Player player = null;
    private String id = "";
    private PictureBinding pictureBinding = null;
    private ElckerlycRealizerLoader theRealizerLoader = null;

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theRealizerLoader = realizerLoader;
        for (Loader e : requiredLoaders) {
            if (!(e instanceof EmbodimentLoader) || !(((EmbodimentLoader)e).getEmbodiment() instanceof PictureEmbodiment)) continue;
            this.pe = (PictureEmbodiment)((EmbodimentLoader)e).getEmbodiment();
        }
        if (this.pe == null) {
            throw new RuntimeException("PictureEngineLoader requires an EmbodimentLoader containing a PictureEmbodiment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        this.constructEngine(tokenizer);
    }

    @Override
    public void unload() {
        this.engine.shutdown();
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("PictureBinding")) {
            attrMap = tokenizer.getAttributes();
            this.pictureBinding = new PictureBinding();
            try {
                this.pictureBinding.readXML(new Resources(this.adapter.getOptionalAttribute("resources", attrMap, "")).getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer)));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannnot load PictureBinding: " + e);
            }
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
        tokenizer.takeEmptyElement("PictureBinding");
    }

    private void constructEngine(XMLTokenizer tokenizer) {
        if (this.pictureBinding == null) {
            throw tokenizer.getXMLScanException("picturebinding is null, cannot build pictureplanner ");
        }
        this.planManager = new PlanManager();
        SingleThreadedPlanPlayer planPlayer = new SingleThreadedPlanPlayer(this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager(), this.planManager);
        this.player = new DefaultPlayer((PlanPlayer)planPlayer);
        PicturePlanner planner = new PicturePlanner(this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager(), this.pictureBinding, this.planManager, this.pe.getPictureDisplay());
        this.engine = new DefaultEngine((Planner)planner, this.player, this.planManager);
        this.engine.setId(this.id);
        this.theRealizerLoader.getElckerlycRealizer().addEngine(this.engine);
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    public PlanManager getPlanManager() {
        return this.planManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }
}

