/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture.planunit;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.KeyPositionManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.picture.planunit.PUPlayException;
import hmi.picture.planunit.PictureUnit;
import hmi.picture.planunit.TPUPlayException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TimedPictureUnit
extends TimedAbstractPlanUnit {
    public final PictureUnit pu;
    protected ArrayList<KeyPosition> progressHandled = new ArrayList();
    private final PlanUnitTimeManager puTimeManager;

    public TimedPictureUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id, PictureUnit pu) {
        super(bfm, bbPeg, bmlId, id);
        this.pu = pu;
        this.puTimeManager = new PlanUnitTimeManager((KeyPositionManager)pu);
    }

    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        this.pu.startUnit(time);
    }

    public KeyPosition getKeyPosition(String kid) {
        return this.pu.getKeyPosition(kid);
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.pu.getKeyPositions()) {
            if (k.time <= t) {
                if (this.progressHandled.contains(k)) continue;
                String bmlId = this.getBMLId();
                String behaviorId = this.getId();
                String syncId = k.id;
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(k);
                continue;
            }
            if (!this.progressHandled.contains(k)) continue;
            this.progressHandled.remove(k);
        }
    }

    public void playUnit(double time) throws TimedPlanUnitPlayException {
        double t = this.puTimeManager.getRelativeTime(time);
        try {
            this.pu.play(t);
        }
        catch (PUPlayException ex) {
            throw new TPUPlayException(ex.getLocalizedMessage(), this);
        }
        this.sendProgress(t, time);
    }

    public void cleanup() {
        this.pu.cleanup();
    }

    public PictureUnit getPictureUnit() {
        return this.pu;
    }

    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        this.sendProgress(1.0, time);
        this.cleanup();
    }

    public String getReplacementGroup() {
        return this.pu.getReplacementGroup();
    }

    public double getPreferedDuration() {
        return this.pu.getPreferedDuration();
    }

    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.pu.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    public void setFloatParameterValue(String paramId, float value) throws ParameterException {
        try {
            this.pu.setFloatParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.pu.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.pu.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    public void setPegs(Map<KeyPosition, TimePeg> pegs) {
        this.puTimeManager.setPegs(pegs);
    }

    public double getRelativeTime(String syncId) throws SyncPointNotFoundException {
        return this.puTimeManager.getRelativeTime(syncId);
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.puTimeManager.getPegs();
    }

    public boolean hasValidTiming() {
        return this.puTimeManager.hasValidTiming();
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        return this.puTimeManager.getKeyPosition(sp);
    }

    public double getPrevPegTime(String pid) {
        return this.puTimeManager.getPrevPegTime(pid);
    }

    public double getNextPegTime(String pid) {
        return this.puTimeManager.getNextPegTime(pid);
    }

    public double getTime(String pid) {
        return this.puTimeManager.getTime(pid);
    }

    public TimePeg getTimePeg(String pid) {
        return this.puTimeManager.getTimePeg(pid);
    }

    public double getStartTime() {
        return this.puTimeManager.getStartTime();
    }

    public double getEndTime() {
        return this.puTimeManager.getEndTime();
    }

    public double getRelaxTime() {
        return this.puTimeManager.getRelaxTime();
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.puTimeManager.setTimePeg(kp, sp);
    }

    public void setTimePeg(String kid, TimePeg sp) {
        this.puTimeManager.setTimePeg(kid, sp);
    }

    public void resolveDefaultBMLKeyPositions() {
        this.puTimeManager.resolveDefaultBMLKeyPositions();
    }

    public double getRelativeTime(double absoluteTime) {
        return this.puTimeManager.getRelativeTime(absoluteTime);
    }

    public List<String> getAvailableSyncs() {
        return this.puTimeManager.getAvailableSyncs();
    }
}

