/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture.planunit;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.KeyPositionManager;
import hmi.elckerlyc.planunit.KeyPositionManagerImpl;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.picture.PicturePlanner;
import hmi.picture.display.PictureDisplay;
import hmi.picture.planunit.PUPlayException;
import hmi.picture.planunit.PictureUnit;
import hmi.picture.planunit.TimedPictureUnit;
import hmi.util.Resources;
import hmi.util.StringUtil;
import java.awt.Image;
import java.util.List;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddImagePU
implements PictureUnit {
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private static Logger logger = LoggerFactory.getLogger((String)PicturePlanner.class.getName());
    private String resourcePath;
    private String fileName;
    private float layer;
    private Image image = null;
    private PictureDisplay display;
    private String puId;

    public AddImagePU() {
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        this.addKeyPosition(start);
        this.addKeyPosition(end);
    }

    public void setDisplay(PictureDisplay display) {
        this.display = display;
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterException {
        if (name.equals("layer")) {
            this.layer = value;
        }
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (name.equals("resourcePath")) {
            this.resourcePath = value;
        } else if (name.equals("fileName")) {
            this.fileName = value;
        } else if (StringUtil.isNumeric((String)value)) {
            this.setFloatParameterValue(name, Float.parseFloat(value));
        } else {
            throw new InvalidParameterException(name, value);
        }
    }

    @Override
    public String getParameterValue(String name) throws ParameterException {
        if (name.equals("resourcePath")) {
            return this.resourcePath.toString();
        }
        if (name.equals("fileName")) {
            return this.fileName.toString();
        }
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterException {
        if (name.equals("layer")) {
            return this.layer;
        }
        return 0.0f;
    }

    @Override
    public boolean hasValidParameters() {
        return true;
    }

    @Override
    public void startUnit(double time) throws TimedPlanUnitPlayException {
        if (this.image == null) {
            ImageIcon imageIcon = new Resources(this.resourcePath).getImageIcon(this.fileName);
            if (imageIcon == null) {
                logger.warn("Error while reading image file from: " + this.resourcePath + this.fileName);
            } else {
                this.image = imageIcon.getImage();
            }
        }
        if (this.image != null) {
            this.display.addImage(this.puId, this.image, this.layer);
        }
    }

    @Override
    public void play(double t) throws PUPlayException {
    }

    @Override
    public void cleanup() {
        this.display.removeImage(this.puId, this.layer);
    }

    @Override
    public TimedPictureUnit createTPU(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id) {
        this.puId = id;
        return new TimedPictureUnit(bfm, bbPeg, bmlId, id, this);
    }

    @Override
    public String getReplacementGroup() {
        return "picturefromfile:" + this.resourcePath.toString() + this.fileName.toString();
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public PictureUnit copy(PictureDisplay display) {
        AddImagePU result = new AddImagePU();
        result.setDisplay(display);
        result.resourcePath = this.resourcePath;
        result.fileName = this.fileName;
        result.layer = this.layer;
        result.image = this.image;
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        return result;
    }

    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

