/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture.picturebinding;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.picture.display.PictureDisplay;
import hmi.picture.picturebinding.PictureUnitParameterDefault;
import hmi.picture.picturebinding.PictureUnitSpec;
import hmi.picture.planunit.PictureUnit;
import hmi.picture.planunit.TimedPictureUnit;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureBinding
extends XMLStructureAdapter {
    private ArrayList<PictureUnitSpec> specs = new ArrayList();
    private Logger logger = LoggerFactory.getLogger((String)PictureBinding.class.getName());
    private static final String XMLTAG = "picturebinding";

    public List<TimedPictureUnit> getPictureUnit(FeedbackManager fbManager, BMLBlockPeg bbPeg, Behaviour b, PictureDisplay display) {
        ArrayList<TimedPictureUnit> tpus = new ArrayList<TimedPictureUnit>();
        for (PictureUnitSpec s : this.specs) {
            if (!s.getType().equals(b.getXMLTag()) || (s.getSpecnamespace() != null || b.getNamespace() != null) && (s.getSpecnamespace() == null || !s.getSpecnamespace().equals(b.getNamespace())) || !s.satisfiesConstraints(b)) continue;
            PictureUnit puCopy = s.pictureUnit.copy(display);
            TimedPictureUnit tpu = puCopy.createTPU(fbManager, bbPeg, b.getBmlId(), b.id);
            tpus.add(tpu);
            for (PictureUnitParameterDefault pupc : s.getParameterDefaults()) {
                try {
                    puCopy.setParameterValue(pupc.name, pupc.value);
                }
                catch (ParameterException e) {
                    this.logger.warn("Error in setting default value in getPictureUnit, parameter " + pupc.name, (Throwable)e);
                }
                this.logger.debug("Setting parameter {} to default {}", (Object)pupc.name, (Object)pupc.value);
            }
            for (String param : s.getParameters()) {
                if (!b.specifiesParameter(param)) continue;
                String value = b.getStringParameterValue(param);
                try {
                    puCopy.setParameterValue(s.getParameter(param), value);
                }
                catch (ParameterException e) {
                    this.logger.warn("Error in parameter mapping in getPictureUnit, parameter " + param, (Throwable)e);
                }
                this.logger.debug("Setting parameter {} mapped to  {}", (Object)param, (Object)s.getParameter(param));
            }
        }
        return tpus;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals(PictureUnitSpec.xmlTag())) continue;
            PictureUnitSpec puSpec = new PictureUnitSpec();
            puSpec.readXML(tokenizer);
            if (puSpec.pictureUnit != null) {
                this.specs.add(puSpec);
            } else {
                this.logger.warn("Dropped picture unit spec because we could not construct the picture unit");
            }
            System.out.println(puSpec.getSpecnamespace());
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

