/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture.display;

import hmi.picture.display.ImageLayer;
import hmi.picture.display.ImagePanel;
import hmi.picture.display.PictureDisplay;
import java.awt.Component;
import java.awt.Image;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;

public class PictureJFrame
implements PictureDisplay {
    private JFrame frame;
    private ImagePanel content;
    private TreeMap<Float, ImageLayer> layers;

    public PictureJFrame() {
        this.init();
    }

    private void init() {
        this.frame = new JFrame();
        this.content = new ImagePanel();
        this.frame.getContentPane().add((Component)this.content, "Center");
        this.frame.pack();
        this.frame.setVisible(true);
        this.layers = new TreeMap();
    }

    @Override
    public void setImage(String id, Image img) {
        this.layers.clear();
        this.addImage(id, img, 1.0f);
    }

    @Override
    public void removeImage(String id, float z) {
        int layersize = this.layers.get(Float.valueOf(z)).removeImage(id);
        if (layersize == 0) {
            this.layers.remove(new Float(z));
        }
        this.redrawPicture();
    }

    @Override
    public void addImage(String id, Image img, float z) {
        ImageLayer layer = this.getImageLayer(z);
        layer.addImage(id, img);
        this.layers.put(new Float(z), layer);
        this.redrawPicture();
    }

    @Override
    public void replaceImage(String id, Image img, float z) {
        ImageLayer layer = this.getImageLayer(z);
        layer.replaceImage(id, img);
        this.layers.put(new Float(z), layer);
        this.redrawPicture();
    }

    private ImageLayer getImageLayer(float z) {
        if (this.layers.containsKey(Float.valueOf(z))) {
            return this.layers.get(Float.valueOf(z));
        }
        return new ImageLayer();
    }

    private void redrawPicture() {
        Vector<Image> images = new Vector<Image>();
        for (ImageLayer layer : new TreeMap<Float, ImageLayer>((SortedMap<Float, ImageLayer>)this.layers).values()) {
            images.add(layer.getActiveImage());
        }
        this.content.drawPicture(images);
    }
}

