/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture.display;

import hmi.util.Resources;
import java.awt.Image;
import java.io.File;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.ImageIcon;

public class AnimationLoader
extends Resources {
    private String animationDir;
    private Queue<Image> images;

    public AnimationLoader(String resourceDir, String animationDir) {
        super(resourceDir);
        this.animationDir = animationDir;
        this.loadImages();
    }

    private void loadImages() {
        this.images = new LinkedList<Image>();
        try {
            File[] files;
            File dir = this.getDirHandle();
            for (File file : files = dir.listFiles()) {
                ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                this.images.add(imageIcon.getImage());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private File getDirHandle() throws URISyntaxException {
        return new File(this.getURL(this.animationDir).toURI());
    }

    public int remainingImages() {
        return this.images.size();
    }

    public Image getNextImage() {
        return this.images.poll();
    }
}

