/*
 * Decompiled with CFR 0.152.
 */
package hmi.picture;

import hmi.bml.BMLInfo;
import hmi.bml.core.Behaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.KeyPosition;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.LinearStretchResolver;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.scheduler.UniModalResolver;
import hmi.picture.bml.AddAnimationBehavior;
import hmi.picture.bml.AddImageBehavior;
import hmi.picture.bml.SetImageBehavior;
import hmi.picture.display.PictureDisplay;
import hmi.picture.picturebinding.PictureBinding;
import hmi.picture.planunit.TimedPictureUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PicturePlanner
extends AbstractPlanner {
    private static Logger logger;
    private PictureDisplay display;
    private final PictureBinding pictureBinding;
    private UniModalResolver resolver;

    public PicturePlanner(FeedbackManager bfm, PictureBinding pb, PlanManager planManager, PictureDisplay display) {
        super(bfm, planManager);
        this.pictureBinding = pb;
        this.display = display;
        this.resolver = new LinearStretchResolver();
    }

    public PictureBinding getPictureBinding() {
        return this.pictureBinding;
    }

    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        TimedPictureUnit tpu;
        ArrayList<SyncAndTimePeg> satps = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            List<TimedPictureUnit> tpus = this.pictureBinding.getPictureUnit(this.fbManager, bbPeg, b, this.display);
            if (tpus.isEmpty()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the picture binding (no matching constraints), behavior omitted.");
            }
            tpu = tpus.get(0);
            if (!tpu.getPictureUnit().hasValidParameters()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the picture binding because the parameters are not valid, behavior omitted.");
            }
        } else {
            tpu = (TimedPictureUnit)planElement;
        }
        tpu.resolveDefaultBMLKeyPositions();
        this.linkSynchs(tpu, sacs);
        this.planManager.addPlanUnit((TimedPlanUnit)tpu);
        for (KeyPosition kp : tpu.getPegs().keySet()) {
            TimePeg p = tpu.getPegs().get(kp);
            satps.add(new SyncAndTimePeg(b.getBmlId(), b.id, kp.id, p));
        }
        return satps;
    }

    public TimedPlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        List<TimedPictureUnit> tpus = this.pictureBinding.getPictureUnit(this.fbManager, bbPeg, b, this.display);
        if (tpus.isEmpty()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the picture binding (no matching constraints), behavior omitted.");
        }
        TimedPictureUnit tpu = tpus.get(0);
        if (!tpu.getPictureUnit().hasValidParameters()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the picture binding because the parameters are not valid, behavior omitted.");
        }
        tpu.resolveDefaultBMLKeyPositions();
        this.resolver.resolveSynchs(bbPeg, b, sac, (TimedPlanUnit)tpu);
        return tpu;
    }

    public double getRigidity(Behaviour beh) {
        return 0.5;
    }

    private void linkSynchs(TimedPictureUnit tpu, List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (KeyPosition kp : tpu.getPictureUnit().getKeyPositions()) {
                if (!s.syncId.equals(kp.id)) continue;
                if (s.offset == 0.0) {
                    tpu.setTimePeg(kp, s.peg);
                    continue;
                }
                tpu.setTimePeg(kp, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(SetImageBehavior.class);
        list.add(AddImageBehavior.class);
        list.add(AddAnimationBehavior.class);
        return list;
    }

    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    static {
        BMLInfo.addBehaviourType((String)SetImageBehavior.xmlTag(), SetImageBehavior.class);
        BMLInfo.addBehaviourType((String)AddImageBehavior.xmlTag(), AddImageBehavior.class);
        BMLInfo.addBehaviourType((String)AddAnimationBehavior.xmlTag(), AddAnimationBehavior.class);
        logger = LoggerFactory.getLogger((String)PicturePlanner.class.getName());
    }
}

