/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animationengine.mixed.MixedSystem;
import hmi.environment.HmiRenderEnvironment;
import hmi.environment.OdePhysicsEnvironment;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Embodiment;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.MixedSkeletonEmbodiment;
import hmi.environment.vhloader.PhysicalEmbodiment;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.ode.OdeHumanoid;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.JointGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdePhysicalEmbodiment
implements PhysicalEmbodiment,
EmbodimentLoader {
    private Logger logger = LoggerFactory.getLogger((String)OdePhysicalEmbodiment.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private boolean glueFeetToFloor = false;
    private MixedSkeletonEmbodiment se = null;
    private OdePhysicsEnvironment ope = null;
    private HmiRenderEnvironment hre = null;
    private ArrayList<MixedSystem> mixedSystems = null;
    private ArrayList<PhysicalHumanoid> physicalHumans = null;
    private JointGroup feetGlueJointGroup = new JointGroup();
    private String id = "";

    @Override
    public void unload() {
        this.logger.debug("Removing VH from Physics");
        for (PhysicalHumanoid nextPH : this.getPhysicalHumans()) {
            this.ope.clearPhysicalHumanoid(nextPH);
        }
        this.ope.clearFeetGlueJointGroup(this.feetGlueJointGroup);
    }

    @Override
    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mixedSystems;
    }

    @Override
    public ArrayList<PhysicalHumanoid> getPhysicalHumans() {
        return this.physicalHumans;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        for (Environment environment : environments) {
            if (environment instanceof OdePhysicsEnvironment) {
                this.ope = (OdePhysicsEnvironment)environment;
            }
            if (!(environment instanceof HmiRenderEnvironment)) continue;
            this.hre = (HmiRenderEnvironment)environment;
        }
        for (Loader loader : requiredLoaders) {
            if (!(loader instanceof EmbodimentLoader) || !(((EmbodimentLoader)loader).getEmbodiment() instanceof MixedSkeletonEmbodiment)) continue;
            this.se = (MixedSkeletonEmbodiment)((EmbodimentLoader)loader).getEmbodiment();
        }
        if (this.ope == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an Environment of type OdePhysicalEnvironment");
        }
        if (this.se == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an EmbodimentLoader containing a MixedSkeletonEmbodiment (e.g., HmiRenderBodyEmbodiment)");
        }
        this.physicalHumans = new ArrayList();
        this.mixedSystems = new ArrayList();
        OdeHumanoid pHumanEmpty = this.ope.createPhysicalHumanoid("empty_" + newId);
        this.physicalHumans.add((PhysicalHumanoid)pHumanEmpty);
        float[] g = new float[]{0.0f, 0.0f, 0.0f};
        MixedSystem mSystem = this.ope.createMixedSystem(g, pHumanEmpty);
        this.mixedSystems.add(mSystem);
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        Object attrMap = null;
        if (tokenizer.atSTag("GlueFeetToFloor")) {
            this.glueFeetToFloor = true;
            tokenizer.takeSTag("GlueFeetToFloor");
            tokenizer.takeETag("GlueFeetToFloor");
        } else if (tokenizer.atSTag("MixedSystems")) {
            float[] g = new float[]{0.0f, 0.0f, 0.0f};
            int i = 0;
            tokenizer.takeSTag("MixedSystems");
            while (tokenizer.atSTag()) {
                String tag = tokenizer.getTagName();
                if (!tag.equals("MixedSystem")) {
                    throw new XMLScanException("Unknown tag in MixedSystemss: " + tag);
                }
                HashMap attrMap2 = tokenizer.getAttributes();
                String msFile = this.adapter.getRequiredAttribute("filename", attrMap2, tokenizer);
                String msName = this.adapter.getRequiredAttribute("name", attrMap2, tokenizer);
                String msResources = this.adapter.getOptionalAttribute("resources", attrMap2, "");
                i = this.physicalHumans.size();
                OdeHumanoid pHuman = this.ope.createPhysicalHumanoid(this.getId() + "_" + i + "_" + msName);
                g = new float[]{0.0f, -9.8f, 0.0f};
                MixedSystem mSystem = null;
                try {
                    mSystem = this.ope.createMixedSystem(g, pHuman, this.se.getCurrentVJoint(), msResources, msFile);
                }
                catch (IOException ex) {
                    this.logger.error("Cannot load mixed system {} from file \"{}\"; dropping mixed system.", (Object)msName, (Object)msFile);
                    continue;
                }
                this.mixedSystems.add(mSystem);
                this.physicalHumans.add((PhysicalHumanoid)pHuman);
                this.ope.initPhysicalHumanoid(pHuman);
                tokenizer.takeSTag(tag);
                tokenizer.takeETag(tag);
            }
            tokenizer.takeETag("MixedSystems");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    @Override
    public void glueFeetToFloor() {
        if (this.glueFeetToFloor) {
            for (int i = 1; i < this.physicalHumans.size(); ++i) {
                OdeHumanoid pHuman = (OdeHumanoid)this.physicalHumans.get(i);
                this.ope.glueFeetToFloor((PhysicalHumanoid)pHuman, this.feetGlueJointGroup);
            }
        }
    }

    @Override
    public Embodiment getEmbodiment() {
        return this;
    }
}

