/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animation.VJoint;
import hmi.environment.HmiRenderEnvironment;
import hmi.environment.MixedAnimationEnvironment;
import hmi.environment.vhloader.CopyEmbodiment;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Embodiment;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.impl.HmiRenderBodyAndFaceEmbodiment;
import hmi.environment.vhloader.impl.HmiRenderBodyEmbodiment;
import hmi.faceanimation.FaceController;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmiRenderEmbodimentLoader
implements EmbodimentLoader {
    private Logger logger = LoggerFactory.getLogger((String)HmiRenderEmbodimentLoader.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private Embodiment embodiment = null;
    String id = "";
    String textureDir;
    String shaderDir;
    String resourceDir;
    String bodyFilename;
    String postprocessing;
    private HashMap<String, Float> permanentmorphtargets = new HashMap();
    private boolean includeFace = false;
    private ArrayList<String> faceExpressionMorphTargets = new ArrayList();
    private String fapDeformFile = null;
    private String fapDeformResources = null;
    private String fapDeformMesh = null;
    private HmiRenderEnvironment hre = null;
    private MixedAnimationEnvironment mae = null;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        for (Environment e : environments) {
            if (e instanceof HmiRenderEnvironment) {
                this.hre = (HmiRenderEnvironment)e;
            }
            if (!(e instanceof MixedAnimationEnvironment)) continue;
            this.mae = (MixedAnimationEnvironment)e;
        }
        if (this.hre == null) {
            throw new RuntimeException("HmiRenderEmbodimentLoader requires an Environment of type HmiRenderEnvironment");
        }
        if (this.mae == null) {
            throw new RuntimeException("HmiRenderEmbodimentLoader requires an Environment of type MixedAnimationEnvironment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        this.constructEmbodiment(tokenizer, newId);
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("Body")) {
            attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("Body");
            this.textureDir = this.adapter.getOptionalAttribute("texturedir", attrMap, "");
            this.shaderDir = this.adapter.getOptionalAttribute("shaderdir", attrMap, "");
            this.resourceDir = this.adapter.getOptionalAttribute("resourcedir", attrMap, "");
            this.bodyFilename = this.adapter.getRequiredAttribute("filename", attrMap, tokenizer);
            this.postprocessing = this.adapter.getOptionalAttribute("postprocessing", attrMap, "NONE");
            tokenizer.takeETag("Body");
        } else if (tokenizer.atSTag("PermanentMorphs")) {
            tokenizer.takeSTag("PermanentMorphs");
            while (tokenizer.atSTag()) {
                String tag = tokenizer.getTagName();
                if (!tag.equals("PermanentMorph")) {
                    throw new XMLScanException("Unknown tag in PermanentMorphs: " + tag);
                }
                HashMap attrMap2 = tokenizer.getAttributes();
                String target = this.adapter.getRequiredAttribute("target", attrMap2, tokenizer);
                float amount = this.adapter.getRequiredFloatAttribute("amount", attrMap2, tokenizer);
                this.permanentmorphtargets.put(target, new Float(amount));
                tokenizer.takeSTag(tag);
                tokenizer.takeETag(tag);
            }
            tokenizer.takeETag("PermanentMorphs");
        } else if (tokenizer.atSTag("Face")) {
            this.includeFace = true;
            tokenizer.takeSTag("Face");
            while (tokenizer.atSTag()) {
                HashMap attrMap2;
                if (tokenizer.atSTag("FapDeform")) {
                    attrMap2 = tokenizer.getAttributes();
                    this.fapDeformFile = this.adapter.getRequiredAttribute("filename", attrMap2, tokenizer);
                    this.fapDeformResources = this.adapter.getOptionalAttribute("resources", attrMap2, "");
                    this.fapDeformMesh = this.adapter.getRequiredAttribute("facemesh", attrMap2, tokenizer);
                    tokenizer.takeSTag("FapDeform");
                    tokenizer.takeETag("FapDeform");
                    continue;
                }
                if (!tokenizer.atSTag("FaceExpressionMorphTargets")) continue;
                tokenizer.takeSTag("FaceExpressionMorphTargets");
                while (tokenizer.atSTag()) {
                    attrMap2 = tokenizer.getAttributes();
                    tokenizer.takeSTag("Target");
                    this.faceExpressionMorphTargets.add(this.adapter.getRequiredAttribute("name", attrMap2, tokenizer));
                    tokenizer.takeETag("Target");
                }
                tokenizer.takeETag("FaceExpressionMorphTargets");
            }
            tokenizer.takeETag("Face");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Embodiment content");
        }
    }

    private void constructEmbodiment(XMLTokenizer tokenizer, String newId) {
        if (this.bodyFilename == null) {
            throw tokenizer.getXMLScanException("Missing Body tag in VHLoader data");
        }
        this.hre.loadHumanoid(this.id, this.resourceDir, this.textureDir, this.shaderDir, this.bodyFilename, this.postprocessing, this.permanentmorphtargets);
        this.embodiment = this.includeFace ? new HmiRenderBodyAndFaceEmbodiment() : new HmiRenderBodyEmbodiment();
        VJoint root = this.hre.getHumanoidRootJoint(this.id);
        HmiRenderBodyEmbodiment bodyEmbodiment = (HmiRenderBodyEmbodiment)this.embodiment;
        bodyEmbodiment.setAnimationVJoint(root);
        bodyEmbodiment.setNextVJoint(root.copyTree("next-"));
        bodyEmbodiment.setCurrentVJoint(root.copyTree("curr-"));
        bodyEmbodiment.setPreviousVJoint(root.copyTree("prev-"));
        bodyEmbodiment.setPredictorVJoint(root.copyTree("pred-"));
        if (this.includeFace) {
            FaceController fc = this.hre.loadFace(this.id, this.fapDeformFile, this.fapDeformResources, this.fapDeformMesh, this.faceExpressionMorphTargets);
            ((HmiRenderBodyAndFaceEmbodiment)this.embodiment).setFaceController(fc);
            this.hre.addRenderCopyEmbodiment((CopyEmbodiment)this.embodiment);
        }
    }

    @Override
    public void unload() {
        HmiRenderBodyEmbodiment bodyEmbodiment = (HmiRenderBodyEmbodiment)this.embodiment;
        this.logger.debug("Removing visualisation");
        this.hre.removeRenderCopyEmbodiment((CopyEmbodiment)this.embodiment);
        this.hre.unloadHumanoid(this.id);
    }

    @Override
    public Embodiment getEmbodiment() {
        return this.embodiment;
    }
}

