/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.animationengine.AnimationPlanner;
import hmi.animationengine.AnimationPlayer;
import hmi.animationengine.AnimationPlayerManager;
import hmi.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.SingleThreadedPlanPlayer;
import hmi.environment.ElckerlycEnvironment;
import hmi.environment.MixedAnimationEnvironment;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.EngineLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.MixedSkeletonEmbodiment;
import hmi.environment.vhloader.PhysicalEmbodiment;
import hmi.math.Quat4f;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class AnimationEngineLoader
implements EngineLoader {
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private MixedSkeletonEmbodiment mse = null;
    private PhysicalEmbodiment pe = null;
    private MixedAnimationEnvironment mae = null;
    private ElckerlycEnvironment ee = null;
    private Engine engine = null;
    private PlanManager animationPlanManager = null;
    private AnimationPlayer animationPlayer = null;
    private AnimationPlanner animationPlanner = null;
    String id = "";
    GestureBinding gesturebinding = null;
    ElckerlycRealizerLoader theRealizerLoader = null;

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theRealizerLoader = realizerLoader;
        for (Environment environment : environments) {
            if (environment instanceof MixedAnimationEnvironment) {
                this.mae = (MixedAnimationEnvironment)environment;
            }
            if (!(environment instanceof ElckerlycEnvironment)) continue;
            this.ee = (ElckerlycEnvironment)environment;
        }
        for (Loader loader : requiredLoaders) {
            if (loader instanceof EmbodimentLoader && ((EmbodimentLoader)loader).getEmbodiment() instanceof MixedSkeletonEmbodiment) {
                this.mse = (MixedSkeletonEmbodiment)((EmbodimentLoader)loader).getEmbodiment();
            }
            if (!(loader instanceof EmbodimentLoader) || !(((EmbodimentLoader)loader).getEmbodiment() instanceof PhysicalEmbodiment)) continue;
            this.pe = (PhysicalEmbodiment)((EmbodimentLoader)loader).getEmbodiment();
        }
        if (this.mae == null) {
            throw new RuntimeException("AnimationEngineLoader requires an Environment of type MixedAnimationEnvironment");
        }
        if (this.ee == null) {
            throw new RuntimeException("AnimationEngineLoader requires an Environment of type ElckerlycEnvironment");
        }
        if (this.mse == null) {
            throw new RuntimeException("AnimationEngineLoader requires an EmbodimentLoader containing a MixedSkeletonEmbodiment (e.g., HmiRenderBodyEmbodiment)");
        }
        if (this.pe == null) {
            throw new RuntimeException("AnimationEngineLoader requires an EmbodimentLoader containing a PhysicalEmbodiment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        this.constructEngine(tokenizer);
    }

    @Override
    public void unload() {
        this.mae.removeAnimationPlayer(this.animationPlayer, this.mse.getCurrentVJoint(), this.mse.getAnimationVJoint());
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("GestureBinding")) {
            attrMap = tokenizer.getAttributes();
            this.gesturebinding = new GestureBinding(new Resources(this.adapter.getOptionalAttribute("basedir", attrMap, "")), this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager());
            try {
                this.gesturebinding.readXML((Reader)new Resources(this.adapter.getOptionalAttribute("resources", attrMap, "")).getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer)));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannnot load GestureBinding: " + e);
            }
            tokenizer.takeEmptyElement("GestureBinding");
        } else if (tokenizer.atSTag("StartPose")) {
            attrMap = tokenizer.getAttributes();
            try {
                Resources res = new Resources(this.adapter.getOptionalAttribute("resources", attrMap, ""));
                SkeletonPose restpose = new SkeletonPose(new XMLTokenizer((Reader)res.getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer))));
                VJoint[] vjNull = new VJoint[]{};
                restpose.setTargets((VObject[])this.mse.getNextVJoint().getParts().toArray(vjNull));
                restpose.setToTarget();
                this.mse.getNextVJoint().calculateMatrices();
            }
            catch (Exception e) {
                throw tokenizer.getXMLScanException("Cannot load start pose ");
            }
            tokenizer.takeSTag("StartPose");
            tokenizer.takeETag("StartPose");
        } else if (tokenizer.atSTag("StartPosition")) {
            attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("StartPosition");
            String offsetString = this.adapter.getRequiredAttribute("offset", attrMap, tokenizer);
            float[] startposition = XMLStructureAdapter.decodeFloatArray((String)offsetString);
            if (startposition.length != 3) {
                throw tokenizer.getXMLScanException("startposition.offset must containg a 3-float array");
            }
            this.mse.getNextVJoint().translate(startposition);
            this.mse.getNextVJoint().calculateMatrices();
            tokenizer.takeETag("StartPosition");
        } else if (tokenizer.atSTag("StartRotation")) {
            attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("StartRotation");
            String rotationString = this.adapter.getRequiredAttribute("rotation", attrMap, tokenizer);
            float[] startrotation = XMLStructureAdapter.decodeFloatArray((String)rotationString);
            if (startrotation.length != 4) {
                throw tokenizer.getXMLScanException("startrotation.rotation must containg a 4-float array");
            }
            float[] qRot = new float[4];
            Quat4f.setFromAxisAngle4f((float[])qRot, (float[])startrotation);
            this.mse.getNextVJoint().rotate(qRot);
            this.mse.getNextVJoint().calculateMatrices();
            tokenizer.takeETag("StartRotation");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    private void constructEngine(XMLTokenizer tokenizer) {
        if (this.gesturebinding == null) {
            throw tokenizer.getXMLScanException("gesturebinding is null, cannot build animation planner ");
        }
        this.animationPlanManager = new PlanManager();
        PlanManager predAnimationPlanManager = new PlanManager();
        SingleThreadedPlanPlayer animationPlanPlayer = new SingleThreadedPlanPlayer(this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager(), this.animationPlanManager);
        SingleThreadedPlanPlayer predAnimationPlanPlayer = new SingleThreadedPlanPlayer(predAnimationPlanManager);
        this.animationPlayer = new AnimationPlayer(this.mse.getPreviousVJoint(), this.mse.getCurrentVJoint(), this.mse.getNextVJoint(), this.mse.getPredictorVJoint(), this.pe.getMixedSystems(), AnimationPlayerManager.getH(), this.ee.getWorldObjectManager(), (PlanPlayer)animationPlanPlayer, (PlanPlayer)predAnimationPlanPlayer);
        this.animationPlanner = new AnimationPlanner(this.theRealizerLoader.getElckerlycRealizer().getFeedbackManager(), this.animationPlayer, this.gesturebinding, this.animationPlanManager, predAnimationPlanManager);
        this.engine = new DefaultEngine((Planner)this.animationPlanner, (Player)this.animationPlayer, this.animationPlanManager);
        this.engine.setId(this.id);
        this.animationPlayer.setResetPose();
        this.pe.glueFeetToFloor();
        this.theRealizerLoader.getElckerlycRealizer().addEngine(this.engine);
        this.mae.addAnimationPlayer(this.animationPlayer, this.mse.getNextVJoint(), this.mse.getAnimationVJoint());
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    public AnimationPlayer getAnimationPlayer() {
        return this.animationPlayer;
    }

    public AnimationPlanner getAnimationPlanner() {
        return this.animationPlanner;
    }

    public PlanManager getPlanManager() {
        return this.animationPlanManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }
}

