/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader;

import com.google.common.collect.ImmutableSet;
import hmi.audioengine.ClipSoundManager;
import hmi.audioengine.LWJGLJoalSoundManager;
import hmi.audioengine.SoundManager;
import hmi.bml.bridge.RealizerPort;
import hmi.bml.bridge.TCPIPToBMLRealizerAdapter;
import hmi.bml.ext.bmlt.BMLTBMLBehaviorAttributes;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.ElckerlycRealizer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.bridge.LogPipe;
import hmi.elckerlyc.bridge.MultiThreadedElckerlycRealizerBridge;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.FeedbackManagerImpl;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.BMLTSchedulingHandler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SchedulingHandler;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.SortedSmartBodySchedulingStrategy;
import hmi.environment.vhloader.BMLParserAssembler;
import hmi.environment.vhloader.BMLSchedulerAssembler;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycRealizerLoader
implements Loader {
    private Logger logger = LoggerFactory.getLogger((String)ElckerlycRealizerLoader.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private ElckerlycRealizer elckerlycRealizer = null;
    private RealizerPort realizerBridge = null;
    private TCPIPToBMLRealizerAdapter theServer = null;
    private BMLScheduler bmlScheduler = null;
    private SchedulingClock schedulingClock = null;
    private String name = "<no name>";
    private String defaultBMLScript = null;
    private SoundManager soundManager = null;
    private String soundmanagerType = "LJWGL_JOAL";
    private String id = "";

    public void loadBMLRealizer(String name, XMLTokenizer tokenizer, SchedulingClock sc, Environment[] environments) throws IOException {
        this.name = name;
        this.schedulingClock = sc;
        BMLParser parser = this.readParserSection(tokenizer);
        BMLBlockManager bmlBlockManager = new BMLBlockManager();
        FeedbackManagerImpl feedbackManager = new FeedbackManagerImpl(bmlBlockManager, name);
        this.bmlScheduler = this.readSchedulerSection(tokenizer, bmlBlockManager, parser, (FeedbackManager)feedbackManager);
        this.elckerlycRealizer = new ElckerlycRealizer(parser, (FeedbackManager)feedbackManager, this.schedulingClock, this.bmlScheduler, new Engine[0]);
        this.realizerBridge = new MultiThreadedElckerlycRealizerBridge(this.elckerlycRealizer);
        while (!tokenizer.atETag("BMLRealizer")) {
            this.readSection(tokenizer);
        }
        if (this.soundmanagerType.equals("LJWGL_JOAL")) {
            this.soundManager = new LWJGLJoalSoundManager();
            this.soundManager.init();
        } else if (this.soundmanagerType.equals("WAV_CLIP")) {
            this.soundManager = new ClipSoundManager();
            this.soundManager.init();
        }
    }

    protected BMLParser readParserSection(XMLTokenizer tokenizer) throws IOException {
        BMLParser parser = new BMLParser(new ImmutableSet.Builder().add(BMLTBMLBehaviorAttributes.class).build());
        if (tokenizer.atSTag("BMLParser")) {
            BMLParserAssembler assembler = new BMLParserAssembler();
            assembler.readXML(tokenizer);
            parser = assembler.getBMLParser();
        }
        return parser;
    }

    protected BMLScheduler readSchedulerSection(XMLTokenizer tokenizer, BMLBlockManager bmlBlockManager, BMLParser parser, FeedbackManager feedbackManager) throws IOException {
        BMLScheduler scheduler;
        if (tokenizer.atSTag("BMLScheduler")) {
            BMLSchedulerAssembler assembler = new BMLSchedulerAssembler(this.name, parser, feedbackManager, bmlBlockManager, this.schedulingClock);
            assembler.readXML(tokenizer);
            scheduler = assembler.getBMLScheduler();
        } else {
            scheduler = new BMLScheduler(this.name, parser, feedbackManager, this.schedulingClock, (SchedulingHandler)new BMLTSchedulingHandler((SchedulingStrategy)new SortedSmartBodySchedulingStrategy()), bmlBlockManager);
        }
        return scheduler;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void unload() {
        this.logger.debug("Stop emitters!");
        if (this.theServer != null) {
            this.theServer.shutdown();
            this.logger.debug("Attempting to shutdown server...");
        }
        if (this.soundManager != null) {
            this.soundManager.shutdown();
        }
        this.elckerlycRealizer.shutdown();
        this.logger.debug("If any pipes or ports or adapters need to be shut down, it should be done here.");
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        throw new RuntimeException("Realizer is not yet loaded from XML, method not implemented...");
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("ServerAdapter")) {
            attrMap = tokenizer.getAttributes();
            String requestPort = this.adapter.getRequiredAttribute("requestport", attrMap, tokenizer);
            String feedbackPort = this.adapter.getRequiredAttribute("feedbackport", attrMap, tokenizer);
            this.theServer = new TCPIPToBMLRealizerAdapter(this.realizerBridge, Integer.valueOf(requestPort).intValue(), Integer.valueOf(feedbackPort).intValue());
            tokenizer.takeSTag("ServerAdapter");
            tokenizer.takeETag("ServerAdapter");
        } else if (!tokenizer.atSTag("Scheduler")) {
            if (tokenizer.atSTag("LogPipe")) {
                attrMap = tokenizer.getAttributes();
                String requestLog = this.adapter.getOptionalAttribute("requestlog", attrMap);
                String feedbackLog = this.adapter.getOptionalAttribute("feedbacklog", attrMap);
                Logger rl = null;
                Logger fl = null;
                if (requestLog != null) {
                    rl = LoggerFactory.getLogger((String)requestLog);
                }
                if (feedbackLog != null) {
                    fl = LoggerFactory.getLogger((String)feedbackLog);
                }
                this.realizerBridge = new LogPipe(rl, fl, this.realizerBridge, this.schedulingClock);
                tokenizer.takeSTag("LogPipe");
                tokenizer.takeETag("LogPipe");
            } else if (tokenizer.atSTag("DefaultScript")) {
                attrMap = tokenizer.getAttributes();
                String dsRes = this.adapter.getOptionalAttribute("resources", attrMap);
                String dsFile = this.adapter.getOptionalAttribute("filename", attrMap);
                if (dsRes == null) {
                    dsRes = "";
                }
                if (dsFile != null) {
                    this.defaultBMLScript = new Resources(dsRes).read(dsFile);
                    this.logger.debug("Loading default scripts");
                    if (this.defaultBMLScript == null || this.defaultBMLScript.equals("")) {
                        this.logger.warn("Cannot load default bml script from {}/{}", (Object)dsRes, (Object)dsFile);
                    }
                }
                tokenizer.takeSTag("DefaultScript");
                tokenizer.takeETag("DefaultScript");
            } else if (tokenizer.atSTag("SoundManager")) {
                attrMap = tokenizer.getAttributes();
                this.soundmanagerType = this.adapter.getRequiredAttribute("type", attrMap, tokenizer);
                tokenizer.takeSTag("SoundManager");
                tokenizer.takeETag("SoundManager");
            } else {
                throw tokenizer.getXMLScanException("Unknown tag in BMLRealizer content");
            }
        }
    }

    public RealizerPort getRealizerBridge() {
        return this.realizerBridge;
    }

    public ElckerlycRealizer getElckerlycRealizer() {
        return this.elckerlycRealizer;
    }

    public TCPIPToBMLRealizerAdapter getTCPIPRealizerBridgeServer() {
        return this.theServer;
    }

    public BMLScheduler getBMLScheduler() {
        return this.bmlScheduler;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultBmlScript() {
        return this.defaultBMLScript;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }
}

