/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.scheduler.PhysicsSchedulingClock;
import hmi.environment.PhysicsUpdater;
import hmi.environment.PoisonPillRunnable;
import hmi.environment.RenderSync;
import hmi.environment.vhloader.CopyEmbodiment;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.impl.MixedSystemAssembler;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.ode.OdeHumanoid;
import hmi.physics.ode.OdeJoint;
import hmi.physics.ode.OdeRigidBody;
import hmi.util.ClockListener;
import hmi.util.Resources;
import hmi.util.SystemClock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.odejava.Geom;
import org.odejava.GeomPlane;
import org.odejava.HashSpace;
import org.odejava.JointGroup;
import org.odejava.Odejava;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.OdeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdePhysicsEnvironment
implements Environment,
PhysicsUpdater {
    private String id = "odephysicsenvironment";
    private Logger logger = LoggerFactory.getLogger((String)OdePhysicsEnvironment.class.getName());
    public boolean runphysics = true;
    public long physicsLoopFrequency = 100L;
    public boolean collisionEnabled = false;
    protected float[] g = new float[]{0.0f, -9.8f, 0.0f};
    protected float timeStep = 0.003f;
    @GuardedBy(value="itself")
    protected List<Runnable> physicsRunners = Collections.synchronizedList(new ArrayList());
    protected volatile boolean shutdown = false;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected World phworld;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected HashSpace space;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected JavaCollision collision;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected SystemClock physicsClock;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected List<ClockListener> prePhysicsCopyListeners = new ArrayList<ClockListener>();
    @GuardedBy(value="PhysicsSync.getSync()")
    protected PhysicsUpdater physicsUpdater;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected double prevTime = 0.0;
    @GuardedBy(value="PhysicsSync.getSync()")
    protected GeomPlane groundGeom;
    @GuardedBy(value="itself")
    protected ArrayList<CopyEmbodiment> copyEmbodiments = new ArrayList();
    @GuardedBy(value="itself")
    protected ArrayList<OdeRigidBody> rigidBodies = new ArrayList();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.initWorldPhysics();
            this.initGroundPhysics();
            this.physicsUpdater = this;
        }
    }

    protected void initWorldPhysics() {
        Odejava.init();
        this.phworld = new World();
        this.phworld.setGravity(this.g[0], this.g[1], this.g[2]);
        this.phworld.setContactSurfaceThickness(0.001f);
        this.space = new HashSpace();
        this.collision = new JavaCollision(this.phworld);
        this.collision.setSurfaceMode(OdeConstants.dContactApprox1);
        this.collision.setSurfaceMu(0.9f);
        this.collision.setSurfaceBounce(0.9f);
        this.physicsClock = new SystemClock(1000L / this.physicsLoopFrequency, "DefaultPhysicsEnvironmentRenderClock");
        this.physicsClock.addClockListener((ClockListener)new MyPhysicsClockListener());
    }

    protected void initGroundPhysics() {
        this.groundGeom = new GeomPlane(0.0f, 1.0f, 0.0f, 0.0f);
        this.space.add((Geom)this.groundGeom);
    }

    public void startPhysicsClock() {
        new Sleeper().start();
        this.prevTime = 0.0;
        this.physicsClock.start();
    }

    public void toggleCollision() {
        this.setCollisionEnabled(!this.collisionEnabled);
    }

    public void togglePhysics() {
        this.setPhysicsEnabled(!this.runphysics);
    }

    public PhysicsSchedulingClock getPhysicsSchedulingClock() {
        return new PhysicsSchedulingClock(this.physicsClock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysicsRunner(Runnable r) {
        List<Runnable> list = this.physicsRunners;
        synchronized (list) {
            if (this.physicsRunners.isEmpty() || !(this.physicsRunners.get(this.physicsRunners.size() - 1) instanceof PoisonPillRunnable)) {
                this.physicsRunners.add(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void play() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock.start();
        }
    }

    public void requestPlay() {
        this.addPhysicsRunner(new Runnable(){

            @Override
            public void run() {
                OdePhysicsEnvironment.this.play();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock.pause();
        }
    }

    public void requestPause() {
        this.addPhysicsRunner(new Runnable(){

            @Override
            public void run() {
                OdePhysicsEnvironment.this.pause();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.collision.emptyContactGroup();
            this.physicsClock.setMediaSeconds(0.0);
        }
    }

    public void requestReset() {
        this.addPhysicsRunner(new Runnable(){

            @Override
            public void run() {
                OdePhysicsEnvironment.this.reset();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock.terminate();
        }
        this.cleanUpOdeObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOdeObjects() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.space.delete();
            this.collision.delete();
            this.phworld.delete();
            Odejava.close();
        }
    }

    public void requestTerminate() {
        this.addPhysicsRunner(new Runnable(){

            @Override
            public void run() {
                OdePhysicsEnvironment.this.shutdown = true;
                OdePhysicsEnvironment.this.terminate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysicsCopyEmbodiment(CopyEmbodiment ce) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.copyEmbodiments.add(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhysicsCopyEmbodiment(CopyEmbodiment ce) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.copyEmbodiments.remove(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdeHumanoid createPhysicalHumanoid(String name) {
        OdeHumanoid pHuman = null;
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            pHuman = new OdeHumanoid(name, this.phworld, (Space)this.space);
            pHuman.setEnabled(false);
        }
        return pHuman;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixedSystem createMixedSystem(float[] g, OdeHumanoid pHuman) {
        MixedSystem mSystem = new MixedSystem(g, (PhysicalHumanoid)pHuman);
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            mSystem.setup();
        }
        return mSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixedSystem createMixedSystem(float[] g, OdeHumanoid pHuman, VJoint h, String msResources, String msFile) throws IOException {
        MixedSystem mSystem = new MixedSystem(g, (PhysicalHumanoid)pHuman);
        MixedSystemAssembler msa = new MixedSystemAssembler(h, (PhysicalHumanoid)pHuman, mSystem);
        Resources resources = new Resources(msResources);
        this.logger.debug(msFile);
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            msa.readXML(resources.getReader(msFile));
            msa.setup();
        }
        return mSystem;
    }

    public OdeRigidBody createRigidBody(String name) {
        OdeRigidBody orb = new OdeRigidBody(name, this.phworld, (Space)this.space);
        this.addRigidBody(orb);
        return orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRigidBody(OdeRigidBody orb) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.rigidBodies.add(orb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRigidBody(OdeRigidBody orb) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.rigidBodies.remove(orb);
        }
    }

    public void physicsTick(float delta) {
        if (!this.runphysics) {
            return;
        }
        if (this.collisionEnabled) {
            this.collision.collide((Space)this.space);
            this.collision.applyContacts();
        }
        this.phworld.step(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void physicsUpdate(double currentTime) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            double time = currentTime - this.prevTime;
            if (time < 0.0) {
                return;
            }
            while (time > (double)this.timeStep) {
                this.physicsTick(this.timeStep);
                time -= (double)this.timeStep;
                this.prevTime += (double)this.timeStep;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicsCopy() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            Object object2 = AnimationSync.getSync();
            synchronized (object2) {
                for (CopyEmbodiment ce : this.copyEmbodiments) {
                    ce.copy();
                }
                for (OdeRigidBody orb : this.rigidBodies) {
                    orb.copy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPhysicsRunners() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            List<Runnable> list = this.physicsRunners;
            synchronized (list) {
                for (Runnable r : this.physicsRunners) {
                    Object object2;
                    if (r instanceof PoisonPillRunnable) {
                        object2 = RenderSync.getSync();
                        synchronized (object2) {
                            Object object3 = PhysicsSync.getSync();
                            synchronized (object3) {
                                r.run();
                            }
                        }
                    }
                    object2 = PhysicsSync.getSync();
                    synchronized (object2) {
                        r.run();
                    }
                    this.physicsRunners.clear();
                }
            }
        }
    }

    protected synchronized void physicsTime(double currentTime) {
        this.physicsUpdater.physicsUpdate(currentTime);
        for (ClockListener ppcl : this.prePhysicsCopyListeners) {
            ppcl.time(currentTime);
        }
        this.physicsCopy();
        this.runPhysicsRunners();
    }

    public void setPhysicsUpdater(PhysicsUpdater pu) {
        this.physicsUpdater = pu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrePhysicsCopyListener(ClockListener ppcl) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.prePhysicsCopyListeners.add(ppcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glueFeetToFloor(PhysicalHumanoid pHuman, JointGroup feetGlueJointGroup) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            float[] pos = new float[3];
            PhysicalSegment lAnkle = pHuman.getSegment("l_ankle");
            PhysicalSegment rAnkle = pHuman.getSegment("r_ankle");
            OdeJoint jl = new OdeJoint(JointType.FIXED, "l_ankleScrew", this.phworld, feetGlueJointGroup);
            lAnkle.box.getTranslation(pos);
            jl.attach(lAnkle.box, null);
            jl.setAnchor(pos[0], pos[1], pos[2]);
            OdeJoint jr = new OdeJoint(JointType.FIXED, "r_ankleScrew", this.phworld, feetGlueJointGroup);
            rAnkle.box.getTranslation(pos);
            jr.attach(rAnkle.box, null);
            jr.setAnchor(pos[0], pos[1], pos[2]);
        }
    }

    public void clearFeetGlueJointGroup(JointGroup feetGlueJointGroup) {
        feetGlueJointGroup.empty();
        feetGlueJointGroup.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPhysicalHumanoid(PhysicalHumanoid ph) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            ph.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPhysicalHumanoid(OdeHumanoid pHuman) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            pHuman.updateCOM(0.0f);
            pHuman.setCollision(this.collision);
            pHuman.setEnabled(false);
        }
    }

    public void setCollisionEnabled(boolean ce) {
        this.collisionEnabled = ce;
    }

    public void setPhysicsEnabled(boolean rp) {
        this.runphysics = rp;
    }

    static class Sleeper
    extends Thread {
        public Sleeper() {
            super("SleeperThread");
        }

        @Override
        public void run() {
            try {
                Thread.sleep(Integer.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class MyPhysicsClockListener
    implements ClockListener {
        public void time(double currentTime) {
            OdePhysicsEnvironment.this.physicsTime(currentTime);
        }

        public void initTime(double initTime) {
        }
    }
}

