/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.AnimationSync;
import hmi.animation.VJoint;
import hmi.environment.RenderSync;
import hmi.environment.vhloader.CopyEmbodiment;
import hmi.environment.vhloader.Environment;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.model.Head;
import hmi.faceanimation.model.HeadManager;
import hmi.faceanimation.model.LowerJaw;
import hmi.facegraphics.GLHead;
import hmi.facegraphics.HMIFaceController;
import hmi.graphics.jogl.JOGLRenderer;
import hmi.graphics.opengl.GLBinding;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.renderobjects.GLNavigation2;
import hmi.graphics.opengl.renderobjects.LightBox;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import hmi.graphics.util.BufferUtil;
import hmi.graphics.util.HumanoidLoader;
import hmi.graphics.util.SceneIO;
import hmi.util.ClockListener;
import hmi.util.Resources;
import hmi.util.SystemClock;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmiRenderEnvironment
implements GLRenderObject,
Environment {
    private String id = "hmirenderenvironment";
    private static Logger logger = LoggerFactory.getLogger((String)HmiRenderEnvironment.class.getName());
    public volatile boolean render = true;
    public boolean useVsync = true;
    public int numStencilBits = 1;
    public boolean enableFSAA = true;
    public int FSAA_samples = 4;
    public boolean weakGraphicsCard = false;
    public double fovy = 40.0;
    public double fovyNear = 0.1;
    public double fovyFar = 100.0;
    public long defaultClockFrequency = 50L;
    protected GLCanvas glCanvas;
    protected GLNavigation2 glNavControl;
    protected VJoint vjCamera;
    protected LightBox lights;
    protected JOGLRenderer renderer;
    public SystemClock renderClock;
    protected List<Runnable> renderRunners = Collections.synchronizedList(new ArrayList());
    protected volatile boolean shutdown = false;
    @GuardedBy(value="itself")
    protected ArrayList<CopyEmbodiment> copyEmbodiments = new ArrayList();
    @GuardedBy(value="visualisations")
    protected ArrayList<VGLNode> visualisations = new ArrayList();
    protected ArrayList<VGLNode> hiddenVisualisations = new ArrayList();
    @GuardedBy(value="visualisationsUninitialized")
    protected ArrayList<VGLNode> visualisationsUninitialized = new ArrayList();
    @GuardedBy(value="glScenes")
    protected Map<String, GLScene> glScenes = new HashMap<String, GLScene>();
    protected List<String> objectIds = new ArrayList<String>();
    protected Map<String, VJoint> objectAnimationJoints = new HashMap<String, VJoint>();
    protected Map<String, VGLNode> objectVGLNodes = new HashMap<String, VGLNode>();
    protected List<String> humanoidIds = new ArrayList<String>();
    protected Map<String, VJoint> humanoidAnimationJoints = new HashMap<String, VJoint>();
    protected Map<String, VGLNode> humanoidVGLNodes = new HashMap<String, VGLNode>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public HmiRenderEnvironment(boolean useVsync, int numStencilBits, boolean enableFSAA, int FSAA_samples, double fovy, double fovyNear, double fovyFar, boolean weakGraphicsCard) {
        this.useVsync = useVsync;
        this.numStencilBits = numStencilBits;
        this.enableFSAA = enableFSAA;
        this.FSAA_samples = FSAA_samples;
        this.fovy = fovy;
        this.fovyNear = fovyNear;
        this.fovyFar = fovyFar;
        this.weakGraphicsCard = weakGraphicsCard;
    }

    public HmiRenderEnvironment() {
        this(false, 1, true, 4, 40.0, 0.1, 100.0, false);
    }

    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HmiRenderEnvironment.this.initCanvas();
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.initRender();
        this.initLights();
        this.initNavigation();
    }

    protected void initCanvas() {
        GLCapabilities cap = new GLCapabilities();
        cap.setSampleBuffers(this.enableFSAA);
        cap.setNumSamples(this.FSAA_samples);
        cap.setStencilBits(this.numStencilBits);
        this.glCanvas = new GLCanvas(cap);
    }

    protected void initRender() {
        this.renderer = new JOGLRenderer((GLAutoDrawable)this.glCanvas);
        this.renderer.setFOVY(this.fovy);
        this.renderer.setNear(this.fovyNear);
        this.renderer.setFar(this.fovyFar);
        this.renderClock = new SystemClock(1000L / this.defaultClockFrequency, "DefaultRenderEnvironmentClock");
        this.renderClock.addClockListener((ClockListener)new MyRenderClockCallback());
        this.renderClock.addClockListener((ClockListener)this.renderer);
        this.renderer.setScene((GLRenderObject)this);
        this.renderer.setVsync(this.useVsync);
    }

    protected void initLights() {
        this.lights = new LightBox(3);
        this.lights.get(0).setDiffuseColor(0.8f, 0.8f, 0.8f);
        this.lights.get(1).setDiffuseColor(0.6f, 0.6f, 0.6f);
        this.lights.get(2).setDiffuseColor(0.6f, 0.6f, 0.6f);
        this.lights.get(0).setPosition(-0.2777347f, 2.5676637f, 0.46893778f);
        this.lights.get(1).setPosition(-0.040819082f, 2.066795f, 2.1057882f);
        this.lights.get(2).setPosition(-1.7811359f, 2.6335182f, 1.9070864f);
        this.lights.get(0).setLinearAttenuation(1.0f);
    }

    protected void initNavigation() {
        this.glNavControl = new GLNavigation2((Component)this.glCanvas);
        this.glNavControl.setPosition(0.0f, 1.2f, 4.0f);
        this.glNavControl.time(0.0);
        this.vjCamera = new VJoint("Camera");
        this.vjCamera.setTranslation(0.0f, 1.2f, 4.0f);
    }

    public void startRenderClock() {
        this.glCanvas.requestFocusInWindow();
        this.renderClock.start();
    }

    public Component getAWTComponent() {
        if (this.glCanvas == null) {
            logger.error("Trying to access glCanvas before HmiRenderEnvironment was properly initialised");
        }
        return this.glCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTime(double currentTime) {
        this.navigate(currentTime);
        List<Runnable> list = this.renderRunners;
        synchronized (list) {
            for (Runnable r : this.renderRunners) {
                r.run();
            }
            this.renderRunners.clear();
        }
    }

    public void addRenderRunner(Runnable r) {
        this.renderRunners.add(r);
    }

    protected void play() {
        this.renderClock.start();
    }

    public void requestPlay() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.play();
            }
        });
    }

    protected void pause() {
        this.renderClock.pause();
    }

    public void requestPause() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.pause();
            }
        });
    }

    protected void reset() {
        this.renderClock.setMediaSeconds(0.0);
    }

    public void requestReset() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.reset();
            }
        });
    }

    protected void terminate() {
        this.renderClock.terminate();
    }

    public void requestTerminate() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.shutdown = true;
                HmiRenderEnvironment.this.terminate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            if (this.hasVisualisation(viz)) {
                logger.warn("Trying to add visualsation twice");
                return;
            }
            this.visualisationsUninitialized.add(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHumanoidGLScene(String id, GLScene gls) {
        Map<String, GLScene> map = this.glScenes;
        synchronized (map) {
            this.glScenes.put(id, gls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHumanoidGLScene(String id) {
        Map<String, GLScene> map = this.glScenes;
        synchronized (map) {
            this.glScenes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            if (this.visualisationsUninitialized.contains(viz)) {
                return true;
            }
        }
        arrayList = this.visualisations;
        synchronized (arrayList) {
            if (this.visualisations.contains(viz)) {
                return true;
            }
            if (this.hiddenVisualisations.contains(viz)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isVisualisationVisible(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisations;
        synchronized (arrayList) {
            return this.visualisations.contains(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisualisationVisible(VGLNode viz, boolean enabled) {
        ArrayList<VGLNode> arrayList = this.visualisations;
        synchronized (arrayList) {
            if (!enabled) {
                ArrayList<VGLNode> arrayList2 = this.visualisationsUninitialized;
                synchronized (arrayList2) {
                    if (this.visualisations.contains(viz)) {
                        this.hiddenVisualisations.add(viz);
                        this.visualisations.remove(viz);
                    } else if (this.visualisationsUninitialized.contains(viz)) {
                        this.hiddenVisualisations.add(viz);
                    } else {
                        throw new RuntimeException("Attempting to hide non-existing VGLNode " + viz.toString());
                    }
                }
            } else if (this.hiddenVisualisations.contains(viz)) {
                this.hiddenVisualisations.remove(viz);
                this.visualisations.add(viz);
            } else {
                throw new RuntimeException("Attempting to show non-existing VGLNode " + viz.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVisualisation(VGLNode viz) {
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            this.visualisationsUninitialized.remove(viz);
        }
        arrayList = this.visualisations;
        synchronized (arrayList) {
            this.visualisations.remove(viz);
            this.hiddenVisualisations.remove(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderCopyEmbodiment(CopyEmbodiment ce) {
        ArrayList<CopyEmbodiment> arrayList = this.copyEmbodiments;
        synchronized (arrayList) {
            this.copyEmbodiments.add(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderCopyEmbodiments(List<CopyEmbodiment> ces) {
        ArrayList<CopyEmbodiment> arrayList = this.copyEmbodiments;
        synchronized (arrayList) {
            this.copyEmbodiments.addAll(ces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderCopyEmbodiments(List<CopyEmbodiment> ces) {
        ArrayList<CopyEmbodiment> arrayList = this.copyEmbodiments;
        synchronized (arrayList) {
            this.copyEmbodiments.removeAll(ces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderCopyEmbodiment(CopyEmbodiment ce) {
        ArrayList<CopyEmbodiment> arrayList = this.copyEmbodiments;
        synchronized (arrayList) {
            this.copyEmbodiments.remove(ce);
        }
    }

    protected void glPreInit(GLRenderContext glc) {
        glc.glEnable(2977);
        glc.glEnable(2929);
        glc.glCullFace(1029);
        glc.glEnable(2884);
        glc.glShadeModel(7425);
        glc.glEnable(2896);
        glc.glLightModeli(2897, 1);
        glc.glPolygonMode(1032, 6914);
        float[] global_amb = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        FloatBuffer global_ambient = BufferUtil.directFloatBuffer((int)4);
        global_ambient.put(global_amb);
        global_ambient.rewind();
        glc.glLightModelfv(2899, global_ambient);
        glc.glEnable(2977);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glInit(GLRenderContext glc) {
        this.glPreInit(glc);
        this.lights.glInit(glc);
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            for (VGLNode nextVgl : this.visualisationsUninitialized) {
                nextVgl.glInit(glc);
                ArrayList<VGLNode> arrayList2 = this.visualisations;
                synchronized (arrayList2) {
                    this.visualisations.add(nextVgl);
                }
            }
            this.visualisationsUninitialized.clear();
        }
        this.glNavControl.glInit(glc);
        GLUtil.reportGLErrors((GLBinding)glc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void glPreRender(GLRenderContext glc) {
        glc.glDisable(3042);
        glc.glDepthMask(true);
        glc.glClear(17664);
        glc.glMatrixMode(5888);
        glc.glLoadIdentity();
        ArrayList<VGLNode> arrayList = this.visualisationsUninitialized;
        synchronized (arrayList) {
            for (VGLNode nextVgl : this.visualisationsUninitialized) {
                nextVgl.glInit(glc);
                ArrayList<VGLNode> arrayList2 = this.visualisations;
                synchronized (arrayList2) {
                    if (!this.hiddenVisualisations.contains(nextVgl)) {
                        this.visualisations.add(nextVgl);
                    }
                }
            }
            this.visualisationsUninitialized.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnimationResultForRender(GLRenderContext glc) {
        Object object = AnimationSync.getSync();
        synchronized (object) {
            for (VJoint vj : this.objectAnimationJoints.values()) {
                vj.calculateMatrices();
            }
            for (VJoint vj : this.humanoidAnimationJoints.values()) {
                vj.calculateMatrices();
            }
            Iterator<CopyEmbodiment> i$ = this.glScenes;
            synchronized (i$) {
                for (GLScene gls : this.glScenes.values()) {
                    gls.doMorph();
                    gls.deform();
                }
            }
            for (CopyEmbodiment ce : this.copyEmbodiments) {
                ce.copy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glRender(GLRenderContext glc) {
        if (!this.render) {
            return;
        }
        Object object = RenderSync.getSync();
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.glPreRender(glc);
            this.glNavControl.glRender(glc);
            this.lights.glRender(glc);
            this.processAnimationResultForRender(glc);
            ArrayList<VGLNode> arrayList = this.visualisations;
            synchronized (arrayList) {
                for (VGLNode nextVgl : this.visualisations) {
                    if (this.weakGraphicsCard) {
                        glc.glPushAttrib(1048575);
                        glc.glPushClientAttrib(-1);
                    }
                    nextVgl.glRender(glc);
                    glc.glDisable(3042);
                    glc.glDepthMask(true);
                    if (!this.weakGraphicsCard) continue;
                    glc.glPopClientAttrib();
                    glc.glPopAttrib();
                }
            }
            GLUtil.reportGLErrors((GLBinding)glc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void navigate(double currentTime) {
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.glNavControl.time(currentTime);
            this.vjCamera.setTranslation(this.glNavControl.getPosition());
        }
    }

    public VJoint getCameraTarget() {
        return this.vjCamera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObject(String id, String texturedirectory, String resourcedirectory, String filename) {
        if (this.objectAnimationJoints.containsKey(id)) {
            logger.error("Trying to load a rendering object with an ID that already exists");
            return;
        }
        if (texturedirectory != null) {
            GLTextureLoader.addTextureDirectory((String)texturedirectory);
        }
        GLScene theGLScene = null;
        theGLScene = SceneIO.readGLScene((String)resourcedirectory, (String)filename);
        VJoint modelRenderJoint = new VJoint("model" + filename);
        for (VJoint nextJoint : theGLScene.getVJointRoots()) {
            modelRenderJoint.addChild(nextJoint);
        }
        VGLNode model = new VGLNode(modelRenderJoint, theGLScene.getGLShapeList());
        GLShape state = new GLShape();
        state.addGLState((GLRenderObject)new GLFill());
        model.getGLShapeList().prepend((GLRenderObject)state);
        VJoint modelAnimationJoint = modelRenderJoint.masterCopyTree("master-");
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(model);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, modelAnimationJoint);
            this.objectVGLNodes.put(id, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSphere(String id, float radius, int numSlices, int numStacks, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        if (this.objectAnimationJoints.containsKey(id)) {
            logger.error("Trying to construct a sphere with an ID that already exists");
            return;
        }
        VJoint sphereRenderJoint = new VJoint("Sphere render joint");
        GLShape sphereShape = new GLShape("Sphere shape");
        GLRenderList shapeList = new GLRenderList(1);
        SphereGeometry sphereGeometry = new SphereGeometry(radius, numSlices, numStacks);
        GLMaterial sphereState = new GLMaterial();
        sphereState.setDiffuseColor(diffuse);
        sphereState.setSpecularColor(specular);
        sphereState.setAmbientColor(ambient);
        sphereState.setEmissionColor(emission);
        sphereShape.addGLGeometry((GLRenderObject)new NoTexture2DState());
        sphereShape.addGLGeometry((GLRenderObject)new GLFill());
        sphereShape.addGLGeometry((GLRenderObject)sphereState);
        sphereShape.addGLGeometry((GLRenderObject)sphereGeometry);
        sphereShape.linkToTransformMatrix(sphereRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)sphereShape);
        VGLNode vglSphere = new VGLNode(sphereRenderJoint, shapeList);
        VJoint sphereAnimationJoint = vglSphere.getRoot();
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(vglSphere);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, sphereAnimationJoint);
            this.objectVGLNodes.put(id, vglSphere);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadObject(String id) {
        if (!this.objectAnimationJoints.containsKey(id)) {
            logger.error("Trying to unload a rendering object with an ID that does not exist");
            return;
        }
        VGLNode model = this.objectVGLNodes.get(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.removeVisualisation(model);
            this.objectIds.remove(id);
            this.objectAnimationJoints.remove(id);
            this.objectVGLNodes.remove(id);
        }
    }

    public VJoint getObjectRootJoint(String id) {
        return this.objectAnimationJoints.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHumanoid(String id, String resourcedirectory, String texturedirectory, String shaderdirectory, String filename, String postprocessing, HashMap<String, Float> permanentmorphtargets) {
        if (this.humanoidAnimationJoints.containsKey(id)) {
            logger.error("Trying to load a humanoid with an ID that already exists");
            return;
        }
        if (texturedirectory != null) {
            GLTextureLoader.addTextureDirectory((String)texturedirectory);
        }
        if (shaderdirectory != null) {
            GLTextureLoader.addTextureDirectory((String)shaderdirectory);
        }
        if (shaderdirectory != null) {
            GLShaderProgramLoader.addShaderDirectory((String)shaderdirectory);
        }
        HumanoidLoader humanoidLoader = null;
        try {
            humanoidLoader = new HumanoidLoader(id, resourcedirectory, filename, postprocessing);
        }
        catch (IOException ex) {
            logger.error("Error loading humanoid: {}", (Throwable)ex);
            return;
        }
        VGLNode model = humanoidLoader.getAvatarRenderNode();
        VJoint humanoidAnimationRoot = humanoidLoader.getAvatarAnimationRootJoint();
        GLScene theGLScene = humanoidLoader.getGLScene();
        for (Map.Entry<String, Float> entry : permanentmorphtargets.entrySet()) {
            theGLScene.addMorphTargets(new String[]{entry.getKey()}, new float[]{entry.getValue().floatValue()});
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(model);
            this.humanoidIds.add(id);
            this.addHumanoidGLScene(id, theGLScene);
            this.humanoidAnimationJoints.put(id, humanoidAnimationRoot);
            this.humanoidVGLNodes.put(id, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadHumanoid(String id) {
        if (!this.humanoidAnimationJoints.containsKey(id)) {
            logger.error("Trying to unload a humanoid with an ID that does not exist");
            return;
        }
        VGLNode model = this.humanoidVGLNodes.get(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.removeVisualisation(model);
            this.humanoidIds.remove(id);
            this.removeHumanoidGLScene(id);
            this.humanoidAnimationJoints.remove(id);
            this.humanoidVGLNodes.remove(id);
        }
    }

    public VJoint getHumanoidRootJoint(String id) {
        return this.humanoidAnimationJoints.get(id);
    }

    public FaceController loadFace(String id, String fapDeformFile, String fapDeformResources, String fapDeformMesh, ArrayList<String> faceExpressionMorphTargets) {
        GLScene gls = this.glScenes.get(id);
        BufferedReader br = new Resources(fapDeformResources).getReader(fapDeformFile);
        HeadManager headManager = new HeadManager(br);
        headManager.setHead((Head)new GLHead());
        GLHead head = (GLHead)headManager.readXMLFile();
        if (head == null) {
            throw new RuntimeException("did not manage to load facemesh data from " + fapDeformFile);
        }
        GLRenderList geomList = this.getFaceShape(fapDeformMesh, this.humanoidVGLNodes.get(id)).getGeometryList();
        int geomListSize = geomList.size();
        if (geomListSize == 0) {
            throw new RuntimeException("no geomlist");
        }
        GLSkinnedMesh faceMesh = (GLSkinnedMesh)geomList.get(0);
        head.setFaceMesh(faceMesh);
        LowerJaw lowerJaw = new LowerJaw(this.humanoidAnimationJoints.get(id).getPart("temporomandibular"));
        head.setLowerJaw(lowerJaw);
        HMIFaceController fc = new HMIFaceController(gls, head);
        fc.setPossibleFaceMorphTargetNames(faceExpressionMorphTargets);
        return fc;
    }

    private GLShape getFaceShape(String shapeId, VGLNode renderNode) {
        GLRenderList shapeList = renderNode.getGLShapeList();
        for (int i = 0; i < shapeList.size(); ++i) {
            GLShape shape = (GLShape)shapeList.get(i);
            if (shape.getId() == null || !shape.getId().equals(shapeId)) continue;
            return shape;
        }
        throw new RuntimeException("Cannot find face shape with id " + shapeId);
    }

    class MyRenderClockCallback
    implements ClockListener {
        MyRenderClockCallback() {
        }

        public void initTime(double time) {
        }

        public void time(double currentTime) {
            HmiRenderEnvironment.this.renderTime(currentTime);
        }
    }
}

