/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animationengine.AnimationPlayerManager2;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Environment;
import hmi.util.ClockListener;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycEnvironment
implements Environment,
ClockListener {
    private String id = "elckerlycenvironment";
    private Logger logger = LoggerFactory.getLogger((String)ElckerlycEnvironment.class.getName());
    protected AnimationPlayerManager2 theAnimationPlayerManager = null;
    protected ArrayList<ElckerlycVirtualHuman> virtualHumanList = new ArrayList();
    protected Environment[] environments = new Environment[0];
    protected ArrayList<Engine> playableEngines = new ArrayList();
    protected SchedulingClock schedulingClock;
    WorldObjectManager theWorldObjectManager = new WorldObjectManager();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public WorldObjectManager getWorldObjectManager() {
        return this.theWorldObjectManager;
    }

    public void init(ArrayList<Environment> environments, SchedulingClock schedulingClock) {
        this.logger.debug("Initializing ElckerlycEnvironment");
        if (!environments.contains(this)) {
            environments.add(this);
        }
        this.environments = new Environment[environments.size()];
        for (int i = 0; i < environments.size(); ++i) {
            this.environments[i] = environments.get(i);
        }
        this.schedulingClock = schedulingClock;
    }

    public void time(double currentTime) {
        for (Engine e : this.playableEngines) {
            e.play(currentTime);
        }
    }

    public void initTime(double currentTime) {
        for (Engine e : this.playableEngines) {
            e.play(currentTime);
        }
    }

    public ElckerlycVirtualHuman loadVirtualHuman(String resources, String fileName, String name) throws IOException {
        ElckerlycVirtualHuman evh = new ElckerlycVirtualHuman();
        evh.load(resources, fileName, name, this.environments, this.schedulingClock);
        return evh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVirtualHuman(ElckerlycVirtualHuman evh) {
        ArrayList<ElckerlycVirtualHuman> arrayList = this.virtualHumanList;
        synchronized (arrayList) {
            this.virtualHumanList.add(evh);
            this.playableEngines.addAll(evh.getPlayableEngines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVirtualHuman(ElckerlycVirtualHuman evh) {
        ArrayList<ElckerlycVirtualHuman> arrayList = this.virtualHumanList;
        synchronized (arrayList) {
            this.virtualHumanList.remove(evh);
            this.playableEngines.removeAll(evh.getPlayableEngines());
        }
    }

    private void unloadAllVirtualHumans() {
        ArrayList<ElckerlycVirtualHuman> vhList = new ArrayList<ElckerlycVirtualHuman>();
        vhList.addAll(this.virtualHumanList);
        for (ElckerlycVirtualHuman evh : vhList) {
            this.logger.info("Disposing humanoid {}", (Object)evh.getName());
            evh.unload();
        }
    }

    protected void terminate() {
        this.logger.info("Disposing ElckerlycEnvironment");
        this.unloadAllVirtualHumans();
        this.logger.debug("Done removing humanoids");
    }

    protected void reset() {
        for (ElckerlycVirtualHuman vh : this.virtualHumanList) {
            vh.getElckerlycRealizerLoader().getRealizerBridge().performBML("<bml id=\"clear\" composition=\"replace\"></bml>");
        }
        for (Engine e : this.playableEngines) {
            e.play(0.0);
        }
    }
}

