/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.BodySpecLoader;
import hmi.environment.avatars.GenericVirtualHuman;
import hmi.environment.avatars.GenericVirtualHumanBuilder;
import hmi.environment.avatars.HmiVirtualHuman;
import hmi.environment.avatars.VirtualHumanBuilderException;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.model.Head;
import hmi.faceanimation.model.HeadManager;
import hmi.faceanimation.model.LowerJaw;
import hmi.facegraphics.GLHead;
import hmi.facegraphics.HMIFaceController;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.util.HumanoidLoader;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HmiVirtualHumanBuilder
extends GenericVirtualHumanBuilder {
    @Override
    protected void createVirtualHuman(String id) {
        this.setVirtualHuman(new HmiVirtualHuman(id));
    }

    private GLShape getFaceShape(String shapeId) {
        GLRenderList shapeList = ((HmiVirtualHuman)this.getVirtualHuman()).getRenderNode().getGLShapeList();
        for (int i = 0; i < shapeList.size(); ++i) {
            GLShape shape = (GLShape)shapeList.get(i);
            if (shape.getId() == null || !shape.getId().equals(shapeId)) continue;
            return shape;
        }
        throw new RuntimeException("Shape " + shapeId + " not found");
    }

    @Override
    protected void initFaceController() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        String resourcePath = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "fapresources", "");
        String filename = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "fapdeform", "");
        String facemesh = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "facemesh", "");
        BufferedReader br = new Resources(resourcePath).getReader(filename);
        HeadManager headManager = new HeadManager(br);
        headManager.setHead((Head)new GLHead());
        GLHead head = (GLHead)headManager.readXMLFile();
        if (head == null) {
            return;
        }
        GLRenderList geomList = this.getFaceShape(facemesh).getGeometryList();
        int geomListSize = geomList.size();
        if (geomListSize == 0) {
            return;
        }
        GLSkinnedMesh faceMesh = (GLSkinnedMesh)geomList.get(0);
        head.setFaceMesh(faceMesh);
        LowerJaw lowerJaw = new LowerJaw(((GenericVirtualHuman)this.getVirtualHuman()).getNextAnimationRootJoint().getPart("temporomandibular"));
        head.setLowerJaw(lowerJaw);
        HMIFaceController fc = new HMIFaceController(((HmiVirtualHuman)this.getVirtualHuman()).getGLScene(), head);
        ArrayList amt = (ArrayList)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "availablemorphtargets");
        fc.setPossibleFaceMorphTargetNames(amt);
        ((GenericVirtualHuman)this.getVirtualHuman()).setFaceController((FaceController)fc);
    }

    @Override
    protected void buildBody() throws VirtualHumanBuilderException {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        try {
            String colladaincludedir = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladaincludedir", "");
            String colladarenamingfile = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladarenamingfile");
            String colladafilename = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladafilename");
            if (colladafilename == null) {
                throw new RuntimeException("no colladafilename specified");
            }
            float colladascalingfactor = ((Float)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladascalingfactor", new Float(1.0f))).floatValue();
            BodySpecLoader.Humanoidtype colladahumanoidtype = (BodySpecLoader.Humanoidtype)((Object)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladahumanoidtype", (Object)BodySpecLoader.Humanoidtype.SEAMLESS));
            String colladatexturedir = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladatexturedir");
            String colladashaderdir = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladashaderdir");
            HashMap permanentmorphtargets = (HashMap)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "permanentmorphtargets");
            String colladarenderrootnode = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "colladarenderrootnode");
            if (colladahumanoidtype == BodySpecLoader.Humanoidtype.SEAMLESS && (colladarenderrootnode == null || colladarenderrootnode.equals(""))) {
                throw new RuntimeException("no colladarenderrootnode specified");
            }
            if (colladatexturedir != null) {
                GLTextureLoader.addTextureDirectory((String)colladatexturedir);
            }
            if (colladashaderdir != null) {
                GLShaderProgramLoader.addShaderDirectory((String)colladashaderdir);
            }
            Resources resources = new Resources("");
            HumanoidLoader daeLoader = null;
            String postProcessing = colladahumanoidtype == BodySpecLoader.Humanoidtype.SEAMLESS ? "ARMANDIA" : "BLUEGUY";
            daeLoader = new HumanoidLoader(this.getVirtualHuman().getId(), "", colladafilename, postProcessing);
            if (permanentmorphtargets != null) {
                for (Map.Entry entry : permanentmorphtargets.entrySet()) {
                    daeLoader.getGLScene().addMorphTargets(new String[]{(String)entry.getKey()}, new float[]{((Float)entry.getValue()).floatValue()});
                }
            }
            ((GenericVirtualHuman)this.getVirtualHuman()).setAnimationRootJoint(daeLoader.getAvatarAnimationRootJoint());
            ((HmiVirtualHuman)this.getVirtualHuman()).setGLScene(daeLoader.getGLScene());
            ((HmiVirtualHuman)this.getVirtualHuman()).setRenderNode(daeLoader.getAvatarRenderNode());
        }
        catch (IOException ex) {
            throw new VirtualHumanBuilderException(ex);
        }
    }
}

