/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.bml.bridge.RealizerBridge;
import hmi.bml.bridge.TCPIPRealizerBridgeServer;
import hmi.bml.bridge.emitters.BlinkEmitter;
import hmi.bml.core.SpeechBehaviour;
import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.ElckerlycRealizer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.AnimationPlayerManager;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.animationengine.mixed.OdeMixedSystem;
import hmi.elckerlyc.animationengine.procanimation.IKBody;
import hmi.elckerlyc.audioengine.AudioPlanner;
import hmi.elckerlyc.bridge.LoggingRealizerBridge;
import hmi.elckerlyc.bridge.MultiThreadedElckerlycRealizerBridge;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.facebinding.FaceBinding;
import hmi.elckerlyc.faceengine.viseme.VisemeBinding;
import hmi.elckerlyc.interrupt.InterruptPlanner;
import hmi.elckerlyc.parametervaluechange.ParameterValueChangePlanner;
import hmi.elckerlyc.parametervaluechange.TrajectoryBinding;
import hmi.elckerlyc.planunit.MultiThreadedPlanPlayer;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.SingleThreadedPlanPlayer;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.speechengine.DirectTTSUnitFactory;
import hmi.elckerlyc.speechengine.StdoutTextOutput;
import hmi.elckerlyc.speechengine.TTSPlanner;
import hmi.elckerlyc.speechengine.TextOutput;
import hmi.elckerlyc.speechengine.TextPlanner;
import hmi.elckerlyc.speechengine.TimedTTSUnitFactory;
import hmi.elckerlyc.speechengine.WavTTSUnitFactory;
import hmi.elckerlyc.speechengine.ttsbinding.MaryTTSBinding;
import hmi.elckerlyc.speechengine.ttsbinding.SAPITTSBinding;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.elckerlyc.wait.WaitPlanner;
import hmi.environment.avatars.GenericVirtualHuman;
import hmi.environment.avatars.MixedSystemAssembler;
import hmi.environment.avatars.VirtualHuman;
import hmi.environment.avatars.VirtualHumanBuilder;
import hmi.environment.avatars.VirtualHumanBuilderException;
import hmi.environment.avatars.VirtualHumanSpec;
import hmi.environment.avatars.VirtualWorld;
import hmi.environment.avatars.VoiceSpecLoader;
import hmi.environment.bridge.emitters.GazeEmitter;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.StdOutFaceController;
import hmi.math.Quat4f;
import hmi.nabaztag.NabaztagPlanner;
import hmi.nabaztag.NabaztagPlayer;
import hmi.nabaztag.nabaztagbinding.NabaztagBinding;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.ode.OdeHumanoid;
import hmi.physics.ode.OdeJoint;
import hmi.tts.util.PhonemeToVisemeMapping;
import hmi.tts.util.XMLPhonemeToVisemeMapping;
import hmi.util.Resources;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.JFrame;
import nabaztag.Rabbit;
import org.odejava.Space;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sera.dam.Bugs;

public abstract class GenericVirtualHumanBuilder
implements VirtualHumanBuilder {
    private static Logger logger = LoggerFactory.getLogger((String)GenericVirtualHumanBuilder.class.getName());
    private GenericVirtualHuman theVirtualHuman;

    protected void setVirtualHuman(GenericVirtualHuman vh) {
        this.theVirtualHuman = vh;
    }

    public VirtualHuman getVirtualHuman() {
        return this.theVirtualHuman;
    }

    @Override
    public VirtualHuman buildVirtualHuman(VirtualHumanSpec spec, String id, VirtualWorld vw, SchedulingClock c) throws VirtualHumanBuilderException {
        this.createVirtualHuman(id);
        ((GenericVirtualHuman)this.getVirtualHuman()).setSchedulingClock(c);
        this.getVirtualHuman().setVirtualWorld(vw);
        this.getVirtualHuman().setVirtualHumanSpec(spec);
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            ((GenericVirtualHuman)this.getVirtualHuman()).setSuppressGraphics(true);
        }
        this.buildBody();
        this.prepareMixedAnimation();
        this.initGestureBinding();
        this.initSpeechBinding();
        this.initAnimationPlanner();
        this.initParameterChangePlanner();
        this.setAvatarPose();
        this.initFaceController();
        this.initFacePlanner();
        this.initNabaztagPlanner();
        this.initAudioPlanner();
        this.initSpeechPlanner();
        this.initWaitPlanner();
        this.initInterruptPlanner();
        this.initRealizerBridge(c);
        return this.getVirtualHuman();
    }

    protected void createVirtualHuman(String id) {
        this.setVirtualHuman(new GenericVirtualHuman(id));
    }

    protected abstract void buildBody() throws VirtualHumanBuilderException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareMixedAnimation() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        VJoint avatarAnimationRootJoint = this.getVirtualHuman().getAnimationRootJoint();
        ((GenericVirtualHuman)this.getVirtualHuman()).setPreviousAnimationRootJoint(avatarAnimationRootJoint.copyTree("prev-"));
        ((GenericVirtualHuman)this.getVirtualHuman()).setCurrentAnimationRootJoint(avatarAnimationRootJoint.copyTree("curr-"));
        ((GenericVirtualHuman)this.getVirtualHuman()).setNextAnimationRootJoint(avatarAnimationRootJoint.copyTree("next-"));
        ((GenericVirtualHuman)this.getVirtualHuman()).setPredictorAnimationRootJoint(avatarAnimationRootJoint.copyTree("pred-"));
        Boolean autocreatemixedsystems = (Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("physics", "autocreatemixedsystems");
        if (autocreatemixedsystems != null && autocreatemixedsystems.booleanValue()) {
            throw new RuntimeException("Cannot yet auto create mixed systems in the new loader libraries");
        }
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            ArrayList<OdeHumanoid> pHumanList = new ArrayList<OdeHumanoid>();
            ArrayList<MixedSystem> mixedSystemList = new ArrayList<MixedSystem>();
            OdeHumanoid pHumanEmpty = new OdeHumanoid("empty_" + this.getVirtualHuman().getId(), null, null);
            pHumanEmpty.setEnabled(false);
            pHumanList.add(pHumanEmpty);
            float[] g = new float[]{0.0f, 0.0f, 0.0f};
            MixedSystem mSystem = new MixedSystem(g, (PhysicalHumanoid)pHumanEmpty);
            mSystem.setup();
            mixedSystemList.add(mSystem);
            ArrayList mixedsystemsSpec = (ArrayList)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("physics", "mixedsystems");
            ArrayList mixedsystemnames = (ArrayList)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("physics", "mixedsystemnames");
            for (int i = 0; i < mixedsystemsSpec.size(); ++i) {
                String msFile = (String)mixedsystemsSpec.get(i);
                String msName = (String)mixedsystemnames.get(i);
                OdeHumanoid pHuman = new OdeHumanoid(this.getVirtualHuman().getId() + "_" + i + msName, this.getVirtualHuman().getVirtualWorld().getWorld(), (Space)this.getVirtualHuman().getVirtualWorld().getSpace());
                pHuman.setEnabled(false);
                Resources resources = new Resources("");
                g = new float[]{0.0f, -9.8f, 0.0f};
                mSystem = new OdeMixedSystem(g, (PhysicalHumanoid)pHuman);
                MixedSystemAssembler msa = new MixedSystemAssembler(this.getVirtualHuman().getCurrentAnimationRootJoint(), (PhysicalHumanoid)pHuman, mSystem);
                try {
                    logger.debug(msFile);
                    msa.readXML(resources.getReader(msFile));
                }
                catch (IOException ex) {
                    logger.error("Cannot load mixed system {} from file \"{}\"; dropping mixed system.", (Object)msName, (Object)msFile);
                    continue;
                }
                msa.setup();
                mixedSystemList.add(mSystem);
                pHumanList.add(pHuman);
            }
            for (OdeHumanoid pHuman : pHumanList) {
                pHuman.updateCOM(0.0f);
                pHuman.setCollision(this.getVirtualHuman().getVirtualWorld().getCollision());
                pHuman.setEnabled(false);
            }
            ((GenericVirtualHuman)this.getVirtualHuman()).setMixedSystems(mixedSystemList);
            ((GenericVirtualHuman)this.getVirtualHuman()).setPhysicalHumans(pHumanList);
        }
    }

    protected void initSpeechBinding() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        String speechbindingFilename = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("speechbinding", "filename");
        String resourcesPath = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("speechbinding", "resources");
        if (speechbindingFilename == null) {
            logger.info("No speechbinding specified");
            return;
        }
        Resources res = new Resources(resourcesPath);
        SpeechBinding speechbinding = new SpeechBinding(res);
        try {
            speechbinding.readXML((Reader)res.getReader(speechbindingFilename));
            this.getVirtualHuman().getVirtualHumanSpec().addSpecParameter("speechbinding", "speechbinding", speechbinding);
            this.getVirtualHuman().setSpeechBinding(speechbinding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load GestureBinding from GestureBindingSpec with resources=\"" + resourcesPath + "\" and filename=\"" + speechbindingFilename + "\": " + e);
        }
    }

    protected void initGestureBinding() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        String gesturebindingFilename = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("gesturebinding", "filename");
        String resourcesPath = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("gesturebinding", "resources");
        if (gesturebindingFilename == null) {
            throw new RuntimeException("gesturebinding is not specified, cannot build animation planner ");
        }
        Resources res = new Resources(resourcesPath);
        GestureBinding gesturebinding = new GestureBinding(res, this.getVirtualHuman().getFeedbackManager());
        try {
            gesturebinding.readXML((Reader)res.getReader(gesturebindingFilename));
            this.getVirtualHuman().getVirtualHumanSpec().addSpecParameter("gesturebinding", "gesturebinding", gesturebinding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load GestureBinding from GestureBindingSpec with resources=\"" + resourcesPath + "\" and filename=\"" + gesturebindingFilename + "\": " + e);
        }
    }

    protected void initAnimationPlanner() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        SpeechBinding speechbinding = (SpeechBinding)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("speechbinding", "speechbinding");
        GestureBinding gesturebinding = (GestureBinding)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("gesturebinding", "gesturebinding");
        if (gesturebinding == null) {
            throw new RuntimeException("gesturebinding is null, cannot build animation planner ");
        }
        PlanManager animationPlanManager = new PlanManager();
        PlanManager predAnimationPlanManager = new PlanManager();
        SingleThreadedPlanPlayer animationPlanPlayer = new SingleThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), animationPlanManager);
        SingleThreadedPlanPlayer predAnimationPlanPlayer = new SingleThreadedPlanPlayer(predAnimationPlanManager);
        AnimationPlayer player = new AnimationPlayer(this.getVirtualHuman().getPreviousAnimationRootJoint(), this.getVirtualHuman().getCurrentAnimationRootJoint(), this.getVirtualHuman().getNextAnimationRootJoint(), this.getVirtualHuman().getPredictorAnimationRootJoint(), this.getVirtualHuman().getMixedSystems(), AnimationPlayerManager.getH(), this.getVirtualHuman().getVirtualWorld().getWorldObjectManager(), (PlanPlayer)animationPlanPlayer, (PlanPlayer)predAnimationPlanPlayer);
        IKBody nextBody = new IKBody(this.getVirtualHuman().getNextAnimationRootJoint());
        AnimationPlanner animationPlanner = new AnimationPlanner(this.getVirtualHuman().getFeedbackManager(), player, gesturebinding, speechbinding, animationPlanManager, predAnimationPlanManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setIKBody(nextBody);
        ((GenericVirtualHuman)this.getVirtualHuman()).setAnimationEngine((Engine)new DefaultEngine((Planner)animationPlanner, (Player)player, animationPlanManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setAnimationPlayer(player);
        ((GenericVirtualHuman)this.getVirtualHuman()).setAnimationPlanner(animationPlanner);
        ((GenericVirtualHuman)this.getVirtualHuman()).setAnimationPlanManager(animationPlanManager);
    }

    protected void initParameterChangePlanner() {
        PlanManager planManager = new PlanManager();
        DefaultPlayer player = new DefaultPlayer((PlanPlayer)new SingleThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager));
        ParameterValueChangePlanner planner = new ParameterValueChangePlanner(this.getVirtualHuman().getFeedbackManager(), new TrajectoryBinding(), planManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setParameterValueChangeEngine((Engine)new DefaultEngine((Planner)planner, (Player)player, planManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setParameterValueChangePlanner(planner);
        ((GenericVirtualHuman)this.getVirtualHuman()).setParameterValueChangePlayer((Player)player);
    }

    protected void setAvatarPose() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        VJoint nextAnimationRootJoint = this.getVirtualHuman().getNextAnimationRootJoint();
        SkeletonPose restpose = (SkeletonPose)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "startpose");
        VJoint[] vjNull = new VJoint[]{};
        restpose.setTargets((VObject[])nextAnimationRootJoint.getParts().toArray(vjNull));
        restpose.setToTarget();
        nextAnimationRootJoint.calculateMatrices();
        float[] offset = (float[])this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "startposition");
        nextAnimationRootJoint.translate(offset);
        nextAnimationRootJoint.calculateMatrices();
        float[] qRot = new float[4];
        float[] startrot = (float[])this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "startrotation");
        Quat4f.setFromAxisAngle4f((float[])qRot, (float[])startrot);
        nextAnimationRootJoint.rotate(qRot);
        nextAnimationRootJoint.calculateMatrices();
        this.getVirtualHuman().getAnimationPlayer().setResetPose();
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "gluefeettofloor")).booleanValue()) {
            ArrayList<OdeHumanoid> pHumanList = this.getVirtualHuman().getPhysicalHumans();
            for (int i = 1; i < pHumanList.size(); ++i) {
                OdeHumanoid pHuman = pHumanList.get(i);
                this.glueFeetToFloor((PhysicalHumanoid)pHuman);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glueFeetToFloor(PhysicalHumanoid pHuman) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            float[] pos = new float[3];
            PhysicalSegment lAnkle = pHuman.getSegment("l_ankle");
            PhysicalSegment rAnkle = pHuman.getSegment("r_ankle");
            OdeJoint jl = new OdeJoint(JointType.FIXED, "l_ankleScrew", this.getVirtualHuman().getVirtualWorld().getWorld(), this.getVirtualHuman().getFeetGlueJointGroup());
            lAnkle.box.getTranslation(pos);
            jl.attach(lAnkle.box, null);
            jl.setAnchor(pos[0], pos[1], pos[2]);
            OdeJoint jr = new OdeJoint(JointType.FIXED, "r_ankleScrew", this.getVirtualHuman().getVirtualWorld().getWorld(), this.getVirtualHuman().getFeetGlueJointGroup());
            rAnkle.box.getTranslation(pos);
            jr.attach(rAnkle.box, null);
            jr.setAnchor(pos[0], pos[1], pos[2]);
        }
    }

    protected void initFaceController() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        StdOutFaceController fc = new StdOutFaceController();
        ArrayList amt = (ArrayList)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "availablemorphtargets");
        fc.setPossibleFaceMorphTargetNames(amt);
        ((GenericVirtualHuman)this.getVirtualHuman()).setFaceController((FaceController)fc);
    }

    protected void initFacePlanner() {
        if (((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("body", "suppressbody")).booleanValue()) {
            return;
        }
        FaceBinding fb = (FaceBinding)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "facebinding");
        if (fb == null) {
            return;
        }
        PlanManager planManager = new PlanManager();
        SingleThreadedPlanPlayer planPlayer = new SingleThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager);
        FacePlayer facePlayer = new FacePlayer(this.getVirtualHuman().getBMLBlockManager(), this.getVirtualHuman().getFaceController(), (PlanPlayer)planPlayer);
        FacePlanner facePlanner = new FacePlanner(this.getVirtualHuman().getFeedbackManager(), facePlayer, fb, planManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setFaceEngine((Engine)new DefaultEngine((Planner)facePlanner, (Player)facePlayer, planManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setFacePlayer(facePlayer);
        ((GenericVirtualHuman)this.getVirtualHuman()).setFacePlanManager(planManager);
    }

    protected void initNabaztagPlanner() {
        if (this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("nabaztag", "createnabaztag") == null) {
            return;
        }
        if (!((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("nabaztag", "createnabaztag")).booleanValue()) {
            return;
        }
        String nabaztagbindingFilename = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("nabaztagbinding", "filename");
        String resourcesPath = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("nabaztagbinding", "resources");
        if (nabaztagbindingFilename == null) {
            throw new RuntimeException("nabaztagbinding is not specified, cannot build nabaztag planner ");
        }
        Resources res = new Resources(resourcesPath);
        NabaztagBinding nabaztagbinding = new NabaztagBinding();
        try {
            nabaztagbinding.readXML((Reader)res.getReader(nabaztagbindingFilename));
            this.getVirtualHuman().getVirtualHumanSpec().addSpecParameter("nabaztagbinding", "nabaztagbinding", nabaztagbinding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load NabaztagBinding from NabaztagBindingSpec with resources=\"" + resourcesPath + "\" and filename=\"" + nabaztagbindingFilename + "\": " + e);
        }
        PlanManager planManager = new PlanManager();
        SingleThreadedPlanPlayer planPlayer = new SingleThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager);
        Bugs rabbit = null;
        try {
            rabbit = new Bugs();
        }
        catch (Exception rexc) {
            rexc.printStackTrace();
            System.out.println(rexc.getMessage());
            System.exit(1);
        }
        JFrame jf = new JFrame("HMI Nabaztag");
        jf.getContentPane().add(rabbit.getGUI(jf, "SERA Nabaztag Simulator"));
        jf.pack();
        jf.setVisible(true);
        NabaztagPlayer nabaztagPlayer = new NabaztagPlayer(this.getVirtualHuman().getBMLBlockManager(), (Rabbit)rabbit, (PlanPlayer)planPlayer);
        NabaztagPlanner nabaztagPlanner = new NabaztagPlanner(this.getVirtualHuman().getFeedbackManager(), nabaztagPlayer, nabaztagbinding, planManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setNabaztagEngine((Engine)new DefaultEngine((Planner)nabaztagPlanner, (Player)nabaztagPlayer, planManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setNabaztagPlayer(nabaztagPlayer);
        ((GenericVirtualHuman)this.getVirtualHuman()).setNabaztagFrame(jf);
        ((GenericVirtualHuman)this.getVirtualHuman()).setNabaztagPlanManager(planManager);
    }

    protected void initAudioPlanner() {
        Boolean b = (Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("audioplanner", "createaudioplanner");
        if (b == null || !b.booleanValue()) {
            return;
        }
        PlanManager planManager = new PlanManager();
        DefaultPlayer ap = new DefaultPlayer((PlanPlayer)new MultiThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager));
        AudioPlanner audioPlanner = new AudioPlanner(this.getVirtualHuman().getFeedbackManager(), new Resources(""), planManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setAudioEngine((Engine)new DefaultEngine((Planner)audioPlanner, (Player)ap, planManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setAudioPlayer((Player)ap);
    }

    protected void initWaitPlanner() {
        PlanManager planManager = new PlanManager();
        SingleThreadedPlanPlayer planPlayer = new SingleThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager);
        DefaultPlayer waitPlayer = new DefaultPlayer((PlanPlayer)planPlayer);
        WaitPlanner planner = new WaitPlanner(this.getVirtualHuman().getFeedbackManager(), planManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setWaitEngine((Engine)new DefaultEngine((Planner)planner, (Player)waitPlayer, planManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setWaitPlayer((Player)waitPlayer);
    }

    protected void initInterruptPlanner() {
        PlanManager planManager = new PlanManager();
        SingleThreadedPlanPlayer planPlayer = new SingleThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager);
        DefaultPlayer player = new DefaultPlayer((PlanPlayer)planPlayer);
        InterruptPlanner planner = new InterruptPlanner(this.getVirtualHuman().getFeedbackManager(), planManager);
        ((GenericVirtualHuman)this.getVirtualHuman()).setInterruptPlanner(planner);
        ((GenericVirtualHuman)this.getVirtualHuman()).setInterruptPlayer((Player)player);
        ((GenericVirtualHuman)this.getVirtualHuman()).setInterruptEngine((Engine)new DefaultEngine((Planner)planner, (Player)player, planManager));
    }

    protected void initSpeechPlanner() {
        VoiceSpecLoader.Voicetype vt = (VoiceSpecLoader.Voicetype)((Object)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("voice", "voicetype"));
        if (vt == VoiceSpecLoader.Voicetype.NOVOICE) {
            return;
        }
        String vname = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("voice", "voicename");
        VoiceSpecLoader.Factory vf = (VoiceSpecLoader.Factory)((Object)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("voice", "factory"));
        PlanManager planManager = new PlanManager();
        MultiThreadedPlanPlayer planPlayer = new MultiThreadedPlanPlayer(this.getVirtualHuman().getFeedbackManager(), planManager);
        DefaultPlayer vp = new DefaultPlayer((PlanPlayer)planPlayer);
        VisemeBinding vb = (VisemeBinding)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("face", "visemebinding");
        TextPlanner speechPlanner = null;
        switch (vt) {
            case MARY: {
                MaryTTSBinding ttsBin;
                String marydir = (String)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("voice", "marydir");
                try {
                    XMLPhonemeToVisemeMapping vm = new XMLPhonemeToVisemeMapping();
                    vm.readXML((Reader)new Resources("").getReader("phoneme2viseme/sampade2ikp.xml"));
                    ttsBin = new MaryTTSBinding(marydir, (PhonemeToVisemeMapping)vm);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (vname != null) {
                    ttsBin.setVoice(vname);
                }
                DirectTTSUnitFactory ttsFactory = null;
                switch (vf) {
                    case DIRECT_TTS: {
                        ttsFactory = new DirectTTSUnitFactory(this.getVirtualHuman().getFeedbackManager());
                        break;
                    }
                    case WAV_TTS: {
                        ttsFactory = new WavTTSUnitFactory(this.getVirtualHuman().getFeedbackManager());
                        break;
                    }
                    default: {
                        System.err.println("cannot initialize this factory, wrong type.");
                        return;
                    }
                }
                speechPlanner = new TTSPlanner(this.getVirtualHuman().getFeedbackManager(), (TimedTTSUnitFactory)ttsFactory, (TTSBinding)ttsBin, this.getVirtualHuman().getFacePlayer(), vb, this.getVirtualHuman().getAnimationPlayer(), this.getVirtualHuman().getSpeechBinding(), planManager, this.getVirtualHuman().getFacePlanManager(), this.getVirtualHuman().getAnimationPlanManager());
                break;
            }
            case SAPI5: {
                SAPITTSBinding ttsBin = new SAPITTSBinding();
                if (vname != null) {
                    ttsBin.setVoice(vname);
                }
                ttsBin.speak(SpeechBehaviour.class, "");
                DirectTTSUnitFactory ttsFactory = null;
                switch (vf) {
                    case DIRECT_TTS: {
                        ttsFactory = new DirectTTSUnitFactory(this.getVirtualHuman().getFeedbackManager());
                        break;
                    }
                    case WAV_TTS: {
                        ttsFactory = new WavTTSUnitFactory(this.getVirtualHuman().getFeedbackManager());
                        break;
                    }
                    default: {
                        System.err.println("cannot initialize this factory, wrong type.");
                        return;
                    }
                }
                speechPlanner = new TTSPlanner(this.getVirtualHuman().getFeedbackManager(), (TimedTTSUnitFactory)ttsFactory, (TTSBinding)ttsBin, this.getVirtualHuman().getFacePlayer(), vb, this.getVirtualHuman().getAnimationPlayer(), this.getVirtualHuman().getSpeechBinding(), planManager, this.getVirtualHuman().getFacePlanManager(), this.getVirtualHuman().getAnimationPlanManager());
                break;
            }
            case TEXT: {
                speechPlanner = new TextPlanner(this.getVirtualHuman().getFeedbackManager(), (TextOutput)new StdoutTextOutput(), planManager);
                break;
            }
            default: {
                logger.warn("cannot initialize this voice, wrong type.");
                return;
            }
        }
        ((GenericVirtualHuman)this.getVirtualHuman()).setSpeechEngine((Engine)new DefaultEngine((Planner)speechPlanner, (Player)vp, planManager));
        ((GenericVirtualHuman)this.getVirtualHuman()).setSpeechPlanner((Planner)speechPlanner);
        ((GenericVirtualHuman)this.getVirtualHuman()).setSpeechPlayer((Player)vp);
    }

    protected void initRealizerBridge(SchedulingClock c) {
        boolean createbmlrealizer = (Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "createrealizer", true);
        if (createbmlrealizer) {
            boolean creategazeemitter;
            boolean createblinkemitter;
            ElckerlycRealizer theBMLRealizer = new ElckerlycRealizer(this.getVirtualHuman().getFeedbackManager(), c, this.getVirtualHuman().getBMLBlockManager(), new Engine[]{this.getVirtualHuman().getAudioEngine(), this.getVirtualHuman().getSpeechEngine(), this.getVirtualHuman().getFaceEngine(), this.getVirtualHuman().getAnimationEngine(), this.getVirtualHuman().getInterruptEngine(), this.getVirtualHuman().getWaitEngine(), this.getVirtualHuman().getParameterValueChangeEngine(), this.getVirtualHuman().getNabaztagEngine()});
            this.getVirtualHuman().getInterruptPlanner().setScheduler(theBMLRealizer.getScheduler());
            this.getVirtualHuman().getParameterValueChangePlanner().setScheduler(theBMLRealizer.getScheduler());
            boolean createserver = (Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "createserver", false);
            boolean createrequestlogger = (Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "createrequestlogger", false);
            MultiThreadedElckerlycRealizerBridge erb = new MultiThreadedElckerlycRealizerBridge(theBMLRealizer);
            if (createrequestlogger) {
                erb = new LoggingRealizerBridge(LoggerFactory.getLogger((String)(ElckerlycRealizer.class.getName() + ".BmlLog")), (RealizerBridge)erb, c, true, false);
            }
            ((GenericVirtualHuman)this.getVirtualHuman()).setRealizerBridge((RealizerBridge)erb);
            ((GenericVirtualHuman)this.getVirtualHuman()).setElckerlyc(theBMLRealizer);
            if (createserver) {
                TCPIPRealizerBridgeServer theServer = new TCPIPRealizerBridgeServer((RealizerBridge)erb, ((Integer)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "serverbmlport", 7500)).intValue(), ((Integer)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "serverfeedbackport", 7501)).intValue());
                ((GenericVirtualHuman)this.getVirtualHuman()).setRealizerServer(theServer);
            }
            if (createblinkemitter = ((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "createblinkemitter", false)).booleanValue()) {
                ((GenericVirtualHuman)this.getVirtualHuman()).setBlinkEmitter(new BlinkEmitter((RealizerBridge)erb));
            }
            if (creategazeemitter = ((Boolean)this.getVirtualHuman().getVirtualHumanSpec().getSpecParameter("bmlrealizer", "creategazeemitter", false)).booleanValue()) {
                ((GenericVirtualHuman)this.getVirtualHuman()).setGazeEmitter(new GazeEmitter((RealizerBridge)erb, this.getVirtualHuman().getId()));
            }
        }
    }
}

