/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.elckerlyc.faceengine.facebinding.FaceBinding;
import hmi.elckerlyc.faceengine.viseme.MorphVisemeBinding;
import hmi.elckerlyc.faceengine.viseme.VisemeToMorphMapping;
import hmi.environment.avatars.SpecLoader;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public class FaceSpecLoader
extends SpecLoader {
    private static final String XMLTAG = "FaceSpec";

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            this.readElement(tag, tokenizer);
        }
    }

    public void readElement(String tag, XMLTokenizer tokenizer) throws IOException {
        if (tag.equals("FaceBinding")) {
            this.readFaceBinding(tokenizer);
        } else if (tag.equals("MorphVisemeBinding")) {
            this.readMorphVisemeBinding(tokenizer);
        } else if (tag.equals("MorphTargets")) {
            this.readMorphTargets(tokenizer);
        } else {
            throw new XMLScanException("Unknown element type in FaceSpec: " + tag);
        }
    }

    public void readFaceBinding(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        String resourcesPath = this.getOptionalAttribute("resources", attrMap, "");
        String facebindingFilename = this.getRequiredAttribute("filename", attrMap, tokenizer);
        try {
            Resources res = new Resources(resourcesPath);
            FaceBinding facebinding = new FaceBinding();
            facebinding.readXML((Reader)res.getReader(facebindingFilename));
            this.getVirtualHumanSpec().addSpecParameter("face", "facebinding", facebinding);
            tokenizer.takeSTag("FaceBinding");
            tokenizer.takeETag("FaceBinding");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load FaceBinding from FaceSpec with resources=\"" + resourcesPath + "\" and filename=\"" + facebindingFilename + "\": " + e);
        }
    }

    public void readMorphVisemeBinding(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        String resourcesPath = this.getOptionalAttribute("resources", attrMap, "");
        String visemebindingFilename = this.getRequiredAttribute("filename", attrMap, tokenizer);
        try {
            VisemeToMorphMapping mapping = new VisemeToMorphMapping();
            Resources res = new Resources(resourcesPath);
            mapping.readXML((Reader)res.getReader(visemebindingFilename));
            MorphVisemeBinding visemebinding = new MorphVisemeBinding(mapping);
            this.getVirtualHumanSpec().addSpecParameter("face", "visemebinding", visemebinding);
            tokenizer.takeSTag("MorphVisemeBinding");
            tokenizer.takeETag("MorphVisemeBinding");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load VisemeToMorphMapping from FaceSpec with resources=\"" + resourcesPath + "\" and filename=\"" + visemebindingFilename + "\": " + e);
        }
    }

    public void readMorphTargets(XMLTokenizer tokenizer) throws IOException {
        tokenizer.takeSTag("MorphTargets");
        ArrayList<String> targets = new ArrayList<String>();
        while (tokenizer.atSTag("Target")) {
            HashMap attrMap = tokenizer.getAttributes();
            String name = this.getRequiredAttribute("name", attrMap, tokenizer);
            targets.add(name);
            tokenizer.takeSTag("Target");
            tokenizer.takeETag("Target");
        }
        if (!tokenizer.atETag("MorphTargets")) {
            throw new XMLScanException("Error reading MorphTargets");
        }
        tokenizer.takeETag("MorphTargets");
        this.getVirtualHumanSpec().addSpecParameter("face", "availablemorphtargets", targets);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

