/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.FaceSpecLoader;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class FaceSpecHmiLoader
extends FaceSpecLoader {
    private static final String XMLTAG = "FaceSpec";

    @Override
    public void readElement(String tag, XMLTokenizer tokenizer) throws IOException {
        if (tag.equals("FapDeform")) {
            this.readFapDeform(tokenizer);
        } else {
            super.readElement(tag, tokenizer);
        }
    }

    public void readFapDeform(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        String resourcesPath = this.getOptionalAttribute("resources", attrMap, "");
        String fapDeformFilename = this.getRequiredAttribute("filename", attrMap, tokenizer);
        String fapfacemesh = this.getRequiredAttribute("facemesh", attrMap, tokenizer);
        try {
            this.getVirtualHumanSpec().addSpecParameter("face", "fapdeform", fapDeformFilename);
            this.getVirtualHumanSpec().addSpecParameter("face", "fapresources", resourcesPath);
            this.getVirtualHumanSpec().addSpecParameter("face", "facemesh", fapfacemesh);
            tokenizer.takeSTag("FapDeform");
            tokenizer.takeETag("FapDeform");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load FapDeform from FaceSpec with resources=\"" + resourcesPath + "\" and filename=\"" + fapDeformFilename + "\": " + e);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

