/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.animation.VJoint;
import hmi.bml.bridge.RealizerBridge;
import hmi.bml.bridge.TCPIPRealizerBridgeServer;
import hmi.bml.bridge.emitters.BlinkEmitter;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.ElckerlycRealizer;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.animationengine.procanimation.IKBody;
import hmi.elckerlyc.audioengine.AudioPlanner;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.interrupt.InterruptPlanner;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.SingleThreadedPlanPlayer;
import hmi.elckerlyc.speechengine.TTSPlanner;
import hmi.elckerlyc.wait.WaitPlanner;
import hmi.environment.avatars.VirtualHuman;
import hmi.environment.avatars.VirtualHumanSpec;
import hmi.environment.avatars.VirtualWorld;
import hmi.environment.avatars.VoiceSpecLoader;
import hmi.environment.bridge.emitters.GazeEmitter;
import hmi.faceanimation.FaceController;
import hmi.physics.ode.OdeHumanoid;
import hmi.util.Resources;
import java.io.Reader;
import java.util.ArrayList;
import net.jcip.annotations.GuardedBy;
import org.odejava.JointGroup;

public class GenericVirtualHuman
implements VirtualHuman {
    private String id;
    private VirtualWorld theVirtualWorld;
    private VirtualHumanSpec theSpec;
    private VJoint animationRootJoint;
    private VJoint previousAnimationRootJoint;
    private VJoint currentAnimationRootJoint;
    private VJoint nextAnimationRootJoint;
    private VJoint predictorAnimationRootJoint;
    private ArrayList<MixedSystem> mixedSystems = new ArrayList();
    private ArrayList<OdeHumanoid> physicalHumans = new ArrayList();
    @GuardedBy(value="PhysicsSync.getSync()")
    private JointGroup feetGlueJointGroup = new JointGroup();
    private IKBody theIKBody;
    private AnimationPlanner theAnimationPlanner;
    private AnimationPlayer theAnimationPlayer;
    private InterruptPlanner theInterruptPlanner = new InterruptPlanner((Player)new DefaultPlayer((PlanPlayer)new SingleThreadedPlanPlayer()));
    private WaitPlanner theWaitPlanner = new WaitPlanner((Player)new DefaultPlayer((PlanPlayer)new SingleThreadedPlanPlayer()));
    private AudioPlanner audioPlanner;
    private FaceController faceController;
    private FacePlanner facePlanner;
    private FacePlayer facePlayer;
    private Planner speechPlanner;
    private Player verbalPlayer;
    private RealizerBridge theBMLRealizer;
    private ElckerlycRealizer theElckerlyc;
    private BlinkEmitter theBlinkEmitter;
    private GazeEmitter theGazeEmitter;
    private TCPIPRealizerBridgeServer theRealizerServer;
    private SpeechBinding speechBinding;

    public GenericVirtualHuman(String id) {
        this.id = id;
    }

    @Override
    public void cleanUp() {
        throw new RuntimeException("CLEANUP MUST STILL BE IMPLEMENTED");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVirtualHumanSpec(VirtualHumanSpec spec) {
        this.theSpec = spec;
    }

    @Override
    public VirtualHumanSpec getVirtualHumanSpec() {
        return this.theSpec;
    }

    @Override
    public void setVirtualWorld(VirtualWorld vw) {
        this.theVirtualWorld = vw;
    }

    @Override
    public VirtualWorld getVirtualWorld() {
        return this.theVirtualWorld;
    }

    public void setAnimationRootJoint(VJoint newJoint) {
        this.animationRootJoint = newJoint;
    }

    @Override
    public VJoint getAnimationRootJoint() {
        return this.animationRootJoint;
    }

    public void setPreviousAnimationRootJoint(VJoint newJoint) {
        this.previousAnimationRootJoint = newJoint;
    }

    @Override
    public VJoint getPreviousAnimationRootJoint() {
        return this.previousAnimationRootJoint;
    }

    public void setCurrentAnimationRootJoint(VJoint newJoint) {
        this.currentAnimationRootJoint = newJoint;
    }

    @Override
    public VJoint getCurrentAnimationRootJoint() {
        return this.currentAnimationRootJoint;
    }

    public void setNextAnimationRootJoint(VJoint newJoint) {
        this.nextAnimationRootJoint = newJoint;
    }

    @Override
    public VJoint getNextAnimationRootJoint() {
        return this.nextAnimationRootJoint;
    }

    public void setPredictorAnimationRootJoint(VJoint newJoint) {
        this.predictorAnimationRootJoint = newJoint;
    }

    @Override
    public VJoint getPredictorAnimationRootJoint() {
        return this.predictorAnimationRootJoint;
    }

    public void setMixedSystems(ArrayList<MixedSystem> ms) {
        this.mixedSystems = ms;
    }

    @Override
    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mixedSystems;
    }

    public void setPhysicalHumans(ArrayList<OdeHumanoid> ph) {
        this.physicalHumans = ph;
    }

    @Override
    public ArrayList<OdeHumanoid> getPhysicalHumans() {
        return this.physicalHumans;
    }

    @Override
    public JointGroup getFeetGlueJointGroup() {
        return this.feetGlueJointGroup;
    }

    public void setIKBody(IKBody ikb) {
        this.theIKBody = ikb;
    }

    @Override
    public IKBody getIKBody() {
        return this.theIKBody;
    }

    public void setAnimationPlanner(AnimationPlanner ap) {
        this.theAnimationPlanner = ap;
    }

    @Override
    public void setAnimationPlayer(AnimationPlayer ap) {
        this.theAnimationPlayer = ap;
    }

    @Override
    public AnimationPlayer getAnimationPlayer() {
        return this.theAnimationPlayer;
    }

    @Override
    public AnimationPlanner getAnimationPlanner() {
        return this.theAnimationPlanner;
    }

    @Override
    public InterruptPlanner getInterruptPlanner() {
        return this.theInterruptPlanner;
    }

    @Override
    public WaitPlanner getWaitPlanner() {
        return this.theWaitPlanner;
    }

    @Override
    public SpeechBinding getSpeechBinding() {
        return this.speechBinding;
    }

    @Override
    public void setSpeechBinding(SpeechBinding binding) {
        this.speechBinding = binding;
    }

    @Override
    public void reloadGestureBinding() {
        String gesturebindingFilename = (String)this.getVirtualHumanSpec().getSpecParameter("gesturebinding", "filename");
        String resourcePath = (String)this.getVirtualHumanSpec().getSpecParameter("gesturebinding", "resources");
        this.loadNewGestureBinding(new Resources(resourcePath), gesturebindingFilename);
    }

    @Override
    public void loadNewGestureBinding(Resources res, String filename) {
        this.getVirtualHumanSpec().addSpecParameter("gesturebinding", "filename", filename);
        this.getVirtualHumanSpec().addSpecParameter("gesturebinding", "resources", res.getResourceDirectory());
        if (filename == null) {
            throw new RuntimeException("gesturebinding is not specified, cannot build animation planner ");
        }
        GestureBinding gesturebinding = new GestureBinding(res);
        try {
            gesturebinding.readXML((Reader)res.getReader(filename));
            this.getVirtualHumanSpec().addSpecParameter("gesturebinding", "gesturebinding", gesturebinding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannnot load GestureBinding from GestureBindingSpec with resources=\"" + res.getResourceDirectory() + "\" and filename=\"" + filename + "\": " + e);
        }
        this.getAnimationPlanner().setGestureBinding(gesturebinding);
    }

    protected void setAudioPlanner(AudioPlanner ap) {
        this.audioPlanner = ap;
    }

    @Override
    public AudioPlanner getAudioPlanner() {
        return this.audioPlanner;
    }

    protected void setFaceController(FaceController fc) {
        this.faceController = fc;
    }

    @Override
    public FaceController getFaceController() {
        return this.faceController;
    }

    protected void setFacePlanner(FacePlanner fp) {
        this.facePlanner = fp;
    }

    protected void setFacePlayer(FacePlayer fp) {
        this.facePlayer = fp;
    }

    @Override
    public FacePlanner getFacePlanner() {
        return this.facePlanner;
    }

    @Override
    public FacePlayer getFacePlayer() {
        return this.facePlayer;
    }

    protected void setSpeechPlanner(Planner sp) {
        this.speechPlanner = sp;
    }

    protected void setSpeechPlayer(Player player) {
        this.verbalPlayer = player;
    }

    @Override
    public Player getSpeechPlayer() {
        return this.verbalPlayer;
    }

    @Override
    public Planner getSpeechPlanner() {
        return this.speechPlanner;
    }

    @Override
    public void setVoice(String newVoice) {
        if (this.getSpeechPlanner() == null) {
            throw new RuntimeException("Cannot change the voice for " + this.getId() + ", because it did not have a voice in the first place");
        }
        this.getVirtualHumanSpec().addSpecParameter("voice", "voicename", newVoice);
        switch ((VoiceSpecLoader.Voicetype)((Object)this.getVirtualHumanSpec().getSpecParameter("voice", "voicetype"))) {
            case NOVOICE: {
                return;
            }
            case MARY: 
            case SAPI5: {
                if (!(this.getSpeechPlanner() instanceof TTSPlanner)) break;
                ((TTSPlanner)this.getSpeechPlanner()).setSpeaker(newVoice);
                break;
            }
            default: {
                System.err.println("cannot initialize this voice, wrong type");
                return;
            }
        }
    }

    public void setRealizerBridge(RealizerBridge bmlr) {
        this.theBMLRealizer = bmlr;
    }

    @Override
    public RealizerBridge getRealizerBridge() {
        return this.theBMLRealizer;
    }

    public void setElckerlyc(ElckerlycRealizer er) {
        this.theElckerlyc = er;
    }

    @Override
    public ElckerlycRealizer getElckerlyc() {
        return this.theElckerlyc;
    }

    public void setBlinkEmitter(BlinkEmitter be) {
        this.theBlinkEmitter = be;
    }

    @Override
    public BlinkEmitter getBlinkEmitter() {
        return this.theBlinkEmitter;
    }

    public void setGazeEmitter(GazeEmitter gc) {
        this.theGazeEmitter = gc;
    }

    @Override
    public GazeEmitter getGazeEmitter() {
        return this.theGazeEmitter;
    }

    public void setRealizerServer(TCPIPRealizerBridgeServer server) {
        this.theRealizerServer = server;
    }

    @Override
    public TCPIPRealizerBridgeServer getRealizerServer() {
        return this.theRealizerServer;
    }
}

