/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.avatars;

import hmi.environment.avatars.BodySpecLoader;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class BodySpecHmiLoader
extends BodySpecLoader {
    private static final String XMLTAG = "BodySpec";

    @Override
    public void readElement(String tag, XMLTokenizer tokenizer) throws IOException {
        if (tag.equals("PermanentMorphs")) {
            this.readPermanentMorphs(tokenizer);
        } else {
            super.readElement(tag, tokenizer);
        }
    }

    @Override
    public void readColladaElement(String tag, XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        if (tag.equals("ColladaTextureDir")) {
            String path = this.getRequiredAttribute("path", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladatexturedir", path);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else if (tag.equals("ColladaShaderDir")) {
            String path = this.getRequiredAttribute("path", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladashaderdir", path);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else if (tag.equals("ColladaRenderRootNode")) {
            String jointname = this.getRequiredAttribute("jointname", attrMap, tokenizer);
            this.getVirtualHumanSpec().addSpecParameter("body", "colladarenderrootnode", jointname);
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        } else {
            super.readColladaElement(tag, tokenizer);
        }
    }

    public void readPermanentMorphs(XMLTokenizer tokenizer) throws IOException {
        tokenizer.takeSTag("PermanentMorphs");
        HashMap<String, Float> permanentmorphtargets = new HashMap<String, Float>();
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals("PermanentMorph")) {
                throw new XMLScanException("Unknown tag in PermanentMorphs: " + tag);
            }
            HashMap attrMap = tokenizer.getAttributes();
            String target = this.getRequiredAttribute("target", attrMap, tokenizer);
            float amount = this.getRequiredFloatAttribute("amount", attrMap, tokenizer);
            permanentmorphtargets.put(target, new Float(amount));
            tokenizer.takeSTag(tag);
            tokenizer.takeETag(tag);
        }
        this.getVirtualHumanSpec().addSpecParameter("body", "permanentmorphtargets", permanentmorphtargets);
        tokenizer.takeETag("PermanentMorphs");
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

