/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.util.ClockListener;
import hmi.util.KeyState;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class NavigationControl
implements ClockListener,
GLRenderObject {
    KeyState keyState;
    float[] position = new float[3];
    float[] orientation = new float[3];
    double currentDoubleTime;
    double lastTime;
    float linVel;
    float vertVel;
    float strafeVel;
    float angVel;
    public static final double degToRad = Math.PI / 180;
    private static final float conv = (float)Math.PI / 180;
    private float[] rotation = new float[4];
    private float[] translation = new float[3];
    private float[] transformMatrix = new float[16];
    private float[] rotationMatrix = new float[16];
    private float[] translationMatrix = new float[16];
    private List<Integer> theKeyModifiers = null;
    private float inversionFactor = 1.0f;

    public NavigationControl(Component c, VJoint viewpoint, boolean invert, int[] keyModifiers) {
        this.keyState = new KeyState(c);
        if (!invert) {
            this.inversionFactor = -1.0f;
        }
        this.theKeyModifiers = new ArrayList<Integer>();
        for (int i = 0; i < keyModifiers.length; ++i) {
            this.theKeyModifiers.add(keyModifiers[i]);
        }
        Mat4f.setIdentity((float[])this.rotationMatrix);
        Mat4f.setIdentity((float[])this.translationMatrix);
        Mat4f.setIdentity((float[])this.transformMatrix);
        this.setVelocities(1.0f);
    }

    public void setVelocities(float vel) {
        this.linVel = vel;
        this.vertVel = vel;
        this.strafeVel = vel;
        this.angVel = vel * 50.0f;
    }

    public void setLinearVelocity(float vel) {
        this.linVel = vel;
    }

    public void setVerticalVelocity(float vel) {
        this.vertVel = vel;
    }

    public void setStrafeVelocity(float vel) {
        this.strafeVel = vel;
    }

    public void setAngularVelocity(float vel) {
        this.angVel = vel;
    }

    public void glInit(GLRenderContext gl) {
    }

    public void glRender(GLRenderContext gl) {
        gl.glMultTransposeMatrixf(this.transformMatrix);
    }

    public void setPosition(float[] pos) {
        this.position[0] = pos[0];
        this.position[1] = pos[1];
        this.position[2] = pos[2];
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
    }

    public float[] getPosition() {
        return new float[]{this.position[0], this.position[1], this.position[2]};
    }

    public void setOrientation(float xrot, float yrot, float zrot) {
        this.orientation[0] = xrot;
        this.orientation[1] = -yrot;
        this.orientation[2] = zrot;
    }

    public float[] getOrientation() {
        return new float[]{this.orientation[0], this.orientation[1], this.orientation[2]};
    }

    private boolean correctModifiers(KeyState keyState) {
        if (this.theKeyModifiers.contains(17) != keyState.isKeyDown(17)) {
            return false;
        }
        if (this.theKeyModifiers.contains(18) != keyState.isKeyDown(18)) {
            return false;
        }
        return this.theKeyModifiers.contains(16) == keyState.isKeyDown(16);
    }

    public void initTime(double currentTime) {
        this.lastTime = this.currentDoubleTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(double currentTime) {
        this.currentDoubleTime = currentTime;
        float linearVelocity = 0.0f;
        float vertVelocity = 0.0f;
        float strafeVelocity = 0.0f;
        float angularVelocityY = 0.0f;
        float angularVelocityX = 0.0f;
        KeyState keyState = this.keyState;
        synchronized (keyState) {
            if (this.keyState.isKeyDown(38) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * this.linVel;
            }
            if (this.keyState.isKeyDown(87) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * 3.0f * this.linVel;
            }
            if (this.keyState.isKeyDown(40) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * -this.linVel;
            }
            if (this.keyState.isKeyDown(83) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * -3.0f * this.linVel;
            }
            if (this.keyState.isKeyDown(37) && this.correctModifiers(this.keyState)) {
                angularVelocityY = this.inversionFactor * this.angVel;
            }
            if (this.keyState.isKeyDown(65) && this.correctModifiers(this.keyState)) {
                strafeVelocity = this.inversionFactor * -4.0f * this.strafeVel;
            }
            if (this.keyState.isKeyDown(39) && this.correctModifiers(this.keyState)) {
                angularVelocityY = this.inversionFactor * -this.angVel;
            }
            if (this.keyState.isKeyDown(68) && this.correctModifiers(this.keyState)) {
                strafeVelocity = this.inversionFactor * 4.0f * this.strafeVel;
            }
            if (this.keyState.isKeyDown(33) && this.correctModifiers(this.keyState)) {
                vertVelocity = this.inversionFactor * this.vertVel;
            }
            if (this.keyState.isKeyDown(34) && this.correctModifiers(this.keyState)) {
                vertVelocity = this.inversionFactor * -this.vertVel;
            }
        }
        float delta = (float)(this.currentDoubleTime - this.lastTime);
        this.lastTime = this.currentDoubleTime;
        float angle = this.orientation[0] + delta * angularVelocityX;
        if (angle >= 360.0f) {
            angle -= 360.0f;
        }
        if (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.orientation[0] = angle;
        angle = this.orientation[1] + delta * angularVelocityY;
        if (angle >= 360.0f) {
            angle -= 360.0f;
        }
        if (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.orientation[1] = angle;
        double radAngle = Math.PI / 180 * (double)this.orientation[1];
        float deltalinx = -delta * linearVelocity * (float)Math.sin(radAngle);
        this.position[0] = this.position[0] + deltalinx;
        float deltalinz = -delta * linearVelocity * (float)Math.cos(radAngle);
        this.position[2] = this.position[2] + deltalinz;
        float deltax = delta * strafeVelocity * (float)Math.cos(radAngle);
        this.position[0] = this.position[0] + deltax;
        this.position[2] = this.position[2] - delta * strafeVelocity * (float)Math.sin(radAngle);
        this.position[1] = this.position[1] + delta * vertVelocity;
        this.setRollPitchYaw(-this.orientation[2], -this.orientation[0], -this.orientation[1]);
        this.setTranslation(-this.position[0], -this.position[1], -this.position[2]);
        Mat4f.setRotation((float[])this.rotationMatrix, (float[])this.rotation);
        Mat4f.setTranslation((float[])this.translationMatrix, (float[])this.translation);
        Mat4f.mul((float[])this.transformMatrix, (float[])this.rotationMatrix, (float[])this.translationMatrix);
    }

    public void setRollPitchYaw(float roll, float pitch, float yaw) {
        Quat4f.setFromEulerAngles((float[])this.rotation, (float)(yaw * ((float)Math.PI / 180)), (float)(pitch * ((float)Math.PI / 180)), (float)(roll * ((float)Math.PI / 180)));
    }

    public void setTranslation(float tx, float ty, float tz) {
        this.translation[0] = tx;
        this.translation[1] = ty;
        this.translation[2] = tz;
    }
}

