/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.environment.PhysicalEnvironment;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.impl.MixedSystemAssembler;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.ode.OdeHumanoid;
import hmi.physics.ode.OdeJoint;
import hmi.util.Resources;
import java.io.IOException;
import org.odejava.HashSpace;
import org.odejava.JointGroup;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.collision.JavaCollision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdePhysicalEnvironment
implements Environment,
hmi.environment.vhloader.PhysicalEnvironment {
    private Logger logger = LoggerFactory.getLogger((String)OdePhysicalEnvironment.class.getName());
    private PhysicalEnvironment physicalEnvironment = null;
    private JavaCollision collision;
    private World world;
    private HashSpace space;
    private String id = "odephysicalenvironment";

    public OdePhysicalEnvironment(PhysicalEnvironment pe) {
        this.physicalEnvironment = pe;
    }

    public void setCollision(JavaCollision col) {
        this.collision = col;
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void setSpace(HashSpace s) {
        this.space = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdeHumanoid createPhysicalHumanoid(String name) {
        OdeHumanoid pHuman = null;
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            pHuman = new OdeHumanoid(name, this.world, (Space)this.space);
            pHuman.setEnabled(false);
        }
        return pHuman;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixedSystem createMixedSystem(float[] g, OdeHumanoid pHuman) {
        MixedSystem mSystem = new MixedSystem(g, (PhysicalHumanoid)pHuman);
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            mSystem.setup();
        }
        return mSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixedSystem createMixedSystem(float[] g, OdeHumanoid pHuman, VJoint h, String msResources, String msFile) throws IOException {
        MixedSystem mSystem = new MixedSystem(g, (PhysicalHumanoid)pHuman);
        MixedSystemAssembler msa = new MixedSystemAssembler(h, (PhysicalHumanoid)pHuman, mSystem);
        Resources resources = new Resources(msResources);
        this.logger.debug(msFile);
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            msa.readXML(resources.getReader(msFile));
            msa.setup();
        }
        return mSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glueFeetToFloor(PhysicalHumanoid pHuman, JointGroup feetGlueJointGroup) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            float[] pos = new float[3];
            PhysicalSegment lAnkle = pHuman.getSegment("l_ankle");
            PhysicalSegment rAnkle = pHuman.getSegment("r_ankle");
            OdeJoint jl = new OdeJoint(JointType.FIXED, "l_ankleScrew", this.world, feetGlueJointGroup);
            lAnkle.box.getTranslation(pos);
            jl.attach(lAnkle.box, null);
            jl.setAnchor(pos[0], pos[1], pos[2]);
            OdeJoint jr = new OdeJoint(JointType.FIXED, "r_ankleScrew", this.world, feetGlueJointGroup);
            rAnkle.box.getTranslation(pos);
            jr.attach(rAnkle.box, null);
            jr.setAnchor(pos[0], pos[1], pos[2]);
        }
    }

    public void clearFeetGlueJointGroup(JointGroup feetGlueJointGroup) {
        feetGlueJointGroup.empty();
        feetGlueJointGroup.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPhysicalHumanoid(PhysicalHumanoid ph) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            ph.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPhysicalHumanoid(OdeHumanoid pHuman) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            pHuman.updateCOM(0.0f);
            pHuman.setCollision(this.collision);
            pHuman.setEnabled(false);
        }
    }

    @Override
    public void addPhysicsRunner(Runnable r) {
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

