/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animation.VJoint;
import hmi.debug.physics.PhysicsDebugVisualisations;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.environment.vhloader.DebugVGLEmbodiment;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Embodiment;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.PhysicalEmbodiment;
import hmi.environment.vhloader.SkeletonEmbodiment;
import hmi.environment.vhloader.impl.HmiRenderEnvironment;
import hmi.environment.vhloader.impl.OdePhysicalEnvironment;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.ode.OdeHumanoid;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.JointGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdePhysicalEmbodiment
implements PhysicalEmbodiment,
EmbodimentLoader,
DebugVGLEmbodiment {
    private Logger logger = LoggerFactory.getLogger((String)OdePhysicalEmbodiment.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private boolean glueFeetToFloor = false;
    private SkeletonEmbodiment se = null;
    private OdePhysicalEnvironment ope = null;
    private HmiRenderEnvironment hre = null;
    private float[] debugOffset = new float[]{0.0f, 0.0f, 0.0f};
    private boolean addDebugPH = false;
    private ArrayList<VGLNode> debugVGLNodes = new ArrayList();
    private ArrayList<VJoint> debugVJoints = new ArrayList();
    private ArrayList<MixedSystem> mixedSystems = null;
    private ArrayList<PhysicalHumanoid> physicalHumans = null;
    private JointGroup feetGlueJointGroup = new JointGroup();
    private String id = "";

    @Override
    public void unload() {
        this.logger.debug("Removing VH from Physics");
        for (PhysicalHumanoid nextPH : this.getPhysicalHumans()) {
            this.ope.clearPhysicalHumanoid(nextPH);
        }
        this.ope.clearFeetGlueJointGroup(this.feetGlueJointGroup);
        if (this.addDebugPH) {
            this.removeDebugVisualisation();
        }
    }

    @Override
    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mixedSystems;
    }

    @Override
    public ArrayList<PhysicalHumanoid> getPhysicalHumans() {
        return this.physicalHumans;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        for (Environment environment : environments) {
            if (environment instanceof OdePhysicalEnvironment) {
                this.ope = (OdePhysicalEnvironment)environment;
            }
            if (!(environment instanceof HmiRenderEnvironment)) continue;
            this.hre = (HmiRenderEnvironment)environment;
        }
        for (Loader loader : requiredLoaders) {
            if (!(loader instanceof EmbodimentLoader) || !(((EmbodimentLoader)loader).getEmbodiment() instanceof SkeletonEmbodiment)) continue;
            this.se = (SkeletonEmbodiment)((EmbodimentLoader)loader).getEmbodiment();
        }
        if (this.ope == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an Environment of type OdePhysicalEnvironment");
        }
        if (this.se == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an EmbodimentLoader containing a SkeletonEmbodiment (e.g., HmiRenderBodyEmbodiment)");
        }
        this.physicalHumans = new ArrayList();
        this.mixedSystems = new ArrayList();
        OdeHumanoid pHumanEmpty = this.ope.createPhysicalHumanoid("empty_" + newId);
        this.physicalHumans.add((PhysicalHumanoid)pHumanEmpty);
        float[] g = new float[]{0.0f, 0.0f, 0.0f};
        MixedSystem mSystem = this.ope.createMixedSystem(g, pHumanEmpty);
        this.mixedSystems.add(mSystem);
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        if (this.addDebugPH) {
            this.addDebugVisualisation(this.debugOffset);
        }
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("GlueFeetToFloor")) {
            this.glueFeetToFloor = true;
            tokenizer.takeSTag("GlueFeetToFloor");
            tokenizer.takeETag("GlueFeetToFloor");
        } else if (tokenizer.atSTag("MixedSystems")) {
            float[] g = new float[]{0.0f, 0.0f, 0.0f};
            int i = 0;
            tokenizer.takeSTag("MixedSystems");
            while (tokenizer.atSTag()) {
                String tag = tokenizer.getTagName();
                if (!tag.equals("MixedSystem")) {
                    throw new XMLScanException("Unknown tag in MixedSystemss: " + tag);
                }
                HashMap attrMap2 = tokenizer.getAttributes();
                String msFile = this.adapter.getRequiredAttribute("filename", attrMap2, tokenizer);
                String msName = this.adapter.getRequiredAttribute("name", attrMap2, tokenizer);
                String msResources = this.adapter.getOptionalAttribute("resources", attrMap2, "");
                i = this.physicalHumans.size();
                OdeHumanoid pHuman = this.ope.createPhysicalHumanoid(this.getId() + "_" + i + "_" + msName);
                g = new float[]{0.0f, -9.8f, 0.0f};
                MixedSystem mSystem = null;
                try {
                    mSystem = this.ope.createMixedSystem(g, pHuman, this.se.getCurrentVJoint(), msResources, msFile);
                }
                catch (IOException ex) {
                    this.logger.error("Cannot load mixed system {} from file \"{}\"; dropping mixed system.", (Object)msName, (Object)msFile);
                    continue;
                }
                this.mixedSystems.add(mSystem);
                this.physicalHumans.add((PhysicalHumanoid)pHuman);
                this.ope.initPhysicalHumanoid(pHuman);
                tokenizer.takeSTag(tag);
                tokenizer.takeETag(tag);
            }
            tokenizer.takeETag("MixedSystems");
        } else if (tokenizer.atSTag("DebugPhysicalHuman")) {
            attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("DebugPhysicalHuman");
            String offsetString = this.adapter.getOptionalAttribute("offset", attrMap, "0 0 0");
            this.debugOffset = XMLStructureAdapter.decodeFloatArray((String)offsetString);
            tokenizer.takeETag("DebugPhysicalHuman");
            this.addDebugPH = true;
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    @Override
    public void glueFeetToFloor() {
        if (this.glueFeetToFloor) {
            for (int i = 1; i < this.physicalHumans.size(); ++i) {
                OdeHumanoid pHuman = (OdeHumanoid)this.physicalHumans.get(i);
                this.ope.glueFeetToFloor((PhysicalHumanoid)pHuman, this.feetGlueJointGroup);
            }
        }
    }

    public void addDebugVisualisation(float[] offset) {
        if (this.hre == null) {
            throw new RuntimeException("Cannot add debug visualisation if no HmiRenderEnvironment is set in the loader XML ");
        }
        for (PhysicalHumanoid pHuman : this.getPhysicalHumans()) {
            VGLNode debugVGLNode = PhysicsDebugVisualisations.getPhysicalHumanDebugVisualisation((PhysicalHumanoid)pHuman);
            this.debugVGLNodes.add(debugVGLNode);
            this.hre.addDebugVisualisation(debugVGLNode);
            VJoint debugVJoint = new VJoint();
            this.debugVJoints.add(debugVJoint);
            debugVJoint.setTranslation(offset);
            debugVJoint.addChild(debugVGLNode.getRoot());
            this.hre.addWorldRenderChild(debugVJoint);
        }
    }

    private void removeDebugVisualisation() {
        for (VGLNode debugVGLNode : this.debugVGLNodes) {
            this.hre.removeDebugVisualisation(debugVGLNode);
        }
        for (VJoint debugVJoint : this.debugVJoints) {
            this.hre.removeWorldRenderChild(debugVJoint);
        }
    }

    @Override
    public Embodiment getEmbodiment() {
        return this;
    }

    @Override
    public ArrayList<VGLNode> getDebugVGLNodes() {
        return this.debugVGLNodes;
    }

    public ArrayList<VJoint> getDebugVJoints() {
        return this.debugVJoints;
    }
}

