/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.mixed.Connector;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.scheduler.SmartBodySchedulingStrategy;
import hmi.graphics.scenegraph.GNode;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.assembler.IDBranchAssembler;
import hmi.physics.assembler.IDSegmentAssembler;
import hmi.physics.assembler.PhysicalHumanoidAssembler;
import hmi.physics.assembler.PhysicalSegmentAssembler;
import hmi.physics.inversedynamics.IDBranch;
import hmi.physics.inversedynamics.IDSegment;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedSystemAssembler
extends XMLStructureAdapter {
    private Logger logger = LoggerFactory.getLogger((String)SmartBodySchedulingStrategy.class.getName());
    private PhysicalHumanoidAssembler pha;
    private ArrayList<IDBranchAssembler> idbas = new ArrayList();
    private VJoint human;
    private MixedSystem ms;

    public MixedSystemAssembler(VJoint h, PhysicalHumanoid p, MixedSystem m) {
        this.human = h;
        this.ms = m;
        this.pha = new PhysicalHumanoidAssembler(h, p);
    }

    private void addIDSegments(VJoint startJoint, GNode rootNode, IDBranchAssembler ba) {
        for (VJoint vj : startJoint.getChildren()) {
            IDSegment is = this.ms.createIDSegment();
            IDSegmentAssembler psa = new IDSegmentAssembler(this.human, is);
            psa.createFromGNode(rootNode, vj.getSid());
            ba.addPhysicalSegmentAssembler(psa);
            this.addIDSegments(vj, rootNode, ba);
        }
    }

    public IDBranchAssembler createBranchFromGNode(GNode rootNode, String idStartSegment) {
        IDBranch b = new IDBranch();
        IDSegment ps = this.ms.createIDSegment();
        IDSegmentAssembler psa = new IDSegmentAssembler(this.human, ps);
        psa.setRoot(true);
        psa.createFromGNode(rootNode, idStartSegment);
        IDBranchAssembler idba = new IDBranchAssembler(this.human, b);
        idba.setRootSegmentAssembler(psa);
        VJoint vj = this.human.getPart(idStartSegment);
        this.addIDSegments(vj, rootNode, idba);
        return idba;
    }

    public void createFromGNode(GNode node, String[] fdSegments, String rootSegment, JointType[] types, float[] axes, float[] limits1, float[] limits2, float[] limits3, String[] idSegments) {
        this.pha.createFromGNode(node, fdSegments, idSegments, rootSegment, types, axes, limits1, limits2, limits3);
        for (int i = 0; i < idSegments.length; ++i) {
            this.idbas.add(this.createBranchFromGNode(node, idSegments[i]));
        }
    }

    public void setup() {
        this.pha.setupJoints("HumanoidRoot");
        float[] p = new float[3];
        for (IDBranchAssembler idba : this.idbas) {
            idba.setup();
            idba.branch.setupSolver();
            idba.rootAssembler.startJoint.getPathTranslation(null, p);
            PhysicalSegment ps = null;
            if (this.pha.rootAssembler.endJoints.contains(idba.rootAssembler.startJoint)) {
                ps = this.pha.rootAssembler.segment;
            } else {
                for (PhysicalSegmentAssembler psa : this.pha.segmentAssemblers) {
                    if (!psa.endJoints.contains(idba.rootAssembler.startJoint)) continue;
                    ps = psa.segment;
                }
            }
            if (ps != null) {
                Connector c = new Connector(ps, p, 1.0f);
                this.ms.addBranch(idba.branch, c);
                continue;
            }
            this.logger.warn("Can't find PhysicalSegment {}", (Object)idba.rootAssembler.startJoint);
        }
        this.ms.setup();
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        return false;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            if (tokenizer.atSTag("PhysicalHumanoid")) {
                this.pha.readXML(tokenizer);
                this.logger.debug("Finished parsing physical humanoid");
                continue;
            }
            if (!tokenizer.atSTag("IDBranch")) continue;
            IDBranch b = new IDBranch();
            IDBranchAssembler idba = new IDBranchAssembler(this.human, b);
            idba.readXML(tokenizer);
            this.idbas.add(idba);
            this.logger.debug("Finished parsing physical branch with root {}", (Object)b.getRoot().name);
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        MixedSystemAssembler.appendNewLine((StringBuilder)buf);
        this.pha.appendXML(buf, fmt);
        MixedSystemAssembler.appendNewLine((StringBuilder)buf);
        for (IDBranchAssembler idba : this.idbas) {
            idba.appendXML(buf, fmt);
            MixedSystemAssembler.appendNewLine((StringBuilder)buf);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public String getXMLTag() {
        return "MixedSystem";
    }
}

