/*
 * Decompiled with CFR 0.152.
 */
package hmi.environment.vhloader.impl;

import hmi.bml.bridge.TCPIPToBMLRealizerAdapter;
import hmi.bml.bridge.ui.BridgeServerUI;
import hmi.bml.bridge.ui.FeedbackPanel;
import hmi.bml.bridge.ui.RealizerBridgeUI;
import hmi.environment.vhloader.ElckerlycRealizerLoader;
import hmi.environment.vhloader.ElckerlycVirtualHuman;
import hmi.environment.vhloader.Embodiment;
import hmi.environment.vhloader.EmbodimentLoader;
import hmi.environment.vhloader.Environment;
import hmi.environment.vhloader.JComponentEmbodiment;
import hmi.environment.vhloader.JComponentEnvironment;
import hmi.environment.vhloader.Loader;
import hmi.environment.vhloader.impl.ElckerlycRealizerEnvironment;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFrameEmbodiment
implements JComponentEmbodiment,
EmbodimentLoader {
    private Logger logger = LoggerFactory.getLogger((String)JFrameEmbodiment.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private JComponentEnvironment jce = null;
    private ElckerlycRealizerEnvironment ere = null;
    private JButton toggleUI = null;
    private ElckerlycRealizerLoader theRealizerLoader = null;
    private ElckerlycVirtualHuman theVirtualHuman = null;
    private JButton killVH;
    private JFrame theUI = null;
    private JPanel contentPanel;
    private String id = "";

    public JFrameEmbodiment() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrameEmbodiment.this.contentPanel = new JPanel();
                }
            });
        }
        catch (InterruptedException e) {
            this.logger.warn("Exception constructing contentPanel", (Throwable)e);
            Thread.interrupted();
        }
        catch (InvocationTargetException e) {
            this.logger.warn("Exception constructing contentPanel", (Throwable)e);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, ElckerlycVirtualHuman evh, ElckerlycRealizerLoader realizerLoader, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.setId(newId);
        this.theRealizerLoader = realizerLoader;
        this.theVirtualHuman = evh;
        for (Environment e : environments) {
            if (e instanceof JComponentEnvironment) {
                this.jce = (JComponentEnvironment)e;
            }
            if (!(e instanceof ElckerlycRealizerEnvironment)) continue;
            this.ere = (ElckerlycRealizerEnvironment)e;
        }
        final XMLTokenizer tok = tokenizer;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrameEmbodiment.this.theUI = new JFrame(JFrameEmbodiment.this.theRealizerLoader.getName());
                    JFrameEmbodiment.this.theUI.setLocation(650, 50);
                    JFrameEmbodiment.this.theUI.setSize(600, 500);
                    JFrameEmbodiment.this.theUI.setDefaultCloseOperation(1);
                    JFrameEmbodiment.this.theUI.setVisible(true);
                    JFrameEmbodiment.this.contentPanel.setLayout(new BoxLayout(JFrameEmbodiment.this.contentPanel, 3));
                    JFrameEmbodiment.this.contentPanel.setAlignmentX(0.0f);
                    JFrameEmbodiment.this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    JFrameEmbodiment.this.theUI.getContentPane().add(JFrameEmbodiment.this.contentPanel);
                    JFrameEmbodiment.this.toggleUI = new JButton(JFrameEmbodiment.this.theRealizerLoader.getName());
                    JFrameEmbodiment.this.toggleUI.addActionListener(new ToggleVHUIListener());
                    JFrameEmbodiment.this.jce.addJComponent(JFrameEmbodiment.this.toggleUI);
                    try {
                        while (!tok.atETag("Loader")) {
                            JFrameEmbodiment.this.readSection(tok);
                        }
                    }
                    catch (IOException e) {
                        JFrameEmbodiment.this.logger.warn("IOException reading section", (Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            this.logger.warn("Exception JFrameEmbodiment from XML", (Throwable)e);
            Thread.interrupted();
        }
        catch (InvocationTargetException e) {
            this.logger.warn("Exception JFrameEmbodiment from XML", (Throwable)e);
        }
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("ServerUI")) {
            TCPIPToBMLRealizerAdapter theServer = this.theRealizerLoader.getTCPIPRealizerBridgeServer();
            BridgeServerUI bsui = null;
            bsui = theServer == null ? new BridgeServerUI(this.theRealizerLoader.getRealizerBridge(), 7521, 1257) : new BridgeServerUI(this.theRealizerLoader.getRealizerBridge(), theServer);
            this.addJComponent((JComponent)bsui);
            tokenizer.takeSTag("ServerUI");
            tokenizer.takeETag("ServerUI");
        } else if (tokenizer.atSTag("BmlUI")) {
            attrMap = tokenizer.getAttributes();
            String demoscriptdir = this.adapter.getOptionalAttribute("demoscriptresources", attrMap, "bml/defaultexamples");
            this.addJComponent((JComponent)new RealizerBridgeUI(this.theRealizerLoader.getRealizerBridge(), demoscriptdir));
            tokenizer.takeSTag("BmlUI");
            tokenizer.takeETag("BmlUI");
        } else if (tokenizer.atSTag("FeedbackUI")) {
            this.addJComponent((JComponent)new FeedbackPanel(this.theRealizerLoader.getRealizerBridge()));
            tokenizer.takeSTag("FeedbackUI");
            tokenizer.takeETag("FeedbackUI");
        } else if (tokenizer.atSTag("KillButton")) {
            this.killVH = new JButton("KILL VH");
            this.killVH.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFrameEmbodiment.this.theVirtualHuman.unload();
                }
            });
            this.addJComponent(this.killVH);
            tokenizer.takeSTag("KillButton");
            tokenizer.takeETag("KillButton");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    @Override
    public void unload() {
        this.jce.removeJComponent(this.toggleUI);
        this.pullThePlug();
    }

    @Override
    public void addJComponent(JComponent jc) {
        jc.setAlignmentX(0.0f);
        this.contentPanel.add(jc);
    }

    @Override
    public void removeJComponent(JComponent jc) {
        this.contentPanel.remove(jc);
    }

    @Override
    public Embodiment getEmbodiment() {
        return this;
    }

    public void pullThePlug() {
        this.theUI.setDefaultCloseOperation(2);
        WindowEvent wev = new WindowEvent(this.theUI, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }

    class ToggleVHUIListener
    implements ActionListener {
        ToggleVHUIListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JFrameEmbodiment.this.theUI.isShowing()) {
                JFrameEmbodiment.this.theUI.setVisible(false);
            } else {
                JFrameEmbodiment.this.theUI.setVisible(true);
            }
        }
    }
}

